/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MuleSelectionBorder;
import org.mule.tooling.messageflow.figure.CssAwareMoveHandle;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.ui.MuleGhostImageFigure;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class MuleSelectionEditPolicy
extends NonResizableEditPolicy {
    private static final String SELECTION_BORDER = "selection-border";
    private List<?> hoverHandles = null;
    private boolean isSelected = false;
    private boolean hidden;

    protected void addSelectionHandles() {
        this.isSelected = true;
        this.removeHoverHandles();
        this.removeSelectionHandles();
        GridLayer layer = (GridLayer)this.getLayer("Grid Layer");
        layer.setVisible(true);
        this.handles = this.createSelectionHandles();
        int i = 0;
        while (i < this.handles.size()) {
            layer.add((IFigure)this.handles.get(i));
            ++i;
        }
    }

    protected void removeSelectionHandles() {
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Grid Layer");
        int i = 0;
        while (i < this.handles.size()) {
            IFigure figure = (IFigure)this.handles.get(i);
            layer.remove(figure);
            ++i;
        }
        MessageFlowUtils.fireDisposedIFigureEvent(this.handles);
        this.handles = null;
    }

    protected void setSelectedState(int type) {
        if (type == 0) {
            this.hidden = true;
            this.hideSelection();
        } else {
            if (this.hidden) {
                super.setSelectedState(Integer.MIN_VALUE);
                this.hidden = false;
            }
            super.setSelectedState(type);
        }
    }

    protected void hideSelection() {
        this.isSelected = false;
        this.removeHoverHandles();
        super.hideSelection();
    }

    protected List<Handle> createSelectionHandles() {
        MessageFlowNode node;
        ArrayList<Handle> result = new ArrayList<Handle>();
        DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getHost());
        EntityEditPart entityEditPart = (EntityEditPart)this.getHost();
        IMuleModuleManager moduleManager = entityEditPart.getMuleProject().getModuleManager();
        Object entity = entityEditPart.getEntity();
        String cssClass = "";
        if (entity instanceof MessageFlowNode && (node = (MessageFlowNode)entity).getDefinition() != null) {
            Optional category = moduleManager.getCategory(node.getDefinition().getCategoryId());
            cssClass = ((CategoryDefinition)category.get()).getId().replace(".", "-");
        }
        result.add(this.moveHandle(this.getHost(), (DragTracker)tracker, cssClass));
        return result;
    }

    Handle moveHandle(GraphicalEditPart owner, DragTracker tracker, String cssClass) {
        CssAwareMoveHandle moveHandle = new CssAwareMoveHandle(this.getHost());
        moveHandle.setBorder((Border)new MuleSelectionBorder(ColorConstants.black));
        moveHandle.setDragTracker(tracker);
        moveHandle.setOpaque(false);
        moveHandle.setCursor(Cursors.SIZEALL);
        moveHandle.setCssClass(cssClass);
        ThemeUtils.applyStylingTo((IFigure)moveHandle);
        return moveHandle;
    }

    public void showTargetFeedback(Request request) {
        if ("selection".equals(request.getType()) && this.getHost() instanceof EntityEditPart && !this.isSelected) {
            this.addHoverHandles();
        }
        super.showTargetFeedback(request);
    }

    private void addHoverHandles() {
        if (this.hoverHandles != null) {
            return;
        }
        this.removeHoverHandles();
        GridLayer layer = (GridLayer)this.getLayer("Grid Layer");
        layer.setVisible(true);
        this.hoverHandles = this.createHoverHandles();
        int i = 0;
        while (i < this.hoverHandles.size()) {
            layer.add((IFigure)this.hoverHandles.get(i));
            ++i;
        }
    }

    private List<Handle> createHoverHandles() {
        ArrayList<Handle> result = new ArrayList<Handle>();
        SelectEditPartTracker tracker = new SelectEditPartTracker((EditPart)this.getHost());
        result.add(this.moveHandle(this.getHost(), (DragTracker)tracker, SELECTION_BORDER));
        return result;
    }

    private void removeHoverHandles() {
        if (this.hoverHandles == null) {
            return;
        }
        IFigure layer = this.getLayer("Grid Layer");
        int i = 0;
        while (i < this.hoverHandles.size()) {
            IFigure figure = (IFigure)this.hoverHandles.get(i);
            layer.remove(figure);
            ++i;
        }
        MessageFlowUtils.fireDisposedIFigureEvent(this.hoverHandles);
        this.hoverHandles = null;
    }

    public void eraseTargetFeedback(Request request) {
        if ("selection".equals(request.getType()) && this.getHost() instanceof EntityEditPart) {
            this.removeHoverHandles();
        }
        super.showTargetFeedback(request);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        MuleGhostImageFigure feedback;
        if (!(((EntityDecorator)this.getHost().getModel()).getEntity() instanceof MessageFlowNode)) {
            ImageDescriptor desc = ImagesManager.getInstance().getPaletteUnknownDescriptor();
            feedback = new MuleGhostImageFigure(desc, 100, null);
        } else {
            EntityEditPart host = (EntityEditPart)this.getHost();
            Image resultImage = MessageFlowUtils.getImageToExport(host);
            ImageData imageData = resultImage.getImageData();
            resultImage.dispose();
            if (imageData != null) {
                ImageDescriptor desc = ImageDescriptor.createFromImageData((ImageData)imageData);
                feedback = new MuleGhostImageFigure(desc, 100, null);
            } else {
                feedback = null;
            }
        }
        feedback.setForegroundColor(ColorConstants.white);
        this.addFeedback((IFigure)feedback);
        return feedback;
    }
}

