/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.messageflow.figure.FigureColorRegistry;

public class MuleSelectionBorder
extends AbstractBorder {
    private Color selectionColor = FigureColorRegistry.getDefault().get("selection.border");
    private Color backgroundColor = FigureColorRegistry.getDefault().get("selection.background");
    private int borderWidth = 1;
    private int arcWidth = 0;
    private int arcHeight = 0;
    private int alpha = 255;

    public MuleSelectionBorder(Color selectionColor) {
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(4);
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(MuleSelectionBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        MuleSelectionBorder.tempRect.width -= 2;
        MuleSelectionBorder.tempRect.height -= 2;
        ++MuleSelectionBorder.tempRect.x;
        ++MuleSelectionBorder.tempRect.y;
        graphics.setForegroundColor(this.getSelectionColor());
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.setLineWidth(this.getBorderWidth());
        if (!this.getBackgroundColor().getRGB().equals((Object)ColorConstants.white.getRGB())) {
            graphics.fillRoundRectangle(tempRect, this.getArcWidth(), this.getArcHeight());
        }
        graphics.drawRoundRectangle(tempRect, this.getArcWidth(), this.getArcHeight());
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }
}

