/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.messageflow.command.CloneEntityCommand;
import org.mule.tooling.messageflow.command.IMessageFlowEntityFactory;
import org.mule.tooling.messageflow.command.InitialContainerCreateCommand;
import org.mule.tooling.messageflow.command.InitialEndpointCreateCommand;
import org.mule.tooling.messageflow.command.InitialInputNodeCreateCommand;
import org.mule.tooling.messageflow.command.InitialProcessNodeCreateCommand;
import org.mule.tooling.messageflow.command.MessageFlowEntityAdapterManager;
import org.mule.tooling.messageflow.command.MessageFlowEntityFactoryManager;
import org.mule.tooling.messageflow.command.MoveEntityCommand;
import org.mule.tooling.messageflow.command.ReorderFlowCommand;
import org.mule.tooling.messageflow.command.ReparentEntityToANewContainerCommand;
import org.mule.tooling.messageflow.command.TransactionalCompoundCommand;
import org.mule.tooling.messageflow.editor.DefinitionsHelper;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.EndpointEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.editpart.MuleSelectionEditPolicy;
import org.mule.tooling.messageflow.editpart.PatternEditPart;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.exception.NullFactoryArgumentException;
import org.mule.tooling.messageflow.util.CloneEntityVisitor;
import org.mule.tooling.messageflow.util.FlowContainerUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.MuleConfigurationNodeDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionResolver;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;
import org.mule.tooling.utils.ObjectHolder;

public class MuleConfigurationLayoutEditPolicy
extends FlowLayoutEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        Object newObject;
        ObjectHolder command = new ObjectHolder();
        try {
            newObject = request.getNewObject();
        }
        catch (IllegalArgumentException e) {
            throw new NullFactoryArgumentException(e.getMessage());
        }
        int insertPosition = this.getInsertPositionOfFlow(request);
        if (newObject instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)newObject;
            NodeDefinition configDefinition = MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/mule");
            boolean acceptedByMuleConfig = nodeDefinition.getAcceptedByFilter().accepts((IMessageFlowNode)this.getMuleConfiguration(), configDefinition, ModuleManagerNodeDefinitionResolver.get());
            NodeDefinition flowDefinition = MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/flow");
            boolean acceptedByFlow = nodeDefinition.getAcceptedByFilter().accepts((IMessageFlowNode)this.getMuleConfiguration(), flowDefinition, ModuleManagerNodeDefinitionResolver.get());
            if (!acceptedByMuleConfig && !acceptedByFlow) {
                return null;
            }
            nodeDefinition.accept((NodeDefinitionVisitor)new CommandFactory((ObjectHolder<Command>)command, insertPosition));
        }
        return (Command)command.get();
    }

    protected Command getCloneCommand(ChangeBoundsRequest req) {
        ChangeBoundsRequest request = req;
        List editParts = request.getEditParts();
        TransactionalCompoundCommand command = new TransactionalCompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createCloneCommand(child, this.getInsertionReference((Request)request)));
            if (editParts.size() > 1) {
                this.adjustIndexes(command);
            }
            ++i;
        }
        return command.unwrap();
    }

    private Command createCloneCommand(EditPart child, EditPart after) {
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        NodeDefinition elementToCloneDefinition = MessageFlowUtils.getDefinition(messageFlowEntity);
        NodeDefinition configDefinition = MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/mule");
        if (!elementToCloneDefinition.getAcceptedByFilter().accepts((IMessageFlowNode)this.getMuleConfiguration(), configDefinition, ModuleManagerNodeDefinitionResolver.get())) {
            return null;
        }
        if (!(child instanceof EndpointEditPart || child instanceof PatternEditPart || MessageFlowUtils.isFlowOrSubflowEditPart(child) || this.isException(messageFlowEntity) || child instanceof ContainerEditPart)) {
            return null;
        }
        CloneEntityCommand cloneEntityCommand = this.createCloneEntityCommand(messageFlowEntity);
        if (after != null) {
            IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)after.getModel()).getEntity();
            cloneEntityCommand.setAfterMessageFlowEntity(afterMessageFlowEntity);
        } else {
            cloneEntityCommand.setAfterMessageFlowEntity(null);
        }
        return cloneEntityCommand;
    }

    private CloneEntityCommand createCloneEntityCommand(IMessageFlowEntity messageFlowEntity) {
        ContainerOfMovableEntities model = (ContainerOfMovableEntities)this.getHost().getModel();
        CloneEntityVisitor cloneEntityVisitor = new CloneEntityVisitor(model, this.getMuleConfiguration(), MuleCorePlugin.getDesignContext().getMuleProject());
        CloneEntityCommand cloneEntityCommand = null;
        if (!(ModelUtils.isFlowOrSubflow((IMessageFlowEntity)messageFlowEntity) || ModelUtils.isBatch((IMessageFlowEntity)messageFlowEntity) || ModelUtils.isTest((IMessageFlowEntity)messageFlowEntity))) {
            if (this.isException(messageFlowEntity)) {
                cloneEntityCommand = new CloneEntityCommand(model, messageFlowEntity, cloneEntityVisitor);
            } else {
                MuleConfiguration config = this.getMuleConfiguration();
                Container flow = FlowContainerUtils.createFlow(config);
                CompartmentLane processLane = null;
                IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
                if (messageFlowEntity instanceof MessageFlowNode) {
                    MessageFlowNode messageFlowNode = (MessageFlowNode)messageFlowEntity;
                    NodeDefinition nodeDefinition = messageFlowNode.getDefinition();
                    INodeDefinitionFilter acceptedByFilter = nodeDefinition.getAcceptedByFilter();
                    INodeDefinitionResolver resolver = ModuleManagerNodeDefinitionResolver.get();
                    NestedContainerDefinition inputDefinition = (NestedContainerDefinition)moduleManager.getDefinition("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
                    NestedContainer flowInput = flow.getNestedContainer("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
                    processLane = messageFlowEntity instanceof EndpointNode ? (((EndpointNode)messageFlowEntity).isInbound() ? (CompartmentLane)flow.getLanes().get(0) : (CompartmentLane)flow.getLanes().get(1)) : (acceptedByFilter.accepts((IMessageFlowNode)config, (NodeDefinition)inputDefinition, resolver) && inputDefinition.getAcceptsFilter().accepts((IMessageFlowNode)flowInput, nodeDefinition, resolver) ? (CompartmentLane)flow.getLanes().get(0) : (CompartmentLane)flow.getLanes().get(1));
                    CompartmentLaneDecorator decorator = new CompartmentLaneDecorator(processLane, true);
                    decorator.addEntity(messageFlowEntity);
                    cloneEntityCommand = new CloneEntityCommand((ContainerOfMovableEntities)this.getHost().getModel(), (IMessageFlowEntity)flow, cloneEntityVisitor);
                }
            }
        } else {
            cloneEntityCommand = new CloneEntityCommand(model, messageFlowEntity, cloneEntityVisitor);
        }
        return cloneEntityCommand;
    }

    private void adjustIndexes(CompoundCommand compoundCommand) {
        List commands = compoundCommand.getCommands();
        int i = 1;
        while (i < commands.size()) {
            MoveEntityCommand addCommand = (MoveEntityCommand)commands.get(i);
            addCommand.setIndex(((MoveEntityCommand)commands.get(i - 1)).getIndex() + 1);
            ++i;
        }
    }

    private int getInsertPositionOfFlow(CreateRequest request) {
        MuleConfigurationDecorator config = (MuleConfigurationDecorator)this.getHost().getModel();
        List flowsInConfig = ((MuleConfiguration)config.getEntity()).getFlows();
        if (flowsInConfig.size() > 0) {
            EditPart insertionEditPart = this.getInsertionReference((Request)request);
            if (insertionEditPart != null && insertionEditPart.getModel() instanceof ContainerDecorator) {
                Container afterFlow = (Container)((ContainerDecorator)insertionEditPart.getModel()).getEntity();
                return config.findEntityIndex((IMessageFlowEntity)afterFlow);
            }
            return flowsInConfig.size();
        }
        return 0;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new MuleSelectionEditPolicy();
    }

    protected MuleConfiguration getMuleConfiguration() {
        return (MuleConfiguration)this.getConfigDecorator().getEntity();
    }

    protected MuleConfigurationDecorator getConfigDecorator() {
        MuleConfigurationEditPart configEditPart = (MuleConfigurationEditPart)this.getHost();
        return (MuleConfigurationDecorator)configEditPart.getEntityDecorator();
    }

    protected Command getAddCommand(Request req) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        List editParts = request.getEditParts();
        if (editParts.size() > 1) {
            return null;
        }
        TransactionalCompoundCommand command = new TransactionalCompoundCommand();
        int j = editParts.size() - 1;
        while (j >= 0) {
            EditPart child = (EditPart)editParts.get(j);
            command.add(this.createAddCommand(child, this.getInsertionReference((Request)request)));
            --j;
        }
        return command.unwrap();
    }

    private boolean isAcceptedEditPart(EditPart child) {
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        if (ModelUtils.isUnknownNode((IMessageFlowEntity)messageFlowEntity) || ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity)) {
            return false;
        }
        String type = MessageFlowUtils.getType(messageFlowEntity);
        Object definition = null;
        definition = messageFlowEntity instanceof IMessageFlowNode ? ((IMessageFlowNode)messageFlowEntity).getDefinition() : MuleCorePlugin.getModuleManager().getNestedDefinition(type);
        boolean acceptedByFilter = definition.getAcceptedByFilter().accepts((IMessageFlowNode)this.getMuleConfiguration(), (NodeDefinition)MuleConfigurationNodeDefinition.get(), ModuleManagerNodeDefinitionResolver.get());
        if (!acceptedByFilter) {
            return false;
        }
        return child instanceof ContainerEditPart;
    }

    public Command createAddCommand(EditPart child, EditPart after) {
        EntityDecorator entityDecorator = (EntityDecorator)child.getParent().getModel();
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        boolean hasAdapter = MessageFlowEntityAdapterManager.get().hasAdapter((NodeDefinition)MuleConfigurationNodeDefinition.get(), messageFlowEntity);
        if (this.getHost().getModel() == entityDecorator || !this.isAcceptedEditPart(child) && !hasAdapter) {
            return null;
        }
        ContainerOfMovableEntities muleConfigurationDecorator = (ContainerOfMovableEntities)this.getHost().getModel();
        ContainerOfMovableEntities oldContainer = (ContainerOfMovableEntities)entityDecorator;
        ReparentEntityToANewContainerCommand reparentEntityToANewCreatedFlowCommand = new ReparentEntityToANewContainerCommand(muleConfigurationDecorator, messageFlowEntity, this.getMuleConfiguration());
        if (after != null) {
            IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)after.getModel()).getEntity();
            reparentEntityToANewCreatedFlowCommand.setAfterMessageFlowEntity(afterMessageFlowEntity);
        } else {
            reparentEntityToANewCreatedFlowCommand.setAfterMessageFlowEntity(null);
        }
        reparentEntityToANewCreatedFlowCommand.setOldContainer(oldContainer);
        EditPart compartmentEditPart = child.getParent().getParent();
        if (compartmentEditPart.getParent() != null && compartmentEditPart.getParent() instanceof SplitterEditPart) {
            reparentEntityToANewCreatedFlowCommand.setSplitter(true);
        }
        reparentEntityToANewCreatedFlowCommand.setRootEditPart((EditPart)compartmentEditPart.getParent().getRoot());
        reparentEntityToANewCreatedFlowCommand.setOldCompartment(compartmentEditPart.getModel());
        Object compartment = this.getHost().getParent().getModel();
        reparentEntityToANewCreatedFlowCommand.setCompartment(compartment);
        return reparentEntityToANewCreatedFlowCommand;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        if (child == after || this.getHost().getChildren().size() == 1) {
            return null;
        }
        ContainerOfMovableEntities muleConfigurationDecorator = (ContainerOfMovableEntities)this.getHost().getModel();
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        ReorderFlowCommand cmd = new ReorderFlowCommand(muleConfigurationDecorator, messageFlowEntity);
        if (after != null) {
            IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)after.getModel()).getEntity();
            ((MoveEntityCommand)cmd).setAfterMessageFlowEntity(afterMessageFlowEntity);
        } else {
            ((MoveEntityCommand)cmd).setAfterMessageFlowEntity(null);
        }
        return cmd;
    }

    private boolean isException(IMessageFlowEntity entity) {
        if (!(entity instanceof MessageFlowNode)) {
            return false;
        }
        IMessageFlowNode mn = (IMessageFlowNode)entity;
        NodeDefinition definition = MuleCorePlugin.getModuleManager().getDefinition(mn.getType());
        return definition.getCategoryId().equals(Category.EXCEPTIONS.getCategoryString()) && !definition.getId().equals("http://www.mulesoft.org/schema/mule/core/raise-error");
    }

    private final class CommandFactory
    extends NodeDefinitionVisitorAdapter {
        private final ObjectHolder<Command> command;
        private final int insertPosition;

        private CommandFactory(ObjectHolder<Command> command, int insertPosition) {
            this.command = command;
            this.insertPosition = insertPosition;
        }

        public void visitPatternDefinition(PatternDefinition patternDefinition) {
            String id = patternDefinition.getId();
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)MuleConfigurationLayoutEditPolicy.this.getMuleConfiguration());
            if (DefinitionsHelper.hasEndpointAlternative(id)) {
                String endpointId = DefinitionsHelper.getEndpointAlternative(id);
                EndpointDefinition definition = (EndpointDefinition)MuleCorePlugin.getModuleManager().getDefinition(endpointId);
                EndpointNode node = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)definition, (EndpointDirection)EndpointDirection.INBOUND);
                this.command.set((Object)new InitialEndpointCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), (MessageFlowNode)node, definition, this.insertPosition));
            } else {
                Object node = patternDefinition.isCausesSplit() ? MessageFlowFactory.createSplitterNode((IFlowTransformerContext)context, (NodeDefinition)patternDefinition) : MessageFlowFactory.createPatternNode((IFlowTransformerContext)context, (NodeDefinition)patternDefinition);
                this.command.set((Object)new InitialProcessNodeCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), (IMessageFlowNode)node, this.insertPosition));
            }
        }

        public void visitSplitterDefinition(SplitterDefinition splitterDefinition) {
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)MuleConfigurationLayoutEditPolicy.this.getMuleConfiguration());
            SplitterNode node = MessageFlowFactory.createSplitterNode((IFlowTransformerContext)context, (NodeDefinition)splitterDefinition);
            this.command.set((Object)new InitialProcessNodeCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), (IMessageFlowNode)node, this.insertPosition));
        }

        public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
            boolean outboundOnlyEndpoint = !endpointDefinition.isSupportsInbound() && endpointDefinition.isSupportsOutbound();
            MuleConfiguration config = MuleConfigurationLayoutEditPolicy.this.getMuleConfiguration();
            IMessageFlowEntityFactory factory = new MessageFlowEntityFactoryManager().getFactory((MessageFlowEntity)config, (NodeDefinition)endpointDefinition);
            EndpointNode node = (EndpointNode)factory.create(config, (IMessageFlowEntity)config, (NodeDefinition)endpointDefinition, null, null);
            if (outboundOnlyEndpoint) {
                this.command.set((Object)new InitialProcessNodeCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), (IMessageFlowNode)node, this.insertPosition));
            } else {
                this.command.set((Object)new InitialEndpointCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), (MessageFlowNode)node, endpointDefinition, this.insertPosition));
            }
        }

        public void visitContainerDefinition(ContainerDefinition containerDefinition) {
            INodeDefinitionFilter acceptedByFilter = containerDefinition.getAcceptedByFilter();
            INodeDefinitionResolver resolver = ModuleManagerNodeDefinitionResolver.get();
            MuleConfiguration config = MuleConfigurationLayoutEditPolicy.this.getMuleConfiguration();
            IMessageFlowEntityFactory factory = new MessageFlowEntityFactoryManager().getFactory((MessageFlowEntity)config, (NodeDefinition)containerDefinition);
            IMessageFlowNode createdNode = factory.create(config, (IMessageFlowEntity)config, (NodeDefinition)containerDefinition, null, null);
            IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
            NodeDefinition createdNodeDefinition = createdNode.getDefinition();
            if (createdNodeDefinition.getAcceptedByFilter().accepts((IMessageFlowNode)config, (NodeDefinition)MuleConfigurationNodeDefinition.get(), resolver)) {
                this.command.set((Object)new InitialContainerCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), containerDefinition, this.insertPosition, createdNode));
                return;
            }
            Container flow = FlowContainerUtils.createFlow(config);
            NestedContainerDefinition inputDefinition = (NestedContainerDefinition)moduleManager.getDefinition("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
            NestedContainer flowInput = flow.getNestedContainer("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
            if (acceptedByFilter.accepts((IMessageFlowNode)config, (NodeDefinition)inputDefinition, resolver) && inputDefinition.getAcceptsFilter().accepts((IMessageFlowNode)flowInput, (NodeDefinition)containerDefinition, resolver)) {
                this.command.set((Object)new InitialInputNodeCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), createdNode, this.insertPosition));
                return;
            }
            NestedContainerDefinition processDefinition = (NestedContainerDefinition)moduleManager.getDefinition("http://www.mulesoft.org/schema/mule/core/messageProcessorsLane");
            NestedContainer flowProcess = flow.getNestedContainer("http://www.mulesoft.org/schema/mule/core/messageProcessorsLane");
            if (acceptedByFilter.accepts((IMessageFlowNode)config, (NodeDefinition)processDefinition, resolver) && processDefinition.getAcceptsFilter().accepts((IMessageFlowNode)flowProcess, (NodeDefinition)containerDefinition, resolver)) {
                this.command.set((Object)new InitialProcessNodeCreateCommand(MuleConfigurationLayoutEditPolicy.this.getConfigDecorator(), createdNode, this.insertPosition));
                return;
            }
        }
    }
}

