/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationLayoutEditPolicy;
import org.mule.tooling.messageflow.figure.MessageFlowFigure;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MessageToUserNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MessageToUserNodeDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;

public class MuleConfigurationEditPart
extends EntityEditPart<MuleConfiguration> {
    private IProject project;
    private List<EntityDecorator<?>> displayModel;
    static boolean turnOfUpdates;

    public MuleConfigurationEditPart(MuleConfigurationDecorator decorator, IMuleProject project) {
        super(decorator);
        this.project = project.getProject();
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        return this;
    }

    @Override
    protected IFigure createFigure() {
        return new MessageFlowFigure();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new MuleConfigurationLayoutEditPolicy());
    }

    @Override
    public void update(Observable o, Object arg) {
        super.update(o, arg);
        if (turnOfUpdates) {
            return;
        }
        if ("flows".equals(arg) || "globals".equals(arg)) {
            this.flushModel();
            this.refreshChildren();
        }
    }

    protected List getModelChildren() {
        if (this.displayModel == null) {
            this.displayModel = this.buildDisplayModel();
        }
        return this.displayModel;
    }

    protected void flushModel() {
        this.displayModel = null;
    }

    protected List<EntityDecorator<?>> buildDisplayModel() {
        ArrayList model = new ArrayList();
        List flows = ((MuleConfiguration)this.getEntity()).getFlows();
        if (!flows.isEmpty()) {
            for (Container flow : flows) {
                model.add(MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)flow));
            }
        } else {
            MessageToUserNode messageToUserNode = new MessageToUserNode();
            messageToUserNode.setText("To get started, drag an operation or scope from the Mule Palette");
            model.add((EntityDecorator<?>)new MessageToUserNodeDecorator(messageToUserNode));
        }
        return model;
    }

    @Override
    public IMuleProject getMuleProject() {
        return MuleRuntime.create((IProject)this.project);
    }

    @Override
    public void applyErrors(Map<EntityEditPart<?>, List<MessageFlowEntityError>> errorsMap) {
        List children = this.getChildren();
        for (EditPart part : children) {
            if (!(part instanceof EntityEditPart)) continue;
            ((EntityEditPart)part).applyErrors(errorsMap);
        }
    }
}

