/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectAware;
import org.mule.tooling.messageflow.editpart.CollapsableNestedContainerFigureFactory;
import org.mule.tooling.messageflow.editpart.CollapsibleContainerEditPart;
import org.mule.tooling.messageflow.editpart.CommentEditPart;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.ConnectorEditPart;
import org.mule.tooling.messageflow.editpart.EndpointEditPart;
import org.mule.tooling.messageflow.editpart.MessageToUserEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerFigureFactory;
import org.mule.tooling.messageflow.editpart.PatternEditPart;
import org.mule.tooling.messageflow.editpart.RouteEditPart;
import org.mule.tooling.messageflow.editpart.RouterEditPart;
import org.mule.tooling.messageflow.editpart.SplitterCompartmentEditPart;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.editpart.UnknownEditPart;
import org.mule.tooling.messageflow.figure.FigureFactory;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CommentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.Connector;
import org.mule.tooling.model.messageflow.decorator.ContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.EndpointDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MessageToUserNodeDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.NestedContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.PatternDecorator;
import org.mule.tooling.model.messageflow.decorator.SplitterDecorator;
import org.mule.tooling.model.messageflow.decorator.UnknownDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.utils.ObjectHolder;

public class MessageFlowEditPartFactory
implements EditPartFactory {
    private IMuleProject project;
    private Map<String, EditPartFactory> customFactories;

    public MessageFlowEditPartFactory(IMuleProject project) {
        this.project = project;
        this.loadCustomFactories();
    }

    private void loadCustomFactories() {
        IConfigurationElement[] configurationElementsFor;
        this.customFactories = new HashMap<String, EditPartFactory>();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.editPartFactory");
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String[] types = configElement.getAttribute("type").split(",");
            EditPartFactory factory = null;
            try {
                factory = (EditPartFactory)configElement.createExecutableExtension("class");
                if (factory instanceof IMuleProjectAware) {
                    ((IMuleProjectAware)factory).setMuleProject(this.project);
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"Exception during factory loading", (Throwable)e);
            }
            if (factory != null) {
                String[] stringArray = types;
                int n3 = types.length;
                int n4 = 0;
                while (n4 < n3) {
                    String type = stringArray[n4];
                    this.customFactories.put(type.trim(), factory);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public EditPart createEditPart(final EditPart context, final Object model) {
        final ObjectHolder editPart = new ObjectHolder();
        if (model instanceof EntityDecorator) {
            String type;
            EntityDecorator decorator = (EntityDecorator)model;
            MessageFlowEntity entity = (MessageFlowEntity)decorator.getEntity();
            if (entity instanceof IMessageFlowNode && this.customFactories.containsKey(type = ((IMessageFlowNode)entity).getType())) {
                return this.customFactories.get(type).createEditPart(context, model);
            }
            entity.accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

                public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                    editPart.set((Object)new MuleConfigurationEditPart((MuleConfigurationDecorator)model, MessageFlowEditPartFactory.this.project));
                }

                public void visitContainer(Container container) {
                    CollapsibleContainerEditPart containerEditPart = new CollapsibleContainerEditPart((ContainerDecorator)model, MessageFlowEditPartFactory.this.project);
                    editPart.set((Object)containerEditPart);
                }

                public void visitNestedContainer(NestedContainer nestedContainer) {
                    NestedContainerDecorator decorator = (NestedContainerDecorator)model;
                    NestedContainerDefinition definition = (NestedContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition(((NestedContainer)decorator.getEntity()).getType());
                    FigureFactory<NestedContainer> figureFactory = definition.isCollapsable() ? new CollapsableNestedContainerFigureFactory(context) : new NestedContainerFigureFactory();
                    editPart.set((Object)new NestedContainerEditPart((NestedContainerDecorator)model, MessageFlowEditPartFactory.this.project, figureFactory));
                }

                public void visitCompartment(Compartment compartment) {
                    if (context instanceof SplitterEditPart) {
                        editPart.set((Object)new SplitterCompartmentEditPart((EntityDecorator<Compartment>)((CompartmentDecorator)model)));
                    } else {
                        editPart.set((Object)new CompartmentEditPart((EntityDecorator<Compartment>)((CompartmentDecorator)model)));
                    }
                }

                public void visitCompartmentLane(CompartmentLane lane) {
                    CompartmentLaneDecorator model2 = (CompartmentLaneDecorator)model;
                    if (editPart.isNull()) {
                        editPart.set((Object)new CompartmentLaneEditPart((CompartmentLaneDecorator<CompartmentLane>)model2, !model2.isHorizontal(), false));
                    }
                }

                public void visitRoute(Route route) {
                    CompartmentLaneDecorator model2 = (CompartmentLaneDecorator)model;
                    if (editPart.isNull()) {
                        editPart.set((Object)new RouteEditPart((CompartmentLaneDecorator<CompartmentLane>)model2));
                    }
                }

                public void visitEndpointNode(EndpointNode endpointNode) {
                    editPart.set((Object)new EndpointEditPart((EndpointDecorator)model));
                }

                public void visitPatternNode(PatternNode patternNode) {
                    editPart.set((Object)new PatternEditPart((PatternDecorator)model));
                }

                public void visitSplitterNode(SplitterNode splitterNode) {
                    NodeDefinition splitterDef = splitterNode.getDefinition();
                    if (splitterDef instanceof SplitterDefinition) {
                        editPart.set((Object)new RouterEditPart((SplitterDecorator)model));
                    } else {
                        editPart.set((Object)new SplitterEditPart((SplitterDecorator)model));
                    }
                }

                public void visitUnknownNode(UnknownNode unknownNode) {
                    editPart.set((Object)new UnknownEditPart((UnknownDecorator)model));
                }

                public void visitCommentNode(CommentContainer commentNode) {
                    editPart.set((Object)new CommentEditPart((CommentDecorator)model));
                }
            });
        }
        if (model instanceof Connector) {
            editPart.set((Object)new ConnectorEditPart((Connector)model));
        } else if (model instanceof MessageToUserNodeDecorator) {
            editPart.set((Object)new MessageToUserEditPart((MessageToUserNodeDecorator)model));
        }
        if (editPart.isNull()) {
            throw new RuntimeException("No EditPart available for type " + model.getClass().toString());
        }
        return (EditPart)editPart.get();
    }
}

