/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.figure.NodeFigure;
import org.mule.tooling.messageflow.layout.FlowDimensionsCalculator;
import org.mule.tooling.messageflow.util.MessageFlowUtils;

public class FixPointAnchor
extends AbstractConnectionAnchor {
    public FixPointAnchor(IFigure owner) {
        super(owner);
    }

    public Point getLocation(Point reference) {
        Rectangle bounds = this.getAbsoluteBounds(this.getOwner());
        int distanceToIconMiddleY = FixPointAnchor.zoomFactorScale(FlowDimensionsCalculator.calculateDistanceToMiddleY(this.getOwner()));
        if (reference == null) {
            return new Point(bounds.x, bounds.y + distanceToIconMiddleY);
        }
        if (this.referenceisInResponse(reference, bounds)) {
            return new Point(bounds.getBottom());
        }
        Rectangle iconBounds = this.getNodeFigureIconBounds(bounds);
        if (this.isRightAnchor(reference, bounds)) {
            return new Point(iconBounds.x + iconBounds.width + 4, bounds.y + distanceToIconMiddleY);
        }
        return new Point(iconBounds.x - 4, bounds.y + distanceToIconMiddleY);
    }

    private Rectangle getNodeFigureIconBounds(Rectangle r) {
        NodeFigure nodeFigure;
        if (this.getOwner() instanceof NodeFigure && (nodeFigure = (NodeFigure)this.getOwner()).isActive()) {
            return this.getAbsoluteBounds((IFigure)nodeFigure.getImageFigure());
        }
        return r;
    }

    private boolean referenceisInResponse(Point reference, Rectangle r) {
        return reference.y > r.y + r.height;
    }

    private boolean isRightAnchor(Point reference, Rectangle r) {
        return reference.x > r.x;
    }

    public Point getReferencePoint() {
        Rectangle r = this.getAbsoluteBounds(this.getOwner());
        int distanceToIconMiddleY = FixPointAnchor.zoomFactorScale(FlowDimensionsCalculator.calculateDistanceToMiddleY(this.getOwner()));
        return new Point(r.getTop().x, r.getTop().y + distanceToIconMiddleY);
    }

    protected Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle rectangle = new Rectangle(figure.getBounds());
        figure.translateToAbsolute((Translatable)rectangle);
        return rectangle;
    }

    private static int zoomFactorScale(int distanceToIconMiddleY) {
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)flowEditorFromActivePage.getViewer();
            ScalableRootEditPart editPart = (ScalableRootEditPart)viewer.getRootEditPart();
            ZoomManager zoomManager = editPart.getZoomManager();
            double zoom = zoomManager.getZoom();
            distanceToIconMiddleY = (int)Math.round((double)distanceToIconMiddleY * zoom);
        }
        return distanceToIconMiddleY;
    }
}

