/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.IHasContentFigure;
import org.mule.tooling.messageflow.figure.CompartmentLaneLayout;
import org.mule.tooling.messageflow.layout.FlowDimensions;
import org.mule.tooling.messageflow.layout.FlowInputLayout;
import org.mule.tooling.messageflow.layout.FlowProcessLayout;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.NodeDefinition;

public abstract class FeedbackAwareLayoutEditPolicy
extends OrderedLayoutEditPolicy {
    protected IFigure feedbackFigure;

    protected int getFeedbackIndexFor(Request request) {
        return 0;
    }

    protected Rectangle getAbsoluteBounds(GraphicalEditPart entity) {
        Rectangle bounds = entity.getFigure().getBounds().getCopy();
        entity.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation().getCopy();
    }

    protected boolean canShowLayoutFeedback(Request request) {
        return true;
    }

    protected double getZoom() {
        if (this.getHost().getRoot() instanceof ScalableRootEditPart) {
            return ((ScalableRootEditPart)this.getHost().getRoot()).getZoomManager().getZoom();
        }
        return 1.0;
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!this.canShowLayoutFeedback(request)) {
            return;
        }
        double zoom = this.getZoom();
        Figure editPartFigure = this.getHostFigure() instanceof IHasContentFigure ? (Figure)((IHasContentFigure)this.getHostFigure()).getContentFigure() : (Figure)this.getHostFigure();
        Rectangle rectangle = MessageFlowUtils.getFlowEditorScrollOffset();
        IFigure feedback = this.getFeedbackIndicator(request);
        Dimension fbSize = feedback.getPreferredSize();
        Rectangle editPartBounds = editPartFigure.getBounds();
        int x = editPartBounds.width / 2 + editPartBounds.x() - fbSize.width / 2;
        int y = editPartBounds.y() + editPartBounds.height / 2 - fbSize.height / 2;
        double middleY = (double)(editPartBounds.y() + editPartBounds.height / 2) * zoom;
        LayoutManager layoutManager = editPartFigure.getLayoutManager();
        if (layoutManager instanceof FlowInputLayout || layoutManager instanceof CompartmentLaneLayout) {
            feedback.setBounds(new Rectangle(x, y, fbSize.width, fbSize.height));
        } else if (layoutManager instanceof FlowProcessLayout) {
            FlowProcessLayout layout = (FlowProcessLayout)layoutManager;
            FlowDimensions flowDimensions = layout.getFlowDimensions();
            if (flowDimensions.getResponseHeight() == 0) {
                feedback.setBounds(new Rectangle(x, y, fbSize.width, fbSize.height));
            } else if ((double)(this.getLocationFromRequest((Request)request).y + rectangle.y) > middleY) {
                y = editPartBounds.y() + editPartBounds.height * 3 / 4 - fbSize.height / 2;
                feedback.setBounds(new Rectangle(x, y, fbSize.width, fbSize.height));
            } else {
                y = editPartBounds.y() + editPartBounds.height / 4 - fbSize.height / 2;
                feedback.setBounds(new Rectangle(x, y, fbSize.width, fbSize.height));
            }
        }
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    public IFigure getFeedbackIndicator(Request request) {
        Image feedbackImage = null;
        this.removePreExistingFeedbackFigure(request);
        if (this.feedbackFigure == null) {
            if (request instanceof CreateRequest) {
                Object template = ((CreateRequest)request).getNewObject();
                if (template instanceof NodeDefinition) {
                    NodeDefinition nodeDef = (NodeDefinition)template;
                    feedbackImage = nodeDef.getIconImage();
                }
            } else {
                feedbackImage = this.getFeedbackOfMovementRequest(request);
            }
            this.feedbackFigure = feedbackImage != null ? new ImageFigure(feedbackImage) : new ImageFigure(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
            this.addFeedback(this.feedbackFigure);
        }
        if (request instanceof ChangeBoundsRequest && this.cannotBeMovedToTheBeginning((ChangeBoundsRequest)request)) {
            if (this.getFeedbackLayer().getChildren().contains(this.feedbackFigure)) {
                this.eraseLayoutTargetFeedback(request);
            }
            this.feedbackFigure = new ImageFigure(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
            this.addFeedback(this.feedbackFigure);
        }
        return this.feedbackFigure;
    }

    protected boolean cannotBeMovedToTheBeginning(ChangeBoundsRequest request) {
        return false;
    }

    private void removePreExistingFeedbackFigure(Request request) {
        if (request instanceof ChangeBoundsRequest && !this.cannotBeMovedToTheBeginning((ChangeBoundsRequest)request) && this.getFeedbackLayer().getChildren().contains(this.feedbackFigure)) {
            this.eraseLayoutTargetFeedback(request);
        }
    }

    protected abstract int getTopMarginSize();

    public Image getFeedbackOfMovementRequest(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            if (((ChangeBoundsRequest)request).getEditParts().size() == 0) {
                return null;
            }
            Object template = ((ChangeBoundsRequest)request).getEditParts().get(0);
            if (template instanceof EntityEditPart) {
                EntityEditPart entityEditPart = (EntityEditPart)template;
                IMessageFlowEntity entity = ((EntityDecorator)entityEditPart.getModel()).getEntity();
                if (!(entity instanceof MessageFlowNode)) {
                    if (entity instanceof UnknownNode) {
                        return ImagesManager.getInstance().getPaletteUnknown();
                    }
                    return null;
                }
                MessageFlowNode messageFlowNode = (MessageFlowNode)entity;
                if (messageFlowNode.getType() != null) {
                    if (ModelUtils.isComment((IMessageFlowEntity)messageFlowNode)) {
                        return ImagesManager.getInstance().getPaletteComment();
                    }
                    NodeDefinition definition = messageFlowNode.getDefinition();
                    return definition.getIconImage();
                }
            }
        }
        return null;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.feedbackFigure != null) {
            this.removeFeedback(this.feedbackFigure);
            this.feedbackFigure = null;
        }
    }
}

