/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editpart.EntityDeleteEditPolicy;
import org.mule.tooling.messageflow.editpart.EntityDirectEditPolicy;
import org.mule.tooling.messageflow.editpart.ICollapsibleEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.editpart.RequestHandlerManager;
import org.mule.tooling.messageflow.figure.CollapsableNestedContainerFigure;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Event;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.ui.MuleImages;

public abstract class EntityEditPart<T extends MessageFlowEntity>
extends AbstractGraphicalEditPart
implements Observer,
NodeEditPart {
    private List<MessageFlowEntityError> errors;
    private boolean connectionsHidden;
    private PropertyChangedObserver propertyChangedObserver;

    public EntityEditPart(EntityDecorator<T> entity) {
        this.setModel(entity);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            return this.getParent();
        }
        return super.getTargetEditPart(request);
    }

    public List<MessageFlowEntityError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<MessageFlowEntityError> errors) {
        this.errors = errors;
        int max = this.computeMaxSeverity();
        int currentSeverity = this.getEntityFigure().getSeverity();
        this.getEntityFigure().setSeverity(max);
        this.getEntityFigure().setErrors(errors);
        if (max != currentSeverity) {
            this.getEntityFigure().repaint();
        }
    }

    protected int computeMaxSeverity() {
        int max = -1;
        for (MessageFlowEntityError error : this.errors) {
            if (error.getSeverity() <= max) continue;
            max = error.getSeverity();
        }
        return max;
    }

    public void activate() {
        super.activate();
        this.getEntityDecorator().addObserver((Observer)this);
        if (this.propertyChangedObserver == null) {
            this.propertyChangedObserver = new PropertyChangedObserver();
            this.getEntity().addObserver((Observer)this.propertyChangedObserver);
        }
    }

    public void deactivate() {
        if (this.propertyChangedObserver != null) {
            this.getEntity().deleteObserver((Observer)this.propertyChangedObserver);
        }
        this.getEntityDecorator().deleteObserver((Observer)this);
        MessageFlowUtils.fireDisposedIFigureEvent(Arrays.asList(this.getFigure()));
        super.deactivate();
    }

    protected List getModelSourceConnections() {
        if (this.connectionsHidden) {
            return Collections.emptyList();
        }
        return this.getEntityDecorator().getOutbound();
    }

    public final void performRequest(Request req) {
        RequestHandlerManager.getDefault().handleReadAccessRequest(this, req);
        super.performRequest(req);
    }

    public void updateFigure() {
        IFigure entityFigure = this.getFigure();
        if (entityFigure instanceof EntityFigure) {
            ((EntityFigure)entityFigure).updateImageFigure();
        }
    }

    protected IFigure createFigure() {
        return null;
    }

    public void showTargetFeedback(Request request) {
        RequestHandlerManager.getDefault().handleReadAccessRequest(this, request);
        super.showTargetFeedback(request);
    }

    public boolean understandsRequest(Request req) {
        return super.understandsRequest(req);
    }

    protected List getModelTargetConnections() {
        if (this.connectionsHidden) {
            return Collections.emptyList();
        }
        return this.getEntityDecorator().getInbound();
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("inbound".equals(arg)) {
            this.refreshTargetConnections();
        } else if ("outbound".equals(arg)) {
            this.refreshSourceConnections();
        }
    }

    public void updateConnections() {
        this.refreshTargetConnections();
        this.refreshSourceConnections();
    }

    public EntityDecorator<T> getEntityDecorator() {
        return (EntityDecorator)this.getModel();
    }

    public T getEntity() {
        return (T)((MessageFlowEntity)this.getEntityDecorator().getEntity());
    }

    public EntityFigure<?> getEntityFigure() {
        return (EntityFigure)this.getFigure();
    }

    public void hideConnections() {
        this.connectionsHidden = true;
        this.refresh();
    }

    public void showConnections() {
        this.connectionsHidden = false;
        this.refresh();
    }

    public void showCollapsed() {
        EditPart parent = this.getParent();
        while (parent != null) {
            IFigure parentFigure;
            if (parent instanceof ICollapsibleEditPart && ((ICollapsibleEditPart)parent).isCollapsed()) {
                ((ICollapsibleEditPart)parent).expand();
            } else if (parent instanceof NestedContainerEditPart && (parentFigure = ((NestedContainerEditPart)parent).getFigure()) instanceof CollapsableNestedContainerFigure) {
                ((CollapsableNestedContainerFigure)parentFigure).forceExpand();
            }
            parent = parent.getParent();
        }
    }

    public MuleConfiguration getMuleConfiguration() {
        EditPart parent = this.getParent();
        while (parent != null && !(parent instanceof MuleConfigurationEditPart)) {
            parent = parent.getParent();
        }
        if (parent instanceof MuleConfigurationEditPart) {
            return (MuleConfiguration)((MuleConfigurationEditPart)parent).getEntity();
        }
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityDeleteEditPolicy());
        if (this.getEntity() instanceof MessageFlowNode) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new EntityDirectEditPolicy());
        }
    }

    public DragTracker getDragTracker(Request request) {
        DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this);
        tracker.setDisabledCursor(MuleImages.DISABLED_CURSOR);
        return tracker;
    }

    public void applyErrors(Map<EntityEditPart<?>, List<MessageFlowEntityError>> errorsMap) {
        if (errorsMap.containsKey(this)) {
            this.setErrors(errorsMap.get(this));
            errorsMap.remove(this);
        } else {
            this.setErrors(Collections.EMPTY_LIST);
        }
        List<EditPart> editParts = this.getErrorMarkersParticipants();
        for (EditPart part : editParts) {
            if (!(part instanceof EntityEditPart)) continue;
            ((EntityEditPart)part).applyErrors(errorsMap);
        }
    }

    protected List<EditPart> getErrorMarkersParticipants() {
        return this.getChildren();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public IMuleProject getMuleProject() {
        return ((MuleConfigurationEditPart)this.getRoot().getContents()).getMuleProject();
    }

    public void refreshSourceConnections() {
        super.refreshSourceConnections();
    }

    public void refreshTargetConnections() {
        super.refreshTargetConnections();
    }

    private final class PropertyChangedObserver
    implements Observer {
        private PropertyChangedObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            boolean shouldUpdate = false;
            if (arg instanceof Event) {
                boolean isEventType;
                Event event = (Event)arg;
                String eventType = event.getEventType();
                boolean bl = isEventType = eventType.equals("properties") || eventType.equals("name");
                if (isEventType) {
                    boolean isEventSource;
                    shouldUpdate = isEventSource = event.getSource() == EntityEditPart.this.getEntity();
                }
            } else {
                System.out.println("PropertyChangedObserver: arg is " + String.valueOf(arg.getClass()));
                boolean bl = shouldUpdate = arg.equals("name") || arg.equals("properties");
            }
            if (shouldUpdate) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EntityEditPart.this.updateFigure();
                    }
                });
            }
        }
    }
}

