/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.command.RenameContainerRefNameCommand;
import org.mule.tooling.messageflow.command.RenameEntityCommand;
import org.mule.tooling.messageflow.command.RenameErrorHandlerReferencesCommand;
import org.mule.tooling.messageflow.command.RenameFlowReferencesCommand;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;

public class EntityDirectEditPolicy
extends DirectEditPolicy {
    protected Command getDirectEditCommand(DirectEditRequest request) {
        IMessageFlowEntity model = ((EntityDecorator)this.getHost().getModel()).getEntity();
        String newName = (String)request.getCellEditor().getValue();
        String oldName = ((MessageFlowNode)model).getName();
        CompoundCommand applyCommand = new CompoundCommand("Renaming " + oldName);
        if (model instanceof MessageFlowNode) {
            String modelType = ((MessageFlowNode)model).getType();
            if (!((MessageFlowNode)model).getName().equals(newName)) {
                if (modelType.equals("http://www.mulesoft.org/schema/mule/core/flow-ref") || modelType.equals("http://www.mulesoft.org/schema/mule/batch/execute")) {
                    applyCommand.add((Command)new RenameContainerRefNameCommand((IMessageFlowNode)((MessageFlowNode)model), newName));
                } else {
                    applyCommand.add((Command)new RenameEntityCommand((IMessageFlowNode)((MessageFlowNode)model), newName));
                }
                if (ModelUtils.isFlowOrSubflow((IMessageFlowEntity)model)) {
                    applyCommand.add((Command)new RenameFlowReferencesCommand((IMessageFlowNode)((MessageFlowNode)model), oldName, newName));
                } else if (ModelUtils.isErrorHandler((IMessageFlowEntity)model)) {
                    applyCommand.add((Command)new RenameErrorHandlerReferencesCommand((IMessageFlowNode)((MessageFlowNode)model), oldName, newName));
                }
            }
        }
        return applyCommand;
    }

    protected void showCurrentEditValue(DirectEditRequest request) {
        String value = (String)request.getCellEditor().getValue();
        EntityFigure figure = (EntityFigure)this.getHostFigure();
        if (figure.hasLabel()) {
            figure.updateLabel(value);
        }
    }
}

