/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.DeleteFlowCommand;
import org.mule.tooling.messageflow.command.DeleteGlobalElementCommand;
import org.mule.tooling.messageflow.command.LaneDeleteCommand;
import org.mule.tooling.messageflow.command.NodeDeleteCommand;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.editpart.RequestHandlerManager;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.utils.SilentRunner;

public class EntityDeleteEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteCommand(final GroupRequest deleteRequest) {
        return (Command)SilentRunner.run((Callable)new Callable<CompoundCommand>(){

            @Override
            public CompoundCommand call() throws Exception {
                CompoundCommand result = new CompoundCommand();
                EntityEditPart editPart = (EntityEditPart)EntityDeleteEditPolicy.this.getHost();
                boolean handled = RequestHandlerManager.getDefault().handleWriteAccessRequest(editPart, (Request)deleteRequest, result);
                if (!handled) {
                    EntityDeleteEditPolicy.this.addDeleteCommandTo(editPart, result, true);
                }
                return result;
            }
        }, null);
    }

    protected void addDeleteCommandTo(EntityEditPart<?> editPart, CompoundCommand result, boolean fireEvents) {
        Object entity = editPart.getEntity();
        if (editPart.getViewer() != null) {
            IsTopLevelElementVisitor isTopLevelElementVisitor = new IsTopLevelElementVisitor(editPart);
            entity.accept((MessageFlowEntityVisitor)isTopLevelElementVisitor);
            if (isTopLevelElementVisitor.isTopLevelElement()) {
                this.deleteFlow((EditPart)editPart, result, fireEvents);
            } else {
                this.deleteNonFlow((EditPart)editPart, result, fireEvents);
            }
        }
    }

    public void addDeleteCommandTo(EntityEditPart<?> editPart, CompoundCommand result) {
        this.addDeleteCommandTo(editPart, result, true);
    }

    protected void deleteNonFlow(final EditPart part, final CompoundCommand commands, boolean fireEvents) {
        Object entity = ((EntityEditPart)part).getEntity();
        final EditPart parentPart = part.getParent();
        Object parentModel = parentPart.getModel();
        if (parentModel instanceof EntityDecorator) {
            EntityDecorator parentDecorator = (EntityDecorator)parentModel;
            ((MessageFlowEntity)parentDecorator.getEntity()).accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter((MessageFlowEntity)entity, fireEvents){
                private final /* synthetic */ MessageFlowEntity val$entity;
                private final /* synthetic */ boolean val$fireEvents;
                {
                    this.val$entity = messageFlowEntity;
                    this.val$fireEvents = bl;
                }

                public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                    GlobalElement element = null;
                    MuleConfigurationDecorator model = (MuleConfigurationDecorator)parentPart.getModel();
                    List globalEntries = ((MuleConfiguration)model.getEntity()).getGlobalEntries();
                    for (IMessageFlowEntity q : globalEntries) {
                        if (!q.getEntityId().equals(((MessageFlowEntity)((EntityDecorator)part.getModel()).getEntity()).getEntityId())) continue;
                        element = (GlobalElement)q;
                        break;
                    }
                    if (element != null) {
                        DeleteGlobalElementCommand gm = new DeleteGlobalElementCommand(model, element);
                        commands.add((Command)gm);
                    }
                }

                public void visitNestedContainer(NestedContainer nestedContainer) {
                    NestedContainerEditPart pm = (NestedContainerEditPart)parentPart;
                    ContainerDecorator parent = (ContainerDecorator)pm.getParent().getModel();
                    List children = pm.getChildren();
                    for (EntityEditPart child : children) {
                        Object value = child.getEntity();
                        if (!value.equals(this.val$entity)) continue;
                        NodeDeleteCommand deleteCommand = new NodeDeleteCommand(part.getViewer(), this.val$entity, (Compartment)parent.getEntity(), (CompartmentLane)nestedContainer, MuleCorePlugin.getEventBus(), this.val$fireEvents);
                        commands.add((Command)deleteCommand);
                    }
                }

                public void visitCompartment(Compartment compartment) {
                    if (this.val$entity instanceof Route) {
                        RouteDefinition definition = ((Route)this.val$entity).getDefinition();
                        CompartmentEditPart comparment = (CompartmentEditPart)parentPart;
                        LaneDeleteCommand delete = new LaneDeleteCommand(comparment, (CompartmentLane)((CompartmentLaneEditPart)part).getEntity(), Optional.ofNullable(definition));
                        commands.add((Command)delete);
                    }
                }

                public void visitCompartmentLane(CompartmentLane clane) {
                    CompartmentLaneDecorator<CompartmentLane> lane = ((CompartmentLaneEditPart)parentPart).getEntityDecorator();
                    EditPart grandparent = parentPart.getParent();
                    if (grandparent instanceof EntityEditPart) {
                        NodeDeleteCommand delete = new NodeDeleteCommand(part.getViewer(), this.val$entity, (Compartment)((EntityEditPart)grandparent).getEntity(), (CompartmentLane)lane.getEntity(), MuleCorePlugin.getEventBus(), this.val$fireEvents);
                        commands.add((Command)delete);
                    }
                }

                public void visitRoute(Route route) {
                    this.visitCompartmentLane((CompartmentLane)route);
                }
            });
        }
    }

    protected void deleteFlow(EditPart part, CompoundCommand commands, boolean fireEvents) {
        MuleConfigurationEditPart editPart;
        EntityDecorator entityDecorator;
        Object entity = ((EntityEditPart)part).getEntity();
        Container flow = (Container)entity;
        EditPart parent = part.getParent();
        if (parent instanceof MuleConfigurationEditPart && (entityDecorator = (editPart = (MuleConfigurationEditPart)parent).getEntityDecorator()) instanceof MuleConfigurationDecorator) {
            MuleConfigurationDecorator decorator = (MuleConfigurationDecorator)entityDecorator;
            DeleteFlowCommand deleteFlow = new DeleteFlowCommand(decorator, flow);
            commands.add((Command)deleteFlow);
        }
    }

    private class IsTopLevelElementVisitor
    extends MessageFlowEntityVisitorAdapter {
        boolean topLevelElement;
        private EntityEditPart<?> editPart;

        public IsTopLevelElementVisitor(EntityEditPart<?> editPart) {
            this.editPart = editPart;
        }

        public boolean isTopLevelElement() {
            return this.topLevelElement;
        }

        public void visitContainer(Container container) {
            EditPart parent = this.editPart.getParent();
            if (this.editPart instanceof EntityEditPart) {
                EntityEditPart entityEditPart = (EntityEditPart)parent;
                Object parentEntity = entityEditPart.getEntity();
                this.topLevelElement = parentEntity instanceof MuleConfiguration;
            } else {
                this.topLevelElement = false;
            }
        }

        public void visitNestedContainer(NestedContainer nestedContainer) {
            this.topLevelElement = false;
        }

        public void visitCommentNode(CommentContainer commentContainer) {
            this.topLevelElement = commentContainer.isStandalone();
        }
    }
}

