/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.Observable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.ConnectorEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.FixPointAnchor;
import org.mule.tooling.messageflow.events.FigureCreatedEvent;
import org.mule.tooling.messageflow.events.RefreshRequestedEvent;
import org.mule.tooling.messageflow.figure.EndpointFigure;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.NodeFigure;
import org.mule.tooling.messageflow.figure.RequestResponseFigure;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.model.messageflow.decorator.EndpointDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.utils.eventbus.IEvent;

public class EndpointEditPart
extends EntityEditPart<EndpointNode>
implements NodeEditPart {
    private boolean isRequestResponse;

    public EndpointEditPart(EndpointDecorator decorator) {
        super(decorator);
    }

    @Override
    public void activate() {
        super.activate();
        this.updateResponseHandling();
    }

    @Override
    public void update(Observable o, Object arg) {
        super.update(o, arg);
        if ("exchangePattern".equals(arg)) {
            this.getParentDecorator().fireEvent("inbound.endpoint");
            MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new RefreshRequestedEvent(flowEditorFromActivePage));
        }
    }

    public void updateResponseHandling() {
        boolean isRequestResponse;
        this.isRequestResponse = isRequestResponse = this.getDecorator().isRequestResponseMEP() && this.isInboundEndpoint() && this.isParentShowsResponse();
    }

    private boolean isInboundEndpoint() {
        EndpointNode endpoint = (EndpointNode)this.getEntity();
        return endpoint.getDirection() == EndpointDirection.INBOUND;
    }

    @Override
    protected IFigure createFigure() {
        this.updateResponseHandling();
        EndpointFigure figure = new EndpointFigure((EndpointNode)this.getEntity());
        if (this.isRequestResponse) {
            RequestResponseFigure requestResponseFigure = new RequestResponseFigure((MessageFlowEntity)this.getEntity(), figure);
            this.fireFigureCreatedEvent(figure);
            return requestResponseFigure;
        }
        this.fireFigureCreatedEvent(figure);
        return figure;
    }

    private void fireFigureCreatedEvent(EntityFigure<?> figure) {
        MulePath entityPath = this.getMuleConfiguration().getPathFor(this.getEntity());
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new FigureCreatedEvent(figure, entityPath));
    }

    public void update(IReadOnlyPropertyCollection properties, PropertyCollection after) {
        UpdatePropertiesCommand command = new UpdatePropertiesCommand(MessageFlowUtils.getFlowEditorFromActivePage().getMuleProject(), null, this.getEntityDecorator(), properties, after);
        CommandStack stack = this.getViewer().getEditDomain().getCommandStack();
        stack.execute(command);
    }

    @Override
    public void updateFigure() {
        if (this.getFigure() instanceof NodeFigure) {
            NodeFigure figure = (NodeFigure)this.getFigure();
            figure.updateName();
            figure.updateDescription();
        } else if (this.getFigure() instanceof RequestResponseFigure) {
            NodeFigure figure = ((RequestResponseFigure)this.getFigure()).getRequestFigure();
            figure.updateName();
            figure.updateDescription();
        }
        super.updateFigure();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new FixPointAnchor(this.getEndpointFigure(connection));
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FixPointAnchor(this.getEndpointFigure(connection));
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    protected IFigure getEndpointFigure(ConnectionEditPart connEdit) {
        ConnectorType type;
        ConnectorType connectorType = type = connEdit != null ? ((ConnectorEditPart)connEdit).getConnector().getType() : ConnectorType.REQUEST_FLOW;
        if (this.isRequestResponse) {
            RequestResponseFigure requestResponseFigure = (RequestResponseFigure)this.getFigure();
            if (type == ConnectorType.REQUEST_FLOW) {
                return requestResponseFigure.getRequestFigure();
            }
            return requestResponseFigure.getResponseFigure();
        }
        return this.getFigure();
    }

    protected EndpointDecorator getDecorator() {
        return (EndpointDecorator)this.getEntityDecorator();
    }

    protected EntityDecorator<?> getParentDecorator() {
        return (EntityDecorator)this.getParent().getModel();
    }

    protected boolean isParentShowsResponse() {
        if (this.getParent().getModel() instanceof CompartmentLaneDecorator) {
            CompartmentLaneDecorator compartmentLaneDecorator = (CompartmentLaneDecorator)this.getParent().getModel();
            return compartmentLaneDecorator.isShowResponse();
        }
        return false;
    }

    @Override
    public void deactivate() {
        if (this.getFigure() instanceof NodeFigure) {
            NodeFigure figure = (NodeFigure)this.getFigure();
            figure.deactivate();
        }
        super.deactivate();
    }
}

