/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.layout.NestedContainerChildrenCreator;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;

public class DefaultChildrenCreator
implements NestedContainerChildrenCreator {
    public static final DefaultChildrenCreator instance = new DefaultChildrenCreator();

    @Override
    public List<EntityDecorator<?>> createChildren(NestedContainerEditPart editPart) {
        ArrayList children = new ArrayList();
        NestedContainer entity = (NestedContainer)editPart.getEntity();
        List childElements = entity.getCompartmentLaneEntries();
        EntityDecorator last = null;
        for (IMessageFlowEntity childEntity : childElements) {
            EntityEditPart<?> entityEditPart = MessageFlowEditor.findEditPartInRegistry(editPart.getViewer(), childEntity);
            EntityDecorator wrappedEntity = null;
            if (entityEditPart != null) {
                wrappedEntity = entityEditPart.getEntityDecorator();
                wrappedEntity.getInbound().clear();
                wrappedEntity.getOutbound().clear();
            } else {
                wrappedEntity = MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)childEntity);
            }
            children.add(wrappedEntity);
            this.createConnection(last, wrappedEntity);
            last = wrappedEntity;
        }
        return children;
    }

    protected void createConnection(EntityDecorator<?> last, EntityDecorator<?> wrappedEntity) {
        if (last != null) {
            MessageFlowFactory.createConnector(last, wrappedEntity, (ConnectorType)ConnectorType.REQUEST_FLOW);
        }
    }
}

