/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.messageflow.editpart.ContainerUpdateParticipant;

public class ContainerUpdateParticipantManager {
    private static ContainerUpdateParticipantManager instance;
    private Map<String, ContainerUpdateParticipant> idToUpdateParticipantMap = Maps.newHashMap();

    public static ContainerUpdateParticipantManager instance() {
        if (instance == null) {
            instance = new ContainerUpdateParticipantManager();
        }
        return instance;
    }

    private ContainerUpdateParticipantManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.containerUpdateParticipant");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String updateParticipantId = configurationElement.getAttribute("updateParticipantId");
                ContainerUpdateParticipant updateParticipant = this.instantiateUpdateParticipant(configurationElement);
                this.idToUpdateParticipantMap.put(updateParticipantId, updateParticipant);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed loading container updateParticipant extension point", e);
        }
    }

    public Optional<ContainerUpdateParticipant> getUpdateParticipant(String updateParticipantId) {
        return Optional.fromNullable((Object)this.idToUpdateParticipantMap.get(updateParticipantId));
    }

    protected ContainerUpdateParticipant instantiateUpdateParticipant(IConfigurationElement configurationElement) throws CoreException {
        return (ContainerUpdateParticipant)ContainerUpdateParticipant.class.cast(configurationElement.createExecutableExtension("updateParticipantClass"));
    }
}

