/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.messageflow.editpart.CenterpointAnchor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.IMuleProjectAwareEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.figure.ContainerFigure;
import org.mule.tooling.messageflow.util.FlowContainerUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.ContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionResolver;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;

public class ContainerEditPart
extends EntityEditPart<Container>
implements IMuleProjectAwareEditPart,
NodeEditPart {
    private IMuleProject project;
    private List<EntityDecorator<?>> children;

    public ContainerEditPart(ContainerDecorator entity, IMuleProject project) {
        super(entity);
        this.project = project;
    }

    @Override
    public IMuleProject getMuleProject() {
        return this.project;
    }

    @Override
    protected IFigure createFigure() {
        return new ContainerFigure((Container)this.getEntity(), true);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
    }

    @Override
    public void update(Observable model, Object propertyName) {
        super.update(model, propertyName);
        if (propertyName.equals("properties")) {
            this.refresh();
        }
        if ("lanes".equals(propertyName)) {
            this.cleanChildren();
            this.refreshChildren();
        }
    }

    protected void cleanChildren() {
        this.children = null;
    }

    protected List getModelChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
        }
        return this.children;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            if (changeBoundsRequest.getEditParts().isEmpty()) {
                return this;
            }
            MuleConfiguration config = this.getMuleConfiguration();
            IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
            EntityEditPart targetEditPart = this;
            if (MessageFlowUtils.isFlow(this)) {
                if (changeBoundsRequest.getEditParts().size() > 1) {
                    targetEditPart = this.getNestedContainer(1);
                } else {
                    EditPart editPartToBePasted = (EditPart)changeBoundsRequest.getEditParts().get(0);
                    MessageFlowEntity messageToPaste = (MessageFlowEntity)((EntityDecorator)editPartToBePasted.getModel()).getEntity();
                    if (messageToPaste instanceof EndpointNode) {
                        EndpointNode endpointNode = (EndpointNode)messageToPaste;
                        targetEditPart = this.getNestedContainer(endpointNode.isInbound() ? 0 : 1);
                    } else if (ModelUtils.isComment((IMessageFlowEntity)messageToPaste)) {
                        targetEditPart = this.getNestedContainer(0);
                    } else {
                        IMessageFlowNode messageFlowNode = (IMessageFlowNode)messageToPaste;
                        NodeDefinition nodeDefinition = messageFlowNode.getDefinition();
                        INodeDefinitionFilter acceptedByFilter = nodeDefinition.getAcceptedByFilter();
                        INodeDefinitionResolver resolver = ModuleManagerNodeDefinitionResolver.get();
                        NestedContainerDefinition inputDefinition = (NestedContainerDefinition)moduleManager.getDefinition("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
                        Container flow = FlowContainerUtils.createFlow(config);
                        NestedContainer flowInput = flow.getNestedContainer("http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane");
                        targetEditPart = acceptedByFilter.accepts((IMessageFlowNode)config, (NodeDefinition)inputDefinition, resolver) && inputDefinition.getAcceptsFilter().accepts((IMessageFlowNode)flowInput, nodeDefinition, resolver) ? this.getNestedContainer(0) : this.getNestedContainer(1);
                    }
                }
            } else {
                targetEditPart = this.getNestedContainer(0);
            }
            return targetEditPart;
        }
        return super.getTargetEditPart(request);
    }

    protected List<EntityDecorator<?>> createChildren() {
        ArrayList children = new ArrayList();
        Container entity = (Container)this.getEntity();
        List lanes = entity.getLanes();
        for (CompartmentLane compartmentLane : lanes) {
            children.add(MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)compartmentLane));
        }
        return children;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new CenterpointAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new CenterpointAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    public NestedContainerEditPart getNestedContainer(int index) {
        return (NestedContainerEditPart)this.getChildren().get(index);
    }
}

