/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.messageflow.command.ReparentEntityToANewContainerCommand;
import org.mule.tooling.messageflow.editpart.AbstractCompartmentLaneLayoutEditPolicy;
import org.mule.tooling.messageflow.editpart.CompartmentLaneCommandFactory;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.IHasContentFigure;
import org.mule.tooling.messageflow.editpart.MuleSelectionEditPolicy;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.figure.CompartmentLaneLayout;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.NodeDefinition;

public class CompartmentLaneLayoutEditPolicy
extends AbstractCompartmentLaneLayoutEditPolicy {
    @Override
    protected int getTopMarginSize() {
        return this.getHostFigure().getInsets().top;
    }

    @Override
    protected boolean canShowLayoutFeedback(Request request) {
        if (!(request instanceof CreateRequest)) {
            return request instanceof ChangeBoundsRequest;
        }
        CreateRequest createRequest = (CreateRequest)request;
        Object newObject = null;
        try {
            newObject = createRequest.getNewObject();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (!(newObject instanceof NodeDefinition)) {
            return false;
        }
        Figure laneFigure = this.getHostFigure() instanceof IHasContentFigure ? (Figure)((IHasContentFigure)this.getHostFigure()).getContentFigure() : (Figure)this.getHostFigure();
        LayoutManager layoutManager = laneFigure.getLayoutManager();
        return this.shouldShowFeedback(layoutManager);
    }

    private boolean shouldShowFeedback(LayoutManager layoutManager) {
        return layoutManager instanceof CompartmentLaneLayout;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newObject = request.getNewObject();
        if (!(newObject instanceof NodeDefinition)) {
            return null;
        }
        NodeDefinition nodeDef = (NodeDefinition)newObject;
        Figure laneFigure = (Figure)this.getHostFigure();
        LayoutManager layoutManager = laneFigure.getLayoutManager();
        if (!this.shouldShowFeedback(layoutManager)) {
            return this.generateCreateCommand(request, this.getCompartmentLane(), null);
        }
        MessageFlowEntity addBefore = this.getBeforeMessageFlowEntity(request);
        IMessageFlowEntity addAfter = this.getAfterMessageFlowEntity((IMessageFlowEntity)addBefore, (ContainerOfMovableEntities)this.getCompartmentLane());
        boolean locationAccepted = nodeDef.getLocationFilter().accepts((IMessageFlowEntity)addBefore, addAfter);
        if (!locationAccepted) {
            return null;
        }
        return this.generateCreateCommand(request, this.getCompartmentLane(), (IMessageFlowEntity)addBefore);
    }

    protected Command generateCreateCommand(CreateRequest request, CompartmentLaneDecorator<CompartmentLane> lane, IMessageFlowEntity addBefore) {
        Object newObject = request.getNewObject();
        if (!(newObject instanceof NodeDefinition)) {
            return null;
        }
        NodeDefinition nodeDefinition = (NodeDefinition)newObject;
        CompartmentLaneDecorator<CompartmentLane> compartmentLane = this.getCompartmentLane();
        IMessageFlowEntity addAfter = this.getAfterMessageFlowEntity(addBefore, (ContainerOfMovableEntities)compartmentLane);
        EditPart parent = this.getParent();
        if (!this.canGenerateCommand(nodeDefinition)) {
            return null;
        }
        return CompartmentLaneCommandFactory.createCreateCommand(this.getConfigDecorator(), nodeDefinition, lane, parent, addBefore, addAfter);
    }

    protected boolean checkAddResponseAfterTerminated(MessageFlowEntity addBefore) {
        return addBefore == null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new MuleSelectionEditPolicy();
    }

    public CompartmentLaneEditPart getCompartmentLaneEditPart() {
        return (CompartmentLaneEditPart)this.getHost();
    }

    protected CompartmentLaneDecorator<CompartmentLane> getCompartmentLane() {
        return this.getCompartmentLaneEditPart().getEntityDecorator();
    }

    protected Command createAddCommand(EditPart child, EditPart addBefore) {
        boolean locationAccepted;
        NodeDefinition entityDefinition;
        EntityDecorator entityDecorator = (EntityDecorator)child.getParent().getModel();
        if (this.getHost().getModel() == entityDecorator || MessageFlowUtils.isFlow(child)) {
            return null;
        }
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        if (!(entityDecorator instanceof ContainerOfMovableEntities) || ModelUtils.isCommentStandalone((IMessageFlowEntity)messageFlowEntity)) {
            return null;
        }
        ContainerOfMovableEntities oldContainer = (ContainerOfMovableEntities)entityDecorator;
        if (!(ModelUtils.isUnknownNode((IMessageFlowEntity)messageFlowEntity) || ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) || this.canGenerateCommand(entityDefinition = ((MessageFlowNode)messageFlowEntity).getDefinition()))) {
            return null;
        }
        ContainerOfMovableEntities compartmentLaneDecorator = (ContainerOfMovableEntities)this.getHost().getModel();
        IMessageFlowEntity addBeforeEntity = addBefore != null ? ((EntityDecorator)addBefore.getModel()).getEntity() : null;
        IMessageFlowEntity addAfterEntity = this.getAfterMessageFlowEntity(addBeforeEntity, compartmentLaneDecorator);
        NodeDefinition definition = MessageFlowUtils.getDefinition(messageFlowEntity);
        boolean bl = locationAccepted = ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity) || definition.getLocationFilter().accepts(addBeforeEntity, addAfterEntity);
        if (!locationAccepted) {
            return null;
        }
        ReparentEntityToANewContainerCommand cmd = new ReparentEntityToANewContainerCommand((ContainerOfMovableEntities)this.getHost().getModel(), messageFlowEntity, this.getMuleConfiguration());
        if (addBefore != null) {
            IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)addBefore.getModel()).getEntity();
            cmd.setAfterMessageFlowEntity(afterMessageFlowEntity);
        } else {
            cmd.setAfterMessageFlowEntity(null);
        }
        cmd.setOldContainer(oldContainer);
        EditPart compartmentEditPart = child.getParent().getParent();
        if (compartmentEditPart.getParent() != null && compartmentEditPart.getParent() instanceof SplitterEditPart) {
            cmd.setSplitter(true);
        }
        cmd.setRootEditPart((EditPart)compartmentEditPart.getRoot());
        cmd.setOldCompartment(compartmentEditPart.getModel());
        Object compartment = this.getParent().getModel();
        cmd.setCompartment(compartment);
        return cmd;
    }
}

