/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.AlignmentCenterpointAnchor;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.CompartmentLaneLayoutEditPolicy;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.SelectOnlyEditPolicy;
import org.mule.tooling.messageflow.figure.CompartmentLaneFigure;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ConnectorType;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;

public class CompartmentLaneEditPart
extends EntityEditPart<CompartmentLane>
implements NodeEditPart {
    private List<EntityDecorator<?>> children;
    private boolean isVertical;
    private boolean isToolbar;

    public CompartmentLaneEditPart(CompartmentLaneDecorator<CompartmentLane> decorator, boolean isVertical, boolean isToolbar) {
        super(decorator);
        this.isVertical = isVertical;
        this.isToolbar = isToolbar;
    }

    @Override
    protected IFigure createFigure() {
        return new CompartmentLaneFigure((CompartmentLane)this.getEntity(), this.isVertical, this.isToolbar, (EditPart)this);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installLaneEditPolicy();
    }

    protected void installLaneEditPolicy() {
        CompartmentLaneDecorator<CompartmentLane> lane = this.getEntityDecorator();
        if (lane.isEditable()) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CompartmentLaneLayoutEditPolicy());
        } else {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SelectOnlyEditPolicy());
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        super.update(o, arg);
        if ("entities".equals(arg)) {
            this.flushModel();
            this.refreshChildren();
            EditPart parent = this.getParent();
            if (parent instanceof CompartmentEditPart) {
                CompartmentEditPart compEditPart = (CompartmentEditPart)parent;
                compEditPart.reload();
                ((EntityEditPart)parent.getParent()).updateConnections();
            }
        }
    }

    protected List getModelChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
        }
        return this.children;
    }

    public void refreshChildren() {
        super.refreshChildren();
        for (EntityEditPart entity : this.getChildren()) {
            entity.updateConnections();
        }
    }

    protected void flushModel() {
        this.children = null;
    }

    protected List<EntityDecorator<?>> createChildren() {
        ArrayList model = new ArrayList();
        EntityDecorator last = null;
        for (IMessageFlowEntity embedded : ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries()) {
            EntityDecorator decorator;
            UnknownNode un;
            if (embedded instanceof UnknownNode && (un = (UnknownNode)embedded).getDescription()) continue;
            EntityEditPart<?> entityEditPart = MessageFlowEditor.findEditPartInRegistry(this.getViewer(), embedded);
            if (entityEditPart != null) {
                decorator = entityEditPart.getEntityDecorator();
                decorator.getInbound().clear();
                decorator.getOutbound().clear();
            } else {
                decorator = MessageFlowFactory.getWrappedEntity((IMessageFlowEntity)embedded);
            }
            model.add(decorator);
            if (last != null) {
                MessageFlowFactory.createConnector((EntityDecorator)last, (EntityDecorator)decorator, (ConnectorType)ConnectorType.REQUEST_FLOW);
            }
            last = decorator;
        }
        return model;
    }

    public IMessageFlowEntity getFirstEntityInLane() {
        IMessageFlowEntity firstEntity = null;
        List entities = ((CompartmentLane)this.getEntity()).getCompartmentLaneEntries();
        if (!entities.isEmpty()) {
            firstEntity = (IMessageFlowEntity)entities.get(0);
        }
        return firstEntity;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new AlignmentCenterpointAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new AlignmentCenterpointAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new AlignmentCenterpointAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new AlignmentCenterpointAnchor(this.getFigure());
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateRequest || request instanceof ChangeBoundsRequest) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    @Override
    public CompartmentLaneDecorator<CompartmentLane> getEntityDecorator() {
        return (CompartmentLaneDecorator)super.getEntityDecorator();
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public boolean isToolbar() {
        return this.isToolbar;
    }
}

