/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CompartmentLaneEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.RouterEditPart;
import org.mule.tooling.messageflow.figure.CompartmentFigure;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;

public class CompartmentEditPart
extends EntityEditPart<Compartment> {
    private List<EntityDecorator<?>> displayModel;

    public CompartmentEditPart(EntityDecorator<Compartment> decorator) {
        super(decorator);
    }

    @Override
    protected IFigure createFigure() {
        if (this.displayModel == null) {
            this.displayModel = this.buildDisplayModel();
        }
        return new CompartmentFigure((Compartment)this.getEntity());
    }

    public boolean isSelectable() {
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        super.update(o, arg);
        if ("lanes".equals(arg)) {
            this.reload();
        }
    }

    public void reload() {
        this.flushModel();
        this.refreshChildren();
    }

    public void refreshVisuals() {
        this.reload();
    }

    protected List getModelChildren() {
        if (this.displayModel == null) {
            this.displayModel = this.buildDisplayModel();
        }
        return this.displayModel;
    }

    protected void flushModel() {
        this.displayModel = null;
    }

    protected List<EntityDecorator<?>> buildDisplayModel() {
        ArrayList model = new ArrayList();
        for (CompartmentLane lane : ((Compartment)this.getEntity()).getLanes()) {
            CompartmentLaneEditPart laneEditPart = this.getLaneEditPart(lane);
            CompartmentLaneDecorator<?> laneDecorator = this.getLaneDecorator(laneEditPart, lane);
            model.add((EntityDecorator<?>)laneDecorator);
        }
        return model;
    }

    protected CompartmentLaneEditPart getLaneEditPart(CompartmentLane lane) {
        CompartmentLaneEditPart laneEditPart = (CompartmentLaneEditPart)MessageFlowEditor.findEditPartInRegistry(this.getViewer(), (IMessageFlowEntity)lane);
        return laneEditPart;
    }

    protected CompartmentLaneDecorator<?> getLaneDecorator(CompartmentLaneEditPart laneEditPart, CompartmentLane lane) {
        CompartmentLaneDecorator laneDecorator;
        CompartmentDecorator compartment = this.getEntityDecorator();
        if (laneEditPart != null) {
            laneDecorator = laneEditPart.getEntityDecorator();
            laneDecorator.getInbound().clear();
        } else {
            laneDecorator = new CompartmentLaneDecorator(lane, compartment.isEditable());
        }
        return laneDecorator;
    }

    public CompartmentDecorator getEntityDecorator() {
        return (CompartmentDecorator)super.getEntityDecorator();
    }

    public static boolean isFromRouter(EditPart editPart) {
        boolean isRouterEditPart = editPart.getParent() instanceof RouterEditPart;
        return isRouterEditPart;
    }
}

