/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import com.google.common.base.Optional;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editpart.CollapsibleContainerController;
import org.mule.tooling.messageflow.editpart.CollapsibleContainerDefinition;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.EntityDeleteEditPolicy;
import org.mule.tooling.messageflow.editpart.EntityDirectEditPolicy;
import org.mule.tooling.messageflow.editpart.ICollapsibleEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPolicy;
import org.mule.tooling.messageflow.figure.ContainerCollapseListener;
import org.mule.tooling.messageflow.figure.ContainerFigure;
import org.mule.tooling.messageflow.figure.OnErrorContainerFigure;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.ContainerDecorator;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.button.CollapseButton;
import org.mule.tooling.ui.widgets.listener.ICollapseListener;

public class CollapsibleContainerEditPart
extends ContainerEditPart
implements ICollapsibleEditPart {
    private CollapseButton collapseFigure;
    private ContainerCollapseListener collapseListener = new ContainerCollapseListener(this);
    private MouseListener expandListener = new MouseListener(){

        public void mousePressed(MouseEvent me) {
            CollapsibleContainerEditPart.this.expand();
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    };

    public CollapsibleContainerEditPart(ContainerDecorator entity, IMuleProject project) {
        super(entity, project);
        this.setCollapseFigure(false);
    }

    @Override
    protected IFigure createFigure() {
        Container entity = (Container)this.getEntity();
        ContainerFigure container = MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)entity) ? new OnErrorContainerFigure(entity, false) : new ContainerFigure(entity, true);
        container.setCollapseFigure(this.collapseFigure);
        return container;
    }

    private void setCollapseFigure(boolean collapsed) {
        if (this.collapseFigure != null) {
            this.collapseFigure.erase();
        }
        this.collapseFigure = new CollapseButton(collapsed, ((Container)this.getEntity()).getDefinition().getCategoryId());
        this.collapseFigure.addListener((ICollapseListener)this.collapseListener);
    }

    @Override
    public void collapse() {
        Optional<IFigure> previewFigure = this.createPreviewImage();
        List containersEditPart = this.getChildren();
        for (AbstractGraphicalEditPart containerEditPart : containersEditPart) {
            containerEditPart.removeEditPolicy((Object)"LayoutEditPolicy");
        }
        this.hideChildrenConnections();
        ContainerFigure containerFigure = (ContainerFigure)this.figure;
        this.setCollapseFigure(true);
        containerFigure.setCollapseFigure(this.collapseFigure);
        containerFigure.updateImageFigure();
        containerFigure.getChildren().remove(containerFigure.getContentFigure());
        containerFigure.removeFooterFigure();
        ImageFigure imageFigure = new ImageFigure(WidgetsImages.getImage((String)"icons/expand-large-icon.png"));
        imageFigure.addMouseListener(this.expandListener);
        Figure contentFigure = containerFigure.createContentFigure();
        contentFigure.add((IFigure)imageFigure);
        containerFigure.setContentFigure(contentFigure);
        containerFigure.addContentFigure();
        containerFigure.addFooterFigure();
        this.refresh();
        containerFigure.updateImageFigure();
        CollapsibleAction saveAction = (muleProject, muleConfig, path) -> CollapsibleContainerController.getDefault().addContainer(muleProject, muleConfig, path);
        this.doCollapsibleAction(saveAction);
        Optional<CollapsibleContainerDefinition> def = this.getCurrentDefinition();
        if (previewFigure.isPresent()) {
            this.savePreviewFigure(def, (IFigure)previewFigure.get());
            this.figure.setToolTip((IFigure)previewFigure.get());
        } else {
            previewFigure = CollapsibleContainerController.getDefault().getPreviewImage(def);
            if (previewFigure.isPresent()) {
                this.figure.setToolTip((IFigure)previewFigure.get());
            }
        }
    }

    private void savePreviewFigure(Optional<CollapsibleContainerDefinition> def, IFigure previewFigure) {
        if (def.isPresent()) {
            CollapsibleContainerController.getDefault().savePreviewImage((CollapsibleContainerDefinition)def.get(), previewFigure);
        }
    }

    private Optional<CollapsibleContainerDefinition> getCurrentDefinition() {
        MessageFlowEntityRef entityRef = MessageFlowUtils.findMulePathForEntityInOpenEditors(this.getEntity());
        if (entityRef != null) {
            MulePath path = entityRef.getMulePath();
            return Optional.of((Object)new CollapsibleContainerDefinition(MuleCorePlugin.getDesignContext().getMuleProject(), this.getMuleConfiguration(), path));
        }
        return Optional.absent();
    }

    private Optional<IFigure> createPreviewImage() {
        if (this.figure.getBounds().x > 0 && this.figure.getBounds().y > 0) {
            ContainerFigure containerFigure = (ContainerFigure)this.figure;
            Figure contentFigure = containerFigure.getContentFigure();
            Image resultImage = MessageFlowUtils.getImageForPreview(contentFigure);
            ImageFigure tooltip = new ImageFigure(resultImage);
            return Optional.of((Object)tooltip);
        }
        return Optional.absent();
    }

    private void doCollapsibleAction(CollapsibleAction action) {
        MessageFlowEntityRef entityRef = MessageFlowUtils.findMulePathForEntityInOpenEditors(this.getEntity());
        if (entityRef != null) {
            MulePath path = entityRef.getMulePath();
            action.run(MuleCorePlugin.getDesignContext().getMuleProject(), this.getMuleConfiguration(), path);
        }
    }

    @Override
    public void expand() {
        IFigure toolTipFigure = this.figure.getToolTip();
        if (toolTipFigure instanceof ImageFigure) {
            ((ImageFigure)toolTipFigure).getImage().dispose();
        }
        this.figure.setToolTip(null);
        List containersEditPart = this.getChildren();
        for (AbstractGraphicalEditPart containerEditPart : containersEditPart) {
            if (!(containerEditPart instanceof NestedContainerEditPart)) continue;
            NestedContainerEditPart nestedContainerEditPart = (NestedContainerEditPart)containerEditPart;
            NestedContainerDefinition definition = (NestedContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition(((NestedContainer)nestedContainerEditPart.getEntity()).getType());
            containerEditPart.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new NestedContainerEditPolicy(nestedContainerEditPart.getMuleConfiguration(), definition, nestedContainerEditPart.getNestedContainerDecorator()));
        }
        this.showChildrenConnections();
        this.refresh();
        ContainerFigure containerFigure = (ContainerFigure)this.figure;
        this.setCollapseFigure(false);
        containerFigure.setCollapseFigure(this.collapseFigure);
        containerFigure.updateImageFigure();
        containerFigure.getChildren().remove(containerFigure.getContentFigure());
        containerFigure.removeFooterFigure();
        containerFigure.setContentFigure(containerFigure.createContentFigure());
        List<Figure> rowFigures = containerFigure.getRowFigures();
        for (Figure rowFigure : rowFigures) {
            containerFigure.getContentFigure().add((IFigure)rowFigure);
        }
        containerFigure.addContentFigure();
        containerFigure.addFooterFigure();
        CollapsibleAction saveState = (muleProject, muleConfig, path) -> CollapsibleContainerController.getDefault().removeContainer(muleProject, muleConfig, path);
        this.doCollapsibleAction(saveState);
    }

    public void refresh() {
        super.refresh();
        this.updateFigure();
        this.getFigure().repaint();
    }

    @Override
    public void hideChildrenConnections() {
        MessageFlowUtils.hideFlowComponentConnections(this);
    }

    @Override
    public void showChildrenConnections() {
        MessageFlowUtils.showFlowComponentConnections(this);
    }

    @Override
    public boolean isCollapsed() {
        return this.collapseFigure.isCollapsed();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityDeleteEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new EntityDirectEditPolicy());
    }

    @Override
    public void activate() {
        super.activate();
        CollapsibleAction collapseIfNecessary = (muleProject, muleConfig, path) -> this.doCollapseIfNecessary(muleProject, muleConfig, path);
        this.doCollapsibleAction(collapseIfNecessary);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.collapseFigure.erase();
    }

    private void doCollapseIfNecessary(IMuleProject muleProject, MuleConfiguration muleConfig, MulePath path) {
        if (CollapsibleContainerController.getDefault().isCollapsed(muleProject, muleConfig, path)) {
            this.collapse();
        } else if (this.isCollapsed()) {
            this.expand();
        }
    }

    private static interface CollapsibleAction {
        public void run(IMuleProject var1, MuleConfiguration var2, MulePath var3);
    }
}

