/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPartViewer;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.IMessageFlowEntityDeletedEventListener;
import org.mule.tooling.core.event.IMessageFlowEntityMovedListener;
import org.mule.tooling.core.event.MessageFlowEventTypes;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CollapsibleContainerDefinition;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.ICollapsibleEditPart;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.INewElementCreatedOnCanvasListener;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.path.MulePathNode;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class CollapsibleContainerController {
    private Set<CollapsibleContainerDefinition> containers = ConcurrentHashMap.newKeySet();
    private Map<CollapsibleContainerDefinition, IFigure> previewImages = new HashMap<CollapsibleContainerDefinition, IFigure>();

    public static CollapsibleContainerController getDefault() {
        return Singleton.instance;
    }

    public CollapsibleContainerController() {
        this.registerMessageFlowEntityMovedListener();
        this.registerOnElementCreatedOnCanvasListener();
        this.registerOnMessageFlowEntityDeletedListener();
    }

    private void registerMessageFlowEntityMovedListener() {
        MuleCorePlugin.getEventBus().registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_MOVED, (IEventHandler)new IMessageFlowEntityMovedListener(){

            public void onMessageFlowEntityMoved(IMuleProject project, MuleConfiguration muleConfig, IMessageFlowEntity entity, MulePath oldPath) {
                if (oldPath != null && !CollapsibleContainerController.this.containers.isEmpty()) {
                    EntityEditPart<?> editPart;
                    CollapsibleContainerDefinition def = new CollapsibleContainerDefinition(project, muleConfig, oldPath);
                    Set<CollapsibleContainerDefinition> toRemove = CollapsibleContainerController.this.getCollapsedChildren(def);
                    MulePath newPath = muleConfig.getPathFor(entity, project);
                    CollapsibleContainerController.this.removeContainers(toRemove);
                    if (!CollapsibleContainerController.this.sameLevel(oldPath, newPath)) {
                        CollapsibleContainerController.this.doUpdateLevel(project.getName(), muleConfig.getName(), oldPath, x -> x - 1);
                        CollapsibleContainerController.this.doUpdateLevel(project.getName(), muleConfig.getName(), newPath, x -> x + 1);
                    } else if (oldPath.getLastNode() != null && newPath.getLastNode() != null) {
                        try {
                            int oldIndex = Integer.parseInt(oldPath.getLastNode().getMarker());
                            int newIndex = Integer.parseInt(newPath.getLastNode().getMarker());
                            CollapsibleContainerController.this.updateFromTo(oldIndex, newIndex, newPath, muleConfig.getName(), project.getName());
                        }
                        catch (NumberFormatException e) {
                            MuleCorePlugin.logError((String)"Cant parse int from path", (Throwable)e);
                        }
                    }
                    Set<CollapsibleContainerDefinition> toAdd = CollapsibleContainerController.this.getMovedDefs(toRemove, oldPath, newPath);
                    CollapsibleContainerController.this.addContainers(toAdd);
                    MessageFlowEditor editor = MessageFlowUtils.getFlowEditorFromActivePage();
                    if (editor != null && (editPart = editor.findEditPart(entity)) instanceof ICollapsibleEditPart) {
                        editPart.activate();
                    }
                }
            }
        });
    }

    private void registerOnElementCreatedOnCanvasListener() {
        UtilsPlugin.getEventBus().registerListener(EditPartEventTypes.ON_ELEMENT_CREATED_ON_CANVAS, (IEventHandler)new INewElementCreatedOnCanvasListener(){

            @Override
            public void onCreatedNewElementOnCanvas(IMuleProject project, IMessageFlowEntity createdEntity) {
                MessageFlowEditor editor;
                if (!CollapsibleContainerController.this.containers.isEmpty() && (editor = MessageFlowUtils.getFlowEditorFromActivePage()) != null) {
                    String muleProject = project.getName();
                    String muleConfig = editor.getMuleConfiguration().getName();
                    MovePath to = x -> x + 1;
                    CollapsibleContainerController.this.updateLevel(createdEntity, muleProject, muleConfig, to);
                    EntityEditPart<?> editPart = editor.findEditPart(createdEntity);
                    if (editPart != null) {
                        editPart.activate();
                    }
                }
            }
        });
    }

    private void registerOnMessageFlowEntityDeletedListener() {
        MuleCorePlugin.getEventBus().registerListener(MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_DELETED, (IEventHandler)new IMessageFlowEntityDeletedEventListener(){

            public void onNodeDeleted(IMuleProject project, IFile configFile, MuleConfiguration muleConfig, IMessageFlowEntity node) {
                MessageFlowEditor editor;
                if (!CollapsibleContainerController.this.containers.isEmpty() && (editor = MessageFlowUtils.getFlowEditorFromActivePage()) != null) {
                    MovePath to = x -> x - 1;
                    CollapsibleContainerController.this.updateLevel(node, project.getName(), editor.getMuleConfiguration().getName(), to);
                }
            }
        });
    }

    private void removeContainers(Set<CollapsibleContainerDefinition> toRemove) {
        for (CollapsibleContainerDefinition c : toRemove) {
            this.removeContainer(c);
        }
    }

    private void addContainers(Set<CollapsibleContainerDefinition> toAdd) {
        for (CollapsibleContainerDefinition c : toAdd) {
            this.addContainer(c);
        }
    }

    protected void updateFromTo(int oldIndex, int newIndex, MulePath newPath, String muleConfig, String muleProject) {
        for (CollapsibleContainerDefinition c : this.containers) {
            MulePath containerPath;
            if (!c.getAppName().equals(muleProject) || !c.getConfigName().equals(muleConfig) || !this.isRelativePath(containerPath = MulePath.fromPath((String)c.getPath()), newPath)) continue;
            try {
                int level = newPath.getNodes().size() - 1;
                int containerIndex = Integer.parseInt(((MulePathNode)containerPath.getNodes().get(level)).getMarker());
                if (containerIndex < Integer.min(oldIndex, newIndex) || containerIndex > Integer.max(oldIndex, newIndex)) continue;
                if (oldIndex < newIndex) {
                    c.setPath(this.updateNode(containerPath.toPath(), --containerIndex, level));
                    continue;
                }
                c.setPath(this.updateNode(containerPath.toPath(), ++containerIndex, level));
            }
            catch (NumberFormatException e) {
                MuleCorePlugin.logError((String)"Cant parse int from path", (Throwable)e);
            }
        }
    }

    private boolean sameLevel(MulePath path, MulePath otherPath) {
        int size = path.getNodes().size();
        int oldSize = otherPath.getNodes().size();
        MulePath oldLevelPath = this.getLevelPath(otherPath, oldSize - 1);
        MulePath newLevelPath = this.getLevelPath(path, size - 1);
        return size == oldSize && oldLevelPath.toPath().equals(newLevelPath.toPath());
    }

    protected void doUpdateLevel(String muleProject, String muleConfig, MulePath mulePath, MovePath move) {
        for (CollapsibleContainerDefinition k : this.containers) {
            MulePath path = MulePath.fromPath((String)k.getPath());
            if (!k.getAppName().equals(muleProject) || !k.getConfigName().equals(muleConfig) || !this.isRelativePath(path, mulePath)) continue;
            try {
                int baseValue = Integer.parseInt(mulePath.getLastNode().getMarker());
                int index = mulePath.getNodes().size() - 1;
                int kValue = Integer.parseInt(((MulePathNode)path.getNodes().get(index)).getMarker());
                if (baseValue > kValue) continue;
                int newValue = move.move(kValue) > 0 ? move.move(kValue) : 0;
                k.setPath(this.updateNode(k.getPath(), newValue, index));
            }
            catch (NumberFormatException e) {
                MuleCorePlugin.logError((String)"Cant parse int form path", (Throwable)e);
            }
        }
    }

    private String updateNode(String path, int value, int index) {
        MulePath newPath = MulePath.fromPath((String)path);
        newPath.getNodes().set(index, new MulePathNode(newPath.getFlowName(), String.valueOf(value)));
        return newPath.toString();
    }

    private boolean isRelativePath(MulePath path, MulePath mulePath) {
        int level = mulePath.getNodes().size() - 1;
        MulePath levelPath = this.getLevelPath(mulePath, level);
        return path.toPath().startsWith(levelPath.toPath());
    }

    private MulePath getLevelPath(MulePath path, int level) {
        MulePath levelPath = new MulePath(path.getFlowName());
        int toAdd = 0;
        while (toAdd < level) {
            levelPath.addNode((MulePathNode)path.getNodes().get(toAdd));
            ++toAdd;
        }
        return levelPath;
    }

    protected Set<CollapsibleContainerDefinition> getMovedDefs(Set<CollapsibleContainerDefinition> defs, MulePath moveFrom, MulePath moveTo) {
        Set moved = Sets.newConcurrentHashSet();
        for (CollapsibleContainerDefinition d : defs) {
            moved.add(new CollapsibleContainerDefinition(d.getAppName(), d.getConfigName(), this.reparentPath(d.getPath(), moveFrom, moveTo)));
        }
        return moved;
    }

    private String reparentPath(String path, MulePath moveFrom, MulePath moveTo) {
        return path.replace(moveFrom.toPath(), moveTo.toPath());
    }

    protected Set<CollapsibleContainerDefinition> getCollapsedChildren(CollapsibleContainerDefinition def) {
        String path = def.getPath();
        Set children = Sets.newConcurrentHashSet();
        for (CollapsibleContainerDefinition c : this.containers) {
            if (!c.getAppName().equals(def.getAppName()) || !c.getConfigName().equals(def.getConfigName()) || !c.getPath().startsWith(path)) continue;
            children.add(c);
        }
        return children;
    }

    public void addContainer(IMuleProject muleProject, MuleConfiguration muleConfig, MulePath path) {
        CollapsibleContainerDefinition def = new CollapsibleContainerDefinition(muleProject, muleConfig, path);
        this.addContainer(def);
    }

    public void savePreviewImage(CollapsibleContainerDefinition def, IFigure previewFigure) {
        this.previewImages.put(def, previewFigure);
    }

    private void addContainer(CollapsibleContainerDefinition def) {
        for (CollapsibleContainerDefinition d : this.containers) {
            if (!def.equals(d)) continue;
            return;
        }
        this.containers.add(def);
    }

    public void removeContainer(IMuleProject muleProject, MuleConfiguration muleConfig, MulePath path) {
        CollapsibleContainerDefinition def = new CollapsibleContainerDefinition(muleProject, muleConfig, path);
        this.removeContainer(def);
        this.previewImages.remove(def);
    }

    private void removeContainer(CollapsibleContainerDefinition def) {
        for (CollapsibleContainerDefinition d : this.containers) {
            if (!def.equals(d)) continue;
            this.containers.remove(d);
        }
    }

    public boolean isCollapsed(IMuleProject muleProject, MuleConfiguration muleConfig, MulePath path) {
        CollapsibleContainerDefinition def = new CollapsibleContainerDefinition(muleProject, muleConfig, path);
        for (CollapsibleContainerDefinition d : this.containers) {
            if (!d.equals(def)) continue;
            return true;
        }
        return false;
    }

    private void updateLevel(IMessageFlowEntity createdEntity, String muleProject, String muleConfig, MovePath to) {
        MulePath mulePath;
        MessageFlowEntityRef entityRef = MessageFlowUtils.findMulePathForEntityInOpenEditors(createdEntity);
        if (entityRef != null && (mulePath = entityRef.getMulePath()) != null) {
            this.doUpdateLevel(muleProject, muleConfig, mulePath, to);
        }
    }

    public void updateContainers(String muleConfig, MessageFlowEditor editor) {
        String muleProject = MuleCorePlugin.getDesignContext().getMuleProject().getName();
        for (CollapsibleContainerDefinition c : this.containers) {
            if (!c.getAppName().equals(muleProject) || !c.getConfigName().equals(muleConfig)) continue;
            MessageFlowEntity entityForMulePath = MessageFlowUtils.findEntityForMulePathInOpenEditors(c.getPath(), muleProject);
            EntityEditPart<?> editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)editor.getViewer(), (IMessageFlowEntity)entityForMulePath);
            if (editPart instanceof ICollapsibleEditPart) continue;
            this.containers.remove(c);
            this.previewImages.remove(c);
        }
    }

    public Optional<IFigure> getPreviewImage(Optional<CollapsibleContainerDefinition> def) {
        if (def.isPresent() && this.previewImages.containsKey(def.get())) {
            return Optional.of((Object)this.previewImages.get(def.get()));
        }
        return Optional.absent();
    }

    @FunctionalInterface
    private static interface MovePath {
        public int move(int var1);
    }

    private static class Singleton {
        private static final CollapsibleContainerController instance = new CollapsibleContainerController();

        private Singleton() {
        }
    }
}

