/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editpart.IHasContentFigure;
import org.mule.tooling.messageflow.figure.CompartmentLaneLayout;
import org.mule.tooling.messageflow.util.MessageFlowUtils;

public class AlignmentCenterpointAnchor
extends AbstractConnectionAnchor {
    public AlignmentCenterpointAnchor(IFigure figure) {
        super(figure);
        if (figure instanceof IHasContentFigure) {
            this.setOwner(((IHasContentFigure)figure).getContentFigure());
        }
    }

    public Point getLocation(Point reference) {
        Rectangle ownerBounds = this.getOwner().getBounds();
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(ownerBounds);
        this.getOwner().translateToAbsolute((Translatable)r);
        int ownerAlignmentCenter = this.retrieveOwnerAlignmentCenter();
        if (reference != null) {
            if (this.getOwner().getParent().getLayoutManager() instanceof CompartmentLaneLayout && reference.y >= r.y + r.height) {
                return r.getBottom();
            }
            if (reference.x > r.x) {
                return new Point(r.x + r.width, r.y + ownerAlignmentCenter);
            }
            return new Point(r.x - this.getOwner().getInsets().left, r.y + ownerAlignmentCenter);
        }
        return new Point(r.x, r.y + ownerAlignmentCenter);
    }

    private int retrieveOwnerAlignmentCenter() {
        int alignmentCenter = 0;
        if (this.getOwner().getLayoutManager() instanceof CompartmentLaneLayout) {
            CompartmentLaneLayout compartmentLaneLayout = (CompartmentLaneLayout)this.getOwner().getLayoutManager();
            int yOffset = compartmentLaneLayout.getFlowDimensions().getRequestMiddle();
            int topInset = this.getOwner().getInsets().top;
            if (yOffset == 0) {
                int height = this.getOwner().getPreferredSize().height;
                yOffset = height / 2 - topInset;
            }
            alignmentCenter = yOffset + topInset;
        } else {
            alignmentCenter = 0;
        }
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)flowEditorFromActivePage.getViewer();
            ScalableRootEditPart editPart = (ScalableRootEditPart)viewer.getRootEditPart();
            ZoomManager zoomManager = editPart.getZoomManager();
            double zoom = zoomManager.getZoom();
            alignmentCenter = (int)Math.round((double)alignmentCenter * zoom);
        }
        return alignmentCenter;
    }

    public Point getReferencePoint() {
        Rectangle ownerBounds = this.getOwner().getBounds();
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(ownerBounds);
        this.getOwner().translateToAbsolute((Translatable)r);
        int ownerAlignmentCenter = this.retrieveOwnerAlignmentCenter();
        if (ownerAlignmentCenter != 0) {
            return new Point(r.x + r.width / 2, r.y + ownerAlignmentCenter);
        }
        return new Point(r.getCenter());
    }
}

