/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.mule.tooling.messageflow.command.ContainerCreateCommand;
import org.mule.tooling.messageflow.command.EndpointCreateCommand;
import org.mule.tooling.messageflow.command.PatternCreateCommand;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.PatternDefinition;

public class AddCreateCommandsVisitor
extends NodeDefinitionVisitorAdapter {
    private CompoundCommand command;
    private CompartmentLaneDecorator<?> compartmentLaneDecorator;
    protected boolean added = false;
    private EditPart host;
    private EditPart compartmentLaneParent;

    AddCreateCommandsVisitor(CompoundCommand command, CompartmentLaneDecorator<?> compartmentLaneDecorator, EditPart host, EditPart compartmentLaneParent) {
        this.command = command;
        this.compartmentLaneDecorator = compartmentLaneDecorator;
        this.host = host;
        this.compartmentLaneParent = compartmentLaneParent;
    }

    public boolean didAddCommand() {
        return this.added;
    }

    public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
        EndpointCreateCommand endpointCommand = new EndpointCreateCommand(this.getMuleConfigurationDecorator(), this.compartmentLaneDecorator, endpointDefinition, null, null, this.compartmentLaneParent);
        this.command.add((Command)endpointCommand);
        this.command.setLabel(endpointCommand.getLabel());
        this.added = true;
    }

    public void visitPatternDefinition(PatternDefinition patternDefinition) {
        PatternCreateCommand patternCommand = new PatternCreateCommand(this.getMuleConfigurationDecorator(), this.compartmentLaneDecorator, patternDefinition, null);
        this.command.add((Command)patternCommand);
        this.command.setLabel(patternCommand.getLabel());
        this.added = true;
    }

    public void visitContainerDefinition(ContainerDefinition containerDefinition) {
        ContainerCreateCommand containerCreateCommand = new ContainerCreateCommand(this.getMuleConfigurationDecorator(), this.compartmentLaneDecorator, containerDefinition, null);
        this.command.add((Command)containerCreateCommand);
        this.command.setLabel(containerCreateCommand.getLabel());
        this.added = true;
    }

    private MuleConfigurationDecorator getMuleConfigurationDecorator() {
        MuleConfiguration muleConfiguration = ((EntityEditPart)this.host).getMuleConfiguration();
        return new MuleConfigurationDecorator(muleConfiguration);
    }
}

