/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editpart;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.command.CloneEntityCommand;
import org.mule.tooling.messageflow.command.MoveEntityCommand;
import org.mule.tooling.messageflow.command.ReorderEntityCommand;
import org.mule.tooling.messageflow.command.ReparentEntityCommand;
import org.mule.tooling.messageflow.command.TransactionalCommand;
import org.mule.tooling.messageflow.command.TransactionalCompoundCommand;
import org.mule.tooling.messageflow.editpart.CompartmentEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.FeedbackAwareLayoutEditPolicy;
import org.mule.tooling.messageflow.editpart.IHasContentFigure;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.editpart.SplitterEditPart;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.layout.FlowDimensions;
import org.mule.tooling.messageflow.layout.FlowDimensionsAware;
import org.mule.tooling.messageflow.util.CloneEntityVisitor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.ContainerOfMovableEntities;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;

public abstract class AbstractCompartmentLaneLayoutEditPolicy
extends FeedbackAwareLayoutEditPolicy {
    protected EditPart getInsertionReference(Request request) {
        int index = this.getFeedbackIndexFor(request);
        if (index == -1) {
            return null;
        }
        return (EditPart)this.getHost().getChildren().get(index);
    }

    @Override
    protected void showLayoutTargetFeedback(Request request) {
        if (!this.canShowLayoutFeedback(request)) {
            return;
        }
        if (this.getHost().getChildren().isEmpty()) {
            super.showLayoutTargetFeedback(request);
        } else {
            this.showFeedbackWithInsertionRefrence(request);
        }
    }

    protected void showFeedbackWithInsertionRefrence(Request request) {
        Figure laneFigure = this.getHostFigure() instanceof IHasContentFigure ? (Figure)((IHasContentFigure)this.getHostFigure()).getContentFigure() : (Figure)this.getHostFigure();
        IFigure feedback = this.getFeedbackIndicator(request);
        Dimension fbSize = feedback.getPreferredSize();
        EditPart partAfter = this.getInsertionReference(request);
        int snapLocationX = this.getSnapLocationX(fbSize, partAfter);
        LayoutManager layoutManager = laneFigure.getLayoutManager();
        if (!(layoutManager instanceof FlowDimensionsAware)) {
            return;
        }
        FlowDimensionsAware layout = (FlowDimensionsAware)layoutManager;
        FlowDimensions dimensions = layout.getFlowDimensions();
        int requestMiddleY = dimensions.getRequestMiddle();
        feedback.setBounds(new Rectangle(snapLocationX, (requestMiddleY += laneFigure.getLocation().y + laneFigure.getInsets().top) - fbSize.height / 2, fbSize.width, fbSize.height));
    }

    private int getSnapLocationX(Dimension fbSize, EditPart after) {
        IFigure previous = this.getHostFigure();
        for (Object partObj : this.getHost().getChildren()) {
            EntityEditPart entityPart = (EntityEditPart)partObj;
            if (entityPart == after) {
                EntityFigure<?> figure = entityPart.getEntityFigure();
                int x2 = this.getBegginingX((IFigure)figure);
                int x1 = previous != this.getHostFigure() ? this.getEndX(previous) : this.getBegginingX(previous);
                return this.calculateMiddle(fbSize, x1, x2);
            }
            previous = entityPart.getFigure();
        }
        int x1 = this.getEndX(previous);
        int x2 = this.getEndX(this.getHostFigure());
        return this.calculateMiddle(fbSize, x1, x2);
    }

    private int getBegginingX(IFigure figure) {
        return figure.getBounds().x;
    }

    private int getEndX(IFigure figure) {
        return figure.getBounds().x + figure.getBounds().width;
    }

    private int calculateMiddle(Dimension fbSize, int x1, int x2) {
        int middleDistance = (x2 - x1) / 2 - fbSize.width / 2;
        return x1 + middleDistance;
    }

    @Override
    protected int getFeedbackIndexFor(Request request) {
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        int index = 0;
        Point p = this.getLocationFromRequest(request);
        for (EditPart child : children) {
            Rectangle childBounds = this.getAbsoluteBounds((GraphicalEditPart)child);
            if (childBounds.contains(p) ? p.x < childBounds.x + childBounds.width / 2 : p.x < childBounds.x) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected MessageFlowEntity getBeforeMessageFlowEntity(CreateRequest request) {
        EntityEditPart partBefore = (EntityEditPart)this.getInsertionReference((Request)request);
        MessageFlowEntity addBefore = partBefore == null ? null : (MessageFlowEntity)partBefore.getEntity();
        addBefore = MessageFlowUtils.isExceptionStrategy(addBefore) ? null : addBefore;
        return addBefore;
    }

    protected IMessageFlowEntity getAfterMessageFlowEntity(IMessageFlowEntity addBefore, ContainerOfMovableEntities compartmentLane) {
        IMessageFlowEntity addAfter = addBefore == null ? compartmentLane.getLastEntity() : ((CompartmentLaneDecorator)compartmentLane).getEntityBefore(addBefore);
        addAfter = MessageFlowUtils.isExceptionStrategy(addAfter) ? null : addAfter;
        return addAfter;
    }

    protected EditPart getParent() {
        return this.getHost() instanceof NestedContainerEditPart ? this.getHost() : this.getHost().getParent();
    }

    @Override
    protected boolean canShowLayoutFeedback(Request request) {
        if (!(request instanceof CreateRequest)) {
            return request instanceof ChangeBoundsRequest;
        }
        CreateRequest createRequest = (CreateRequest)request;
        Object newObject = null;
        try {
            newObject = createRequest.getNewObject();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return newObject instanceof NodeDefinition;
    }

    protected MessageFlowEntity getEntity() {
        EntityEditPart host = (EntityEditPart)this.getHost();
        return host.getEntity();
    }

    @Override
    protected boolean cannotBeMovedToTheBeginning(ChangeBoundsRequest request) {
        IMessageFlowEntity firstEntity;
        EntityEditPart editPart = (EntityEditPart)this.getInsertionReference((Request)request);
        if (editPart == null) {
            return false;
        }
        IMessageFlowEntity entity = ((EntityDecorator)editPart.getModel()).getEntity();
        return entity instanceof EndpointNode && (firstEntity = ((CompartmentLaneDecorator)this.getHost().getModel()).getFirstEntity()) instanceof EndpointNode && ((EndpointNode)firstEntity).getDirection() == EndpointDirection.INBOUND && firstEntity.equals(entity);
    }

    protected Command createMoveChildCommand(EditPart child, EditPart addBefore) {
        if (child == addBefore || this.getHost().getChildren().size() == 1) {
            return null;
        }
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        ContainerOfMovableEntities compartmentLaneDecorator = (ContainerOfMovableEntities)this.getHost().getModel();
        IMessageFlowEntity addBeforeEntity = addBefore != null ? ((EntityDecorator)addBefore.getModel()).getEntity() : null;
        IMessageFlowEntity addAfterEntity = this.getAfterMessageFlowEntity(addBeforeEntity, compartmentLaneDecorator);
        if (!ModelUtils.isComment((IMessageFlowEntity)messageFlowEntity)) {
            NodeDefinition definition = MessageFlowUtils.getDefinition(messageFlowEntity);
            boolean locationAccepted = definition.getLocationFilter().accepts(addBeforeEntity, addAfterEntity);
            if (!locationAccepted) {
                return null;
            }
            if (!this.canGenerateCommand(definition)) {
                return null;
            }
        }
        ReorderEntityCommand cmd = new ReorderEntityCommand(compartmentLaneDecorator, messageFlowEntity);
        if (addBefore != null) {
            IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)addBefore.getModel()).getEntity();
            cmd.setAfterMessageFlowEntity(afterMessageFlowEntity);
        } else {
            cmd.setAfterMessageFlowEntity(null);
        }
        return cmd;
    }

    protected Command getAddCommand(Request req) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        List editParts = request.getEditParts();
        TransactionalCompoundCommand command = new TransactionalCompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            EditPart insertionReference = this.getInsertionReference((Request)request);
            command.add(this.createAddCommand(child, insertionReference));
            if (editParts.size() > 1) {
                this.adjustIndexes(command);
            }
            ++i;
        }
        this.setLastAndFirstCommand(command);
        return command.unwrap();
    }

    protected void adjustIndexes(CompoundCommand compoundCommand) {
        List commands = compoundCommand.getCommands();
        int i = 1;
        while (i < commands.size()) {
            MoveEntityCommand addCommand = (MoveEntityCommand)commands.get(i);
            addCommand.setIndex(((MoveEntityCommand)commands.get(i - 1)).getIndex() + 1);
            ++i;
        }
    }

    public Command getWrapCommand(Request req) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        List editParts = request.getEditParts();
        TransactionalCompoundCommand command = new TransactionalCompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createAddCommand(child, null));
            if (editParts.size() > 1) {
                this.adjustIndexes(command);
            }
            ++i;
        }
        this.setLastAndFirstCommand(command);
        return command.unwrap();
    }

    private void setLastAndFirstCommand(TransactionalCompoundCommand command) {
        List commands = command.getCommands();
        if (commands.size() == 0) {
            return;
        }
        TransactionalCommand firstCommand = (TransactionalCommand)commands.get(0);
        if (((ReparentEntityCommand)firstCommand).isSplitter()) {
            return;
        }
        firstCommand.setFirstCommand(true);
        TransactionalCommand lastCommand = (TransactionalCommand)commands.get(commands.size() - 1);
        lastCommand.setLastCommand(true);
    }

    protected Command getCloneCommand(ChangeBoundsRequest req) {
        ChangeBoundsRequest request = req;
        List editParts = request.getEditParts();
        TransactionalCompoundCommand command = new TransactionalCompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createCloneCommand(child, this.getInsertionReference((Request)request)));
            if (editParts.size() > 1) {
                this.adjustIndexes(command);
            }
            ++i;
        }
        return command.unwrap();
    }

    private Command createCloneCommand(EditPart child, EditPart addBefore) {
        NodeDefinition entityDefinition;
        IMessageFlowEntity messageFlowEntity = ((EntityDecorator)child.getModel()).getEntity();
        if (MessageFlowUtils.isFlow(child)) {
            return null;
        }
        if (messageFlowEntity instanceof IMessageFlowNode && this.canGenerateCommand(entityDefinition = ((IMessageFlowNode)messageFlowEntity).getDefinition())) {
            ContainerOfMovableEntities compartmentLaneDecorator = (ContainerOfMovableEntities)this.getHost().getModel();
            IMessageFlowEntity addBeforeEntity = addBefore != null ? ((EntityDecorator)addBefore.getModel()).getEntity() : null;
            IMessageFlowEntity addAfterEntity = this.getAfterMessageFlowEntity(addBeforeEntity, compartmentLaneDecorator);
            NodeDefinition definition = MessageFlowUtils.getDefinition(messageFlowEntity);
            boolean locationAccepted = definition.getLocationFilter().accepts(addBeforeEntity, addAfterEntity);
            if (!locationAccepted) {
                return null;
            }
            ContainerOfMovableEntities model = (ContainerOfMovableEntities)this.getHost().getModel();
            CloneEntityCommand cloneEntityCommand = new CloneEntityCommand(model, messageFlowEntity, new CloneEntityVisitor(model, this.getMuleConfiguration(), MuleCorePlugin.getDesignContext().getMuleProject()));
            if (addBefore != null) {
                IMessageFlowEntity afterMessageFlowEntity = ((EntityDecorator)addBefore.getModel()).getEntity();
                cloneEntityCommand.setAfterMessageFlowEntity(afterMessageFlowEntity);
            } else {
                cloneEntityCommand.setAfterMessageFlowEntity(null);
            }
            return cloneEntityCommand;
        }
        return null;
    }

    public boolean canGenerateCommand(NodeDefinition newNode) {
        EditPart grandParent;
        EditPart parent;
        EditPart container = parent = this.getParent();
        if (parent instanceof CompartmentEditPart && (grandParent = parent.getParent()) instanceof SplitterEditPart) {
            container = grandParent;
        }
        if (container instanceof EntityEditPart) {
            Object parentEntity = ((EntityEditPart)container).getEntity();
            NodeDefinition parentDefinition = MessageFlowUtils.getDefinition(parentEntity);
            if (ModelUtils.isComment((IMessageFlowEntity)this.getEntity())) {
                return true;
            }
            if (!newNode.getAcceptedByFilter().accepts(parentDefinition, ModuleManagerNodeDefinitionResolver.get())) {
                return false;
            }
            MessageFlowEntity entity = this.getEntity();
            NodeDefinition entityDefinition = MessageFlowUtils.getDefinition((IMessageFlowEntity)entity);
            if (entityDefinition instanceof RouteDefinition && !((RouteDefinition)entityDefinition).getAcceptsFilter().accepts(newNode, ModuleManagerNodeDefinitionResolver.get())) {
                return false;
            }
        }
        return !(parent instanceof CompartmentEditPart) || !((grandParent = parent.getParent()) instanceof SplitterEditPart) || !this.isExceptionStrategyDefinition(newNode);
    }

    private boolean isExceptionStrategyDefinition(NodeDefinition newNode) {
        return newNode.getCategoryId().equals(Category.EXCEPTIONS.getCategoryString()) && !newNode.getId().equals("http://www.mulesoft.org/schema/mule/core/raise-error");
    }

    protected MuleConfigurationDecorator getConfigDecorator() {
        MuleConfiguration muleConfiguration = ((EntityEditPart)this.getHost()).getMuleConfiguration();
        return new MuleConfigurationDecorator(muleConfiguration);
    }

    protected MuleConfiguration getMuleConfiguration() {
        return (MuleConfiguration)this.getConfigDecorator().getEntity();
    }
}

