/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor.comments;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.utils.ObjectHolder;

public abstract class XmlAnalyzer {
    private static final String SIMPLE_DASH_STRING = "-";
    private static final String DOUBLE_DASH_STRING = "--";
    private static final List<String> START_AND_END_COMMENT = List.of("<!--", "-->");
    private static final String SIMPLE_DASH_REPLACEMENT_STRING = "&#45;";
    private static final String DOUBLE_DASH_REPLACEMENT_STRING = "&#45;&#45;";
    private static final String DOUBLE_DASH_REPLACEMENT_PATTERN_STRING = "(-(&#45;){2,}|(&#45;){2})";
    private static final Pattern double_dash_except_open_comment_pattern = Pattern.compile("(?<!(<!))-{2,}");
    private static final Pattern double_dash_replacement_pattern = Pattern.compile("(-(&#45;){2,}|(&#45;){2})");
    private boolean documentChanged = false;
    private IStructuredDocument docJob = new JobSafeStructuredDocument();

    protected XmlAnalyzer() {
    }

    protected boolean isDocumentChanged() {
        return this.documentChanged;
    }

    protected void setDocumentChanged(boolean documentChanged) {
        this.documentChanged = documentChanged;
    }

    protected IStructuredDocument getDocJob() {
        return this.docJob;
    }

    private void createDocJob(IStructuredDocument document) {
        this.docJob = new JobSafeStructuredDocument(document.getParser());
        this.docJob.set(document.get());
    }

    public void replaceDoubleDashComments(IStructuredDocument document) {
        try {
            if (document != null) {
                this.createDocJob(document);
                IStructuredDocumentRegion validationRegion = this.docJob.getFirstStructuredDocumentRegion();
                while (validationRegion != null) {
                    if (XmlAnalyzer.isXmlComment(validationRegion) && validationRegion.getRegions().size() > 2) {
                        int openingCommentTagLength = validationRegion.getFirstRegion().getLength();
                        int commentTextStartIndex = validationRegion.getStartOffset() + openingCommentTagLength;
                        String commentText = validationRegion.getText(validationRegion.getRegionAtCharacterOffset(commentTextStartIndex));
                        this.replaceInDocJob(commentText, commentTextStartIndex, DOUBLE_DASH_STRING, START_AND_END_COMMENT, DOUBLE_DASH_REPLACEMENT_STRING, double_dash_except_open_comment_pattern, document.getUndoManager());
                    } else if (validationRegion.getRegions().size() > 2) {
                        int contentTextStartIndex = validationRegion.getStartOffset();
                        String contentText = validationRegion.getText();
                        this.replaceInDocJob(contentText, contentTextStartIndex, DOUBLE_DASH_REPLACEMENT_STRING, List.of(), DOUBLE_DASH_STRING, double_dash_replacement_pattern, document.getUndoManager());
                    }
                    validationRegion = validationRegion.getNext();
                }
                this.postReplaceDocument(document);
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Could not replace comments in xml", (Throwable)e);
        }
    }

    protected abstract void replaceInDocJob(String var1, int var2, String var3, List<String> var4, String var5, Pattern var6, IStructuredTextUndoManager var7) throws BadLocationException;

    protected abstract void postReplaceDocument(IStructuredDocument var1) throws BadLocationException;

    protected String getReplacement(String text, String textToFind, String textToReplace, Pattern patternToFind) {
        Matcher matcher = patternToFind.matcher(text);
        StringBuffer sb = new StringBuffer();
        String match = "";
        while (matcher.find()) {
            Object[] replacement;
            match = matcher.group();
            if (match.equals(textToFind)) {
                matcher.appendReplacement(sb, textToReplace);
                continue;
            }
            if (match.matches(DOUBLE_DASH_REPLACEMENT_PATTERN_STRING)) {
                replacement = new String[match.split(SIMPLE_DASH_REPLACEMENT_STRING, -1).length];
                Arrays.fill(replacement, SIMPLE_DASH_STRING);
            } else {
                replacement = new String[match.length()];
                Arrays.fill(replacement, SIMPLE_DASH_REPLACEMENT_STRING);
                replacement[0] = SIMPLE_DASH_STRING;
            }
            matcher.appendReplacement(sb, String.join((CharSequence)"", (CharSequence[])replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static IEditorPart getEditor() {
        IWorkbenchWindow activeWorkbenchWindows = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindows != null && activeWorkbenchWindows.getActivePage() != null && activeWorkbenchWindows.getActivePage().getActiveEditor() != null) {
            return activeWorkbenchWindows.getActivePage().getActiveEditor();
        }
        return null;
    }

    protected static TextSelection getDocumentSelection(IStructuredDocument document) throws BadLocationException {
        ObjectHolder selectionHolder = new ObjectHolder();
        Display.getDefault().syncExec(() -> {
            ISelection selection;
            IEditorPart activeEditor = XmlAnalyzer.getEditor();
            if (activeEditor != null && (selection = activeEditor.getEditorSite().getSelectionProvider().getSelection()) instanceof TextSelection && ((TextSelection)selection).getLength() > 0) {
                int offset = ((TextSelection)selection).getOffset();
                int length = ((TextSelection)selection).getLength();
                selectionHolder.set((Object)new TextSelection(offset, length));
            }
        });
        return (TextSelection)selectionHolder.get();
    }

    protected static void setNewSelection(IStructuredDocument document, TextSelection textSelection) throws BadLocationException {
        Display.getDefault().syncExec(() -> {
            IEditorPart activeEditor = XmlAnalyzer.getEditor();
            if (activeEditor != null) {
                activeEditor.getEditorSite().getSelectionProvider().setSelection((ISelection)textSelection);
            }
        });
    }

    private static boolean isXmlComment(IStructuredDocumentRegion validationRegion) {
        return validationRegion.getType().equals("XML_COMMENT_TEXT") && validationRegion.getFirstRegion().getType().equals("XML_COMMENT_OPEN") && validationRegion.getLastRegion().getType().equals("XML_COMMENT_CLOSE");
    }

    protected static boolean needsReplacement(String text, String textToFind, List<String> textsToIgnore) {
        int ignoreAppearances = 0;
        for (String textToIgnore : textsToIgnore) {
            ignoreAppearances += StringUtils.countMatches((CharSequence)text, (CharSequence)textToIgnore);
        }
        return StringUtils.countMatches((CharSequence)text, (CharSequence)textToFind) > ignoreAppearances;
    }
}

