/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor.comments;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextCommandImpl;
import org.mule.tooling.messageflow.editor.comments.XmlAnalyzer;

public class TypingXmlAnalyzer
extends XmlAnalyzer {
    private boolean undoAction = false;

    protected boolean isUndoAction() {
        return this.undoAction;
    }

    protected void setUndoAction(boolean undoAction) {
        this.undoAction = undoAction;
    }

    private static boolean isUndoAction(int textStartIndex, String textToReplace, StructuredTextCommandImpl commandImp) {
        int textSize = textStartIndex + textToReplace.length();
        if (textSize == commandImp.getTextInserted().length()) {
            String textInserted = commandImp.getTextInserted().substring(textStartIndex, textStartIndex + textToReplace.length());
            return textInserted.equals(textToReplace);
        }
        return false;
    }

    @Override
    protected void replaceInDocJob(String text, int textStartIndex, String textToFind, List<String> textsToIgnore, String textToReplace, Pattern patternToFind, IStructuredTextUndoManager undoManager) throws BadLocationException {
        if (TypingXmlAnalyzer.needsReplacement(text, textToFind, textsToIgnore)) {
            String toReplaceComment = this.getReplacement(text, textToFind, textToReplace, patternToFind);
            CommandStack comStack = undoManager.getCommandStack();
            if (comStack.getMostRecentCommand() instanceof StructuredTextCommandImpl) {
                StructuredTextCommandImpl commandImp = (StructuredTextCommandImpl)comStack.getMostRecentCommand();
                this.setUndoAction(TypingXmlAnalyzer.isUndoAction(textStartIndex, toReplaceComment, commandImp));
                if (!this.isUndoAction()) {
                    this.getDocJob().replace(textStartIndex, text.length(), toReplaceComment);
                    this.setDocumentChanged(true);
                }
            } else {
                this.getDocJob().replace(textStartIndex, text.length(), toReplaceComment);
                this.setDocumentChanged(true);
            }
        }
    }

    @Override
    protected void postReplaceDocument(IStructuredDocument document) throws BadLocationException {
        if (this.isUndoAction()) {
            document.getUndoManager().undo();
        } else if (this.isDocumentChanged()) {
            document.set(this.getDocJob().get());
        }
    }
}

