/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.mule.tooling.core.impl.model.MuleProject;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.model.project.MuleProjectDescriptor;

public class VirtualMuleProject
extends MuleProject {
    private static AtomicInteger instanceCount = new AtomicInteger(1);
    private volatile MuleProjectDescriptor muleProjectDescriptor;
    private Object lock = new Object();
    private MultiPageMessageFlowEditor editor;

    public VirtualMuleProject(IJavaProject javaProject, MultiPageMessageFlowEditor multiPageMessageFlowEditor) {
        super(javaProject);
        this.editor = multiPageMessageFlowEditor;
    }

    public void initialize(ProjectInitializationData initParams) {
    }

    public void save() throws CoreException {
    }

    public String getName() {
        return this.getMuleProjectModel().getName();
    }

    public IFolder getDataMappingsFolder() {
        return (IFolder)this.editor.getInputFile().getParent().getAdapter(IFolder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleProjectDescriptor getMuleProjectModel() {
        MuleProjectDescriptor result = this.muleProjectDescriptor;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.muleProjectDescriptor;
                if (result == null) {
                    MuleProjectDescriptor _muleProjectDescriptor = new MuleProjectDescriptor();
                    _muleProjectDescriptor.setName("virtual-mule-project-" + instanceCount.getAndIncrement());
                    _muleProjectDescriptor.setRuntimeQualifier("");
                    this.muleProjectDescriptor = result = _muleProjectDescriptor;
                }
            }
        }
        return result;
    }

    public String getRuntimeId() {
        return CoreUtils.getDefaultServerRuntimeId();
    }

    public List<MuleExtension> getDeclaredExtensions() {
        return Collections.emptyList();
    }

    public boolean isAccessible() {
        return this.javaProject == null || this.javaProject.getProject().isAccessible();
    }

    public IPath getLocation() {
        if (this.javaProject == null) {
            return Path.fromOSString((String)FileUtils.getTempDirectoryPath());
        }
        return super.getLocation();
    }

    public List<Repository> getProjectRepositories() {
        return Collections.singletonList(Repository.builder().exchangeRepo());
    }

    protected void addMuleExtensionToProject(ExternalContributionMuleModule module) {
    }

    public IProject getProject() {
        return this.javaProject != null ? this.javaProject.getProject() : null;
    }
}

