/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.mule.tooling.messageflow.command.ToggleCommentVisitor;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;

public class ToggleCommentAction
extends WorkbenchPartAction {
    private static final String TOOLTIP_TEXT = "Toggle comment for the selected processors";
    public static final String ID = "org.mule.tooling.messageflow.editor.comment";
    private ToggleCommentVisitor visitor;
    private MessageFlowNode node;

    public ToggleCommentAction(IWorkbenchPart part) {
        super(part);
        this.setDescription(TOOLTIP_TEXT);
        this.setId(ID);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        String keyBinding = bindingService.getBestActiveBindingFormattedFor(ID);
        StringBuilder menuText = new StringBuilder("&Toggle Comment\t");
        if (keyBinding != null) {
            menuText.append(keyBinding);
        }
        this.setText(menuText.toString());
        this.setVisitor(new ToggleCommentVisitor());
        this.setNode(this.getSelectedNode());
    }

    private MessageFlowNode getSelectedNode() {
        MessageFlowEditor messageFlowEditor = MessageFlowUtils.getFlowEditorFromActivePage();
        if (messageFlowEditor != null && !messageFlowEditor.hasMultipleSelectedEntities().booleanValue() && messageFlowEditor.getSelectedEntity().isPresent()) {
            return (MessageFlowNode)messageFlowEditor.getSelectedEntity().get().getEntity();
        }
        return null;
    }

    protected Command createToggleCommentCommand() {
        this.getNode().accept((MessageFlowEntityVisitor)this.getVisitor());
        return this.getVisitor().consumeGeneratedCommand();
    }

    public void run() {
        this.execute(this.createToggleCommentCommand());
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createToggleCommentCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void setVisitor(ToggleCommentVisitor visitor) {
        this.visitor = visitor;
    }

    public ToggleCommentVisitor getVisitor() {
        return this.visitor;
    }

    public void setNode(MessageFlowNode node) {
        this.node = node;
    }

    public MessageFlowNode getNode() {
        return this.node;
    }
}

