/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.IMetadataPropagationCache;
import org.mule.tooling.client.metadata.ProjectPropagation;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MuleErrorFactory;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.path.MulePathsCache;

public class PropagationErrorsCollector {
    private static final String PROPAGATION_ERROR_COLLECTOR = "propagationErrorCollector";
    private final IMuleProject muleProject;
    private final MulePathsCache pathsCache;
    private final IFile configurationFile;

    public static PropagationErrorsCollector newInstance(IMuleProject muleProject, MulePathsCache pathsCache, IFile configurationFile) {
        return new PropagationErrorsCollector(muleProject, pathsCache, configurationFile);
    }

    private PropagationErrorsCollector(IMuleProject muleProject, MulePathsCache pathsCache, IFile configurationFile) {
        this.muleProject = muleProject;
        this.pathsCache = pathsCache;
        this.configurationFile = configurationFile;
    }

    public List<IMuleError> getPropagationErrors() {
        if (this.pathsCache.isValid()) {
            IMetadataPropagationCache propagationCache = (IMetadataPropagationCache)MuleCorePlugin.getStudioContext().get(IMetadataPropagationCache.class);
            Optional projectPropagation = propagationCache.getProjectPropagation(this.muleProject, EditingScope.getCurrent());
            HashSet<IMuleError> propagationErrors = new HashSet<IMuleError>();
            if (projectPropagation.isPresent()) {
                ProjectPropagation propagation = (ProjectPropagation)projectPropagation.get();
                this.processPropagationInfo(propagationErrors, propagation);
            }
            return new ArrayList<IMuleError>(propagationErrors);
        }
        return Collections.emptyList();
    }

    private void processPropagationInfo(HashSet<IMuleError> propagationErrors, ProjectPropagation propagation) {
        for (Map.Entry propagationInfoByLocation : propagation) {
            PropagationInfo propagationInfo = (PropagationInfo)propagationInfoByLocation.getValue();
            for (ComponentDataSenseNotification notification : propagationInfo.getNotifcations()) {
                this.addErrorOrWarningNotification(this.pathsCache, propagationErrors, notification);
            }
        }
    }

    private void addErrorOrWarningNotification(MulePathsCache pathsCache, HashSet<IMuleError> propagationErrors, ComponentDataSenseNotification notification) {
        IComponentPath componentPath;
        String stringPath;
        MulePath mulePath;
        if ((notification.isError() || notification.isWarning()) && notification.getComponentPath().isPresent() && pathsCache.containsPath(mulePath = MulePath.fromPath((String)(stringPath = (componentPath = (IComponentPath)notification.getComponentPath().get()).toPath())))) {
            MessageFlowEntity entity = pathsCache.getEntity(mulePath, this.muleProject);
            String name = MessageFlowUtils.getName((IMessageFlowEntity)entity);
            int severity = notification.isError() ? 2 : 1;
            IMuleError createMessageFlowError = MuleErrorFactory.createMessageFlowError((IResource)this.configurationFile, (String)stringPath, (String)name, (String)notification.getMessage(), (int)severity, (String)PROPAGATION_ERROR_COLLECTOR);
            if (!propagationErrors.contains(createMessageFlowError)) {
                propagationErrors.add(createMessageFlowError);
            }
        }
    }
}

