/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.projection.AbstractStructuredFoldingPosition;
import org.eclipse.wst.sse.ui.internal.projection.AbstractStructuredFoldingStrategy;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.ui.internal.projection.XMLFoldingStrategy;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.w3c.dom.Node;

public class NamespaceFoldingStrategy
extends XMLFoldingStrategy {
    private static final boolean COLLAPSED_BY_DEFAULT = false;

    protected Position calcNewFoldPosition(IndexedRegion indexedRegion) {
        Node nameRegion;
        ElementImpl impl;
        String nodeName;
        Position calcNewFoldPosition = super.calcNewFoldPosition(indexedRegion);
        if (indexedRegion instanceof ElementImpl && calcNewFoldPosition != null && MuleResourceUtils.isBegginingOfMuleConfigFile((String)(nodeName = (impl = (ElementImpl)indexedRegion).getNodeName())) && (nameRegion = impl.getFirstChild()) instanceof NodeImpl) {
            int end = ((NodeImpl)nameRegion).getStartOffset();
            AbstractStructuredFoldingPosition m = new AbstractStructuredFoldingPosition(calcNewFoldPosition.offset, end - calcNewFoldPosition.offset){

                protected int getStartOffset() {
                    return this.getOffset();
                }

                protected int getEndOffset() {
                    return this.getLength();
                }
            };
            return m;
        }
        return calcNewFoldPosition;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IStructuredModel model = null;
        if (this.fProjectionAnnotationModel != null) {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
                if (model != null) {
                    IStructuredDocument structDoc = model.getStructuredDocument();
                    IStructuredDocumentRegion[] structRegions = structDoc.getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
                    Set indexedRegions = this.getIndexedRegions(model, structRegions);
                    ArrayList modifications = new ArrayList();
                    ArrayList<AbstractStructuredFoldingStrategy.FoldingAnnotation> deletions = new ArrayList<AbstractStructuredFoldingStrategy.FoldingAnnotation>();
                    HashMap<AbstractStructuredFoldingStrategy.FoldingAnnotation, Position> additions = new HashMap<AbstractStructuredFoldingStrategy.FoldingAnnotation, Position>();
                    boolean isInsert = dirtyRegion.getType().equals("__insert");
                    boolean isRemove = dirtyRegion.getType().equals("__remove");
                    this.markInvalidAnnotationsForDeletion(dirtyRegion, deletions);
                    Iterator indexedRegionsIter = indexedRegions.iterator();
                    while (indexedRegionsIter.hasNext() && this.fProjectionAnnotationModel != null) {
                        ElementImpl impl;
                        String nodeName;
                        IndexedRegion indexedRegion = (IndexedRegion)indexedRegionsIter.next();
                        if (!this.indexedRegionValidType(indexedRegion)) continue;
                        AbstractStructuredFoldingStrategy.FoldingAnnotation annotation = new AbstractStructuredFoldingStrategy.FoldingAnnotation((AbstractStructuredFoldingStrategy)this, indexedRegion, false);
                        if (indexedRegion instanceof ElementImpl && MuleResourceUtils.isBegginingOfMuleConfigFile((String)(nodeName = (impl = (ElementImpl)indexedRegion).getNodeName()))) {
                            annotation = new AbstractStructuredFoldingStrategy.FoldingAnnotation((AbstractStructuredFoldingStrategy)this, indexedRegion, false);
                        }
                        if (isInsert) {
                            Annotation existingAnno = this.getExistingAnnotation(indexedRegion);
                            if (existingAnno == null) {
                                Position newPos = this.calcNewFoldPosition(indexedRegion);
                                if (newPos == null || newPos.length <= 0) continue;
                                additions.put(annotation, newPos);
                                continue;
                            }
                            this.updateAnnotations(existingAnno, indexedRegion, additions, modifications, deletions);
                            continue;
                        }
                        if (!isRemove) continue;
                        deletions.add(annotation);
                    }
                    if (this.fProjectionAnnotationModel != null) {
                        this.fProjectionAnnotationModel.modifyAnnotations(deletions.toArray(new Annotation[1]), additions, modifications.toArray(new Annotation[0]));
                    }
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    private Set getIndexedRegions(IStructuredModel model, IStructuredDocumentRegion[] structRegions) {
        HashSet<IndexedRegion> indexedRegions = new HashSet<IndexedRegion>();
        int structRegionIndex = 0;
        while (structRegionIndex < structRegions.length && this.fProjectionAnnotationModel != null) {
            ITextRegionList textRegions = structRegions[structRegionIndex].getRegions();
            int textRegionIndex = 0;
            while (textRegionIndex < textRegions.size() && this.fProjectionAnnotationModel != null) {
                int offset = structRegions[structRegionIndex].getStartOffset(textRegions.get(textRegionIndex));
                indexedRegions.add(model.getIndexedRegion(offset));
                ++textRegionIndex;
            }
            ++structRegionIndex;
        }
        return indexedRegions;
    }

    private Annotation getExistingAnnotation(IndexedRegion indexedRegion) {
        Iterator iter = this.fProjectionAnnotationModel.getAnnotationIterator(indexedRegion.getStartOffset(), 1, false, true);
        Annotation anno = null;
        if (iter.hasNext()) {
            anno = (Annotation)iter.next();
        }
        return anno;
    }
}

