/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.ui.internal.revision.FileRevisionEditorInput;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BackgroundRequestExecutor;
import org.mule.tooling.core.background.BatchProcessor;
import org.mule.tooling.core.background.ExecutableRequest;
import org.mule.tooling.core.background.KeyedStore;
import org.mule.tooling.core.background.RequestStore;
import org.mule.tooling.core.background.SimpleExecutableRequestProcessor;
import org.mule.tooling.core.builder.MuleMarkers;
import org.mule.tooling.core.builder.TransformerUtils;
import org.mule.tooling.core.builder.messageflow.MuleToFlowTransformer;
import org.mule.tooling.core.cache.IXmlConfigurationProvider;
import org.mule.tooling.core.cache.MuleConfigurationUtils;
import org.mule.tooling.core.cache.internal.ExternalMuleContentHandler;
import org.mule.tooling.core.dom.DOMFactory;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.location.IAbsoluteLocation;
import org.mule.tooling.core.dom.location.IElementLocation;
import org.mule.tooling.core.dom.location.ILineLocation;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleModuleManagerRestartedListener;
import org.mule.tooling.core.event.IMuleRuntimeChangedListener;
import org.mule.tooling.core.event.MuleConfigurationSavedEvent;
import org.mule.tooling.core.event.OnXmlDocumentEditedEvent;
import org.mule.tooling.core.event.UpdateFlowFromSourceEvent;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.SchemaLocationLookupManager;
import org.mule.tooling.core.sax.SAXUtils;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.editor.ExpressionHighlighter;
import org.mule.tooling.messageflow.editor.FormEditorNavigationLocation;
import org.mule.tooling.messageflow.editor.GlobalElementEditor;
import org.mule.tooling.messageflow.editor.IMessageFlowEditorSavedListener;
import org.mule.tooling.messageflow.editor.InMemoryConfigurationFileEditorInput;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MuleXmlEditorManager;
import org.mule.tooling.messageflow.editor.PropagationErrorsCollector;
import org.mule.tooling.messageflow.editor.VirtualMuleProject;
import org.mule.tooling.messageflow.editor.comments.BlockXmlAnalyzer;
import org.mule.tooling.messageflow.editor.comments.TypingXmlAnalyzer;
import org.mule.tooling.messageflow.editpart.CollapsibleContainerController;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.events.PropagationEventTypes;
import org.mule.tooling.messageflow.outline.MessageFlowOutlinePage;
import org.mule.tooling.messageflow.util.ResourceDeltaDecorator;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.path.MulePathsCache;
import org.mule.tooling.runtime.launch.XmlInput;
import org.mule.tooling.runtime.launch.XmlStorage;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.InMemoryConfigurationFile;
import org.mule.tooling.utils.InMemoryFile;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.collection.ListView;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.w3c.dom.Document;

public class MultiPageMessageFlowEditor
extends FormEditor
implements IResourceChangeListener,
IGotoMarker,
INavigationLocationProvider {
    private static final IMuleError[] MULE_ERRORS_EMPTY_ARRAY = new IMuleError[0];
    private static BackgroundRequestExecutor<ValidateFromEditorRequest> requestExecutor = BackgroundRequestExecutor.builder((String)"Flow editor validation", (BatchProcessor)new SimpleExecutableRequestProcessor()).store((RequestStore)new KeyedStore(ValidateFromEditorRequest::getFilePath)).jobConfigurer(job -> job.setPriority(50)).buildSimple(true, 0L);
    public static final String SAX_FACTORY = "org.mule.tooling.core.sax.SAXDocumentFactoryWithLocator";
    public static final String EDITOR_ID = "org.mule.tooling.messageflow.messageFlowEditor";
    public static final String globalNameAttributeName = "name";
    public static final String PALETTE_VIEW_ID = "org.mule.tooling.ui.palette.PaletteView";
    public boolean readOnly = false;
    protected MessageFlowEditor flowEditor;
    private GlobalElementEditor globalsEditor;
    private StructuredTextEditor source;
    private int flowEditorIndex;
    private int globalsEditorIndex;
    private int sourceEditorIndex;
    private int oldIndex;
    private String oldContent = "";
    private List<IMessageFlowEditorSavedListener> savedListener;
    private String unchangedText;
    private static boolean openingAllEditors = false;
    protected IMuleProject muleProject;
    private final ListenerList<IPageChangedListener> pageChangeListeners = new ListenerList(1);
    private Map<String, Namespace> namespaceByPrefix;
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private final Object editorPagesInitLock = new Object();
    private boolean editorPagesInitialized = false;
    private boolean disposed = false;
    private IPropertyListener propertyChangedListener;
    private Optional<BiConsumer<EditorPart, IProgressMonitor>> saveAction = Optional.empty();
    private boolean saving;
    private IDocumentListener xmlChangeListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            IDocument doc = event.getDocument();
            if (doc instanceof IDocumentExtension4 && ((IDocumentExtension4)doc).getActiveRewriteSession() == null) {
                IDocumentExtension.IReplace replace = (document, owner) -> {
                    JobSafeStructuredDocument documentEvent2 = null;
                    if (event.getDocument() instanceof JobSafeStructuredDocument) {
                        documentEvent2 = (JobSafeStructuredDocument)event.getDocument();
                        TypingXmlAnalyzer xmlAnalyzer = new TypingXmlAnalyzer();
                        xmlAnalyzer.replaceDoubleDashComments((IStructuredDocument)documentEvent2);
                    }
                };
                ((IDocumentExtension)doc).registerPostNotificationReplace((IDocumentListener)this, replace);
            }
        }
    };
    private IDocumentRewriteSessionListener xmlChangeRewriteSessionListener = new IDocumentRewriteSessionListener(){

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            JobSafeStructuredDocument document = null;
            if (event.getDocument() instanceof JobSafeStructuredDocument) {
                document = (JobSafeStructuredDocument)event.getDocument();
                BlockXmlAnalyzer xmlAnalyzer = new BlockXmlAnalyzer();
                xmlAnalyzer.replaceDoubleDashComments((IStructuredDocument)document);
            }
        }
    };

    public MuleConfiguration getMuleConfiguration() {
        if (this.getFlowEditor() != null && !this.isDisposed()) {
            return this.getFlowEditor().getMuleConfiguration();
        }
        return null;
    }

    public void setSaveAction(BiConsumer<EditorPart, IProgressMonitor> saveAction) {
        this.saveAction = Optional.of(saveAction);
    }

    private void basicInitialization(IProject project, IEditorSite site, boolean readOnly, Supplier<FileEditorInput> iFileEditor) throws PartInitException {
        if (project.isOpen()) {
            try {
                this.createMuleProject(project);
            }
            catch (Exception e) {
                throw new PartInitException("Failed to create initialize mule project.", (Throwable)e);
            }
            this.namespaceByPrefix = this.initializeNamespaceByPrefix();
            this.setInput((IEditorInput)iFileEditor.get());
            site.setSelectionProvider((ISelectionProvider)new SelectionProvider(this));
            this.savedListener = new ArrayList<IMessageFlowEditorSavedListener>();
            if (!readOnly) {
                this.registerListener();
                this.propertyChangedListener = new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        MultiPageMessageFlowEditor.this.getFlowEditor().enableChecking(true);
                    }
                };
            }
        } else {
            this.closeLater();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            IFile file = fileEditorInput.getFile();
            if (!(file instanceof InMemoryFile)) {
                if (file.exists()) {
                    this.readOnly = false;
                    IProject project = file.getProject();
                    this.basicInitialization(project, site, this.readOnly, () -> fileEditorInput);
                }
            } else {
                if (!(file instanceof InMemoryConfigurationFile)) throw new PartInitException("Cannot initialize MuliPageMessageFlowEditor for '" + file.getFullPath().toOSString() + "'");
                this.readOnly = true;
                IProject project = file.getProject();
                this.basicInitialization(project, site, this.readOnly, () -> fileEditorInput);
            }
        } else if (input instanceof JarEntryEditorInput) {
            JarEntryEditorInput jarEntryEditorInput = (JarEntryEditorInput)input;
            JarEntryFile entryFile = (JarEntryFile)jarEntryEditorInput.getStorage();
            IProject project = entryFile.getPackageFragmentRoot().getJavaProject().getProject();
            this.readOnly = true;
            this.basicInitialization(project, site, this.readOnly, () -> {
                for (MuleConfiguration muleConfiguration : this.muleProject.getConfigurationsCache().getExternalConfigurations()) {
                    if (!muleConfiguration.getName().equals(entryFile.getName())) continue;
                    InMemoryConfigurationFile inMemoryConfigurationFile = (InMemoryConfigurationFile)this.muleProject.getConfigurationsCache().getConfigurationFile(muleConfiguration);
                    return new InMemoryConfigurationFileEditorInput(inMemoryConfigurationFile);
                }
                return null;
            });
        } else {
            if (!(input instanceof IStorageEditorInput)) throw new IllegalArgumentException("Invalid input for Mule editor.");
            this.readOnly = true;
            this.setInput(input);
            site.setSelectionProvider((ISelectionProvider)new SelectionProvider(this));
        }
        if (!this.readOnly) return;
        Image image = Activator.getImages().getImageDescriptor("icons/Mule-ReadOnly-16x16.png").createImage();
        this.setTitleImage(image);
    }

    public void closeLater() {
        this.getSite().getShell().getDisplay().asyncExec(() -> this.close(false));
    }

    protected void createMuleProject(IProject project) {
        this.muleProject = MuleRuntime.create((IProject)project);
        if (this.muleProject == null) {
            IJavaProject virtualJavaProject = JavaCore.create((IProject)project);
            VirtualMuleProject virtualProject = new VirtualMuleProject(virtualJavaProject, this);
            virtualProject.initialize(null);
            this.muleProject = virtualProject;
        }
    }

    private void registerListener() {
        EventBus eventBus = MuleCorePlugin.getEventBus();
        this.eventBusHelper.registerUIListener(eventBus, CoreEventTypes.ON_MULE_MODULE_MANAGER_RESTARTED, (IEventHandler)new IMuleModuleManagerRestartedListener(){

            public void onMuleModuleManagerRestarted(IMuleModuleManager muleModuleManager) {
                if (MultiPageMessageFlowEditor.this.isDisposed()) {
                    return;
                }
                IMuleProject currentProject = MultiPageMessageFlowEditor.this.flowEditor.getMuleProject();
                if (currentProject != null && currentProject.getModuleManager().equals(muleModuleManager)) {
                    MultiPageMessageFlowEditor.this.reloadUI();
                }
            }
        });
        this.eventBusHelper.registerListener(eventBus, CoreEventTypes.ON_MULE_RUNTIME_CHANGED, (IEventHandler)new IMuleRuntimeChangedListener(){

            public void beforeChanging(String fromId, String toId, IMuleProject muleProject) {
                if (MultiPageMessageFlowEditor.this.isDisposed()) {
                    return;
                }
                if (muleProject.equals(MultiPageMessageFlowEditor.this.getMuleProject())) {
                    MultiPageMessageFlowEditor.this.getFlowEditor().setSelection((ISelection)new StructuredSelection());
                }
            }

            public void afterChanging(String fromId, String toId, IMuleProject muleProject) {
                if (MultiPageMessageFlowEditor.this.isDisposed()) {
                    return;
                }
                if (muleProject.equals(MultiPageMessageFlowEditor.this.getMuleProject())) {
                    MultiPageMessageFlowEditor.this.reloadUI();
                }
            }
        });
        this.eventBusHelper.registerListener(eventBus, CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)((FileChangedEventListener)event -> {
            if (this.isDisposed()) {
                return;
            }
            if (event.isEventType(FileChangedEvent.ChangeType.DELETED)) {
                this.checkForFileDeleted(event);
            }
        }));
        this.eventBusHelper.registerUIListener(eventBus, PropagationEventTypes.ON_METADATA_PROPAGATION_FINISHED, propagationInfo -> {
            if (this.isDisposed()) {
                return;
            }
            this.validateIfPropagationBelongsToCurrentEditor(propagationInfo);
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
    }

    private void validateIfPropagationBelongsToCurrentEditor(PropagationInfo propagationInfo) {
        this.getCurrentSelection().ifPresent(entity -> {
            MulePath currentEntityPath = this.getMuleConfiguration().getPathFor((IMessageFlowEntity)entity);
            if (currentEntityPath != null) {
                String path = currentEntityPath.toPath();
                IComponentPath propagationPath = propagationInfo.getComponentPath();
                if (propagationPath != null) {
                    if (path.equals(propagationPath.toPath())) {
                        this.validate();
                    }
                } else {
                    this.validate();
                }
            }
        });
    }

    private Optional<MessageFlowEntity> getCurrentSelection() {
        Object selected;
        ISelection selection;
        ISelectionProvider selectionProvider;
        Optional<Object> selectedEntity = Optional.empty();
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite != null && (selectionProvider = editorSite.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof StructuredSelection && (selected = ((StructuredSelection)selection).getFirstElement()) instanceof EntityEditPart) {
            EntityEditPart firstElement = (EntityEditPart)selected;
            selectedEntity = Optional.ofNullable(firstElement.getEntity());
        }
        return selectedEntity;
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
        if (this.muleProject != null && MuleProjectKind.DOMAIN.classifies(this.muleProject)) {
            this.getFlowEditor().dispose();
        }
        this.unregisterListeners();
        this.cleanEditorMarker();
        this.pageChangeListeners.clear();
        this.source = null;
        this.flowEditor = null;
        this.globalsEditor = null;
        this.getEditorSite().setSelectionProvider(null);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Object getAdapter(Class adapter) {
        MessageFlowEditor flowEditor = this.getFlowEditor();
        if (flowEditor == null) {
            return null;
        }
        if (IContentOutlinePage.class.isAssignableFrom(adapter)) {
            return new MessageFlowOutlinePage(this, flowEditor);
        }
        Object result = super.getAdapter(adapter);
        if (result == null) {
            result = GraphicalViewer.class.isAssignableFrom(adapter) ? flowEditor.getGraphicalViewer() : flowEditor.getAdapter(adapter);
        }
        return result;
    }

    public IFile getInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        return editorInput != null ? (IFile)editorInput.getAdapter(IFile.class) : null;
    }

    public void openEditor() throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(this.getInputFile()), EDITOR_ID);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean changed = this.checkForFileDeleteOrChange(event);
        boolean moved = this.checkForProjectMove(event);
        if (!moved && changed && !this.saving) {
            this.getContainer().getDisplay().asyncExec(this::updateFlowFromSource);
        }
        if (changed) {
            this.saving = false;
        }
    }

    public static void removeAnnotations(StructuredTextEditor textEditor, IMuleError[] errors) {
        IAnnotationModel annotationModel = textEditor.getTextViewer().getAnnotationModel();
        ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
        Iterator i = annotationModel.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation annotation = (Annotation)i.next();
            if (MultiPageMessageFlowEditor.containsErrorMessage(annotation.getText(), errors) || !"org.eclipse.wst.sse.ui.temp.error".equals(annotation.getType())) continue;
            toRemove.add(annotation);
        }
        for (Annotation annotation : toRemove) {
            annotationModel.removeAnnotation(annotation);
        }
    }

    private static boolean containsErrorMessage(String message, IMuleError[] errors) {
        IMuleError[] iMuleErrorArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            IMuleError muleError = iMuleErrorArray[n2];
            if (message.equals(muleError.getMessage())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean checkForFileDeleteOrChange(IResourceChangeEvent event) {
        IFile fileInput = this.getInputFile();
        if (fileInput == null) {
            return false;
        }
        if (event.getDelta() != null) {
            FileChangedDeltaVisitor visitor = new FileChangedDeltaVisitor(fileInput);
            try {
                event.getDelta().accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                MuleCorePlugin.getLog().log(e.getStatus());
            }
            return visitor.changed;
        }
        return false;
    }

    private boolean checkForProjectMove(IResourceChangeEvent event) {
        ProjectMoveDeltaVisitor visitor = new ProjectMoveDeltaVisitor();
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept((IResourceDeltaVisitor)visitor);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.getLog().log(e.getStatus());
        }
        return visitor.move;
    }

    public void gotoMarker(IMarker marker) {
        try {
            if (MuleResourceUtils.isConfigFile((IResource)marker.getResource())) {
                if (marker.isSubtypeOf("org.mule.tooling.core.messageFlowError")) {
                    this.setActivePage(this.flowEditorIndex);
                    this.getFlowEditor().gotoMarker(marker);
                } else if (marker.isSubtypeOf("org.mule.tooling.core.muleXMLError")) {
                    this.setActivePage(this.sourceEditorIndex);
                }
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error accessing error markers...", (Throwable)e);
        }
    }

    protected void checkForFileDeleted(FileChangedEvent event) {
        IFile fileInput = this.getInputFile();
        if (fileInput != null && event.getFile().equals((Object)fileInput)) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(() -> this.close(false));
        }
    }

    protected void addPages() {
        IFileEditorInput fileInput;
        IFile editorInputFile;
        System.setProperty("org.dom4j.factory", SAX_FACTORY);
        IEditorInput inputEditor = this.getEditorInput();
        if (inputEditor == null) {
            return;
        }
        if (inputEditor instanceof FileRevisionEditorInput) {
            try {
                StructuredTextEditor xmlEditor = MuleXmlEditorManager.get().getXmlEditor(this);
                this.setSource(xmlEditor);
                this.sourceEditorIndex = this.addPage((IEditorPart)this.getSource(), this.getEditorInput());
                this.getSource().getTextViewer().addTextPresentationListener((ITextPresentationListener)new ExpressionHighlighter(this.getSource().getTextViewer(), this));
                this.setPageText(this.sourceEditorIndex, "Configuration XML");
                return;
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        final FileEditorInput flowFileEditorInput = !((editorInputFile = (fileInput = (IFileEditorInput)inputEditor).getFile()) instanceof InMemoryConfigurationFile) ? new FileEditorInput(editorInputFile) : new InMemoryConfigurationFileEditorInput((InMemoryConfigurationFile)editorInputFile);
        final FileEditorInput configFileEditorInput = !(editorInputFile instanceof InMemoryConfigurationFile) ? new FileEditorInput(editorInputFile) : new InMemoryConfigurationFileEditorInput((InMemoryConfigurationFile)editorInputFile);
        final boolean outOfSync = !editorInputFile.isSynchronized(0);
        Callable<Void> call = new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    MultiPageMessageFlowEditor.this.setFlowEditor(MultiPageMessageFlowEditor.this.createMessageFlowEditor());
                    if (!outOfSync) {
                        MultiPageMessageFlowEditor.this.setGlobalsEditor(MultiPageMessageFlowEditor.this.createGlobalElementEditor(MultiPageMessageFlowEditor.this.readOnly));
                    }
                    Object object = MultiPageMessageFlowEditor.this.editorPagesInitLock;
                    synchronized (object) {
                        this.initMessageFlowEditor(flowFileEditorInput);
                        if (!outOfSync) {
                            this.initGlobalEditor(flowFileEditorInput);
                            if (!(editorInputFile instanceof InMemoryConfigurationFile) && !MultiPageMessageFlowEditor.this.readOnly) {
                                this.initXmlEditor(configFileEditorInput);
                            } else if (editorInputFile instanceof InMemoryConfigurationFile) {
                                this.initXmlReadOnly((InMemoryConfigurationFile)editorInputFile);
                            } else {
                                this.initXmlReadOnly((InMemoryFile)editorInputFile);
                            }
                            MultiPageMessageFlowEditor.this.updateOldContent();
                        }
                        MultiPageMessageFlowEditor.this.updateFlowFromSource();
                        if (MultiPageMessageFlowEditor.this.getFlowEditor().isCorrupted()) {
                            MultiPageMessageFlowEditor.this.setActivePage(MultiPageMessageFlowEditor.this.sourceEditorIndex);
                        }
                        MultiPageMessageFlowEditor.this.editorPagesInitialized = true;
                    }
                }
                catch (PartInitException e) {
                    Activator.openError(MultiPageMessageFlowEditor.this.getContainer().getShell(), (Exception)((Object)e));
                }
                return null;
            }

            private void initXmlEditor(FileEditorInput configFileEditorInput2) throws PartInitException {
                StructuredTextEditor xmlEditor = MuleXmlEditorManager.get().getXmlEditor(MultiPageMessageFlowEditor.this);
                MultiPageMessageFlowEditor.this.setSource(xmlEditor);
                MultiPageMessageFlowEditor.this.sourceEditorIndex = MultiPageMessageFlowEditor.this.addPage((IEditorPart)MultiPageMessageFlowEditor.this.getSource(), (IEditorInput)configFileEditorInput2);
                MultiPageMessageFlowEditor.this.getSource().getTextViewer().addTextPresentationListener((ITextPresentationListener)new ExpressionHighlighter(MultiPageMessageFlowEditor.this.getSource().getTextViewer(), MultiPageMessageFlowEditor.this));
                MultiPageMessageFlowEditor.this.setPageText(MultiPageMessageFlowEditor.this.sourceEditorIndex, "Configuration XML");
            }

            private void initXmlReadOnly(InMemoryConfigurationFile inMemoryConfigurationFile) throws PartInitException {
                InMemoryFile.IContentHandler handler = inMemoryConfigurationFile.getHandler();
                XmlStorage xmlStorage = new XmlStorage(handler.getContent(), ((ExternalMuleContentHandler)handler).getPath(), inMemoryConfigurationFile.getFullPath());
                XmlInput xmlInput = new XmlInput((IStorage)xmlStorage, inMemoryConfigurationFile.getFullPath().lastSegment());
                MultiPageMessageFlowEditor.this.setSource(MuleXmlEditorManager.get().getXmlEditor(MultiPageMessageFlowEditor.this));
                MultiPageMessageFlowEditor.this.sourceEditorIndex = MultiPageMessageFlowEditor.this.addPage((IEditorPart)MultiPageMessageFlowEditor.this.getSource(), (IEditorInput)xmlInput);
                MultiPageMessageFlowEditor.this.setPageText(MultiPageMessageFlowEditor.this.sourceEditorIndex, "Configuration XML");
            }

            private void initXmlReadOnly(InMemoryFile inMemoryConfigurationFile) throws PartInitException {
                InMemoryFile.IContentHandler handler = inMemoryConfigurationFile.getHandler();
                XmlStorage xmlStorage = new XmlStorage(handler.getContent(), inMemoryConfigurationFile.requestPath(), inMemoryConfigurationFile.getFullPath());
                XmlInput xmlInput = new XmlInput((IStorage)xmlStorage, inMemoryConfigurationFile.getFullPath().lastSegment());
                StructuredTextEditor xmlEditor = MuleXmlEditorManager.get().getXmlEditor(MultiPageMessageFlowEditor.this);
                MultiPageMessageFlowEditor.this.setSource(xmlEditor);
                MultiPageMessageFlowEditor.this.sourceEditorIndex = MultiPageMessageFlowEditor.this.addPage((IEditorPart)MultiPageMessageFlowEditor.this.getSource(), (IEditorInput)xmlInput);
                MultiPageMessageFlowEditor.this.getSource().getTextViewer().addTextPresentationListener((ITextPresentationListener)new ExpressionHighlighter(MultiPageMessageFlowEditor.this.getSource().getTextViewer(), MultiPageMessageFlowEditor.this));
                MultiPageMessageFlowEditor.this.setPageText(MultiPageMessageFlowEditor.this.sourceEditorIndex, "Configuration XML");
            }

            private void initGlobalEditor(FileEditorInput flowFileEditorInput2) throws PartInitException {
                MultiPageMessageFlowEditor.this.globalsEditorIndex = MultiPageMessageFlowEditor.this.addPage((IEditorPart)MultiPageMessageFlowEditor.this.getGlobalsEditor(), (IEditorInput)flowFileEditorInput2);
                MultiPageMessageFlowEditor.this.setPageText(MultiPageMessageFlowEditor.this.globalsEditorIndex, "Global Elements");
            }

            private void initMessageFlowEditor(FileEditorInput flowFileEditorInput2) throws PartInitException {
                if (!MuleProjectKind.DOMAIN.classifies(MultiPageMessageFlowEditor.this.muleProject)) {
                    MultiPageMessageFlowEditor.this.flowEditorIndex = MultiPageMessageFlowEditor.this.addPage((IEditorPart)MultiPageMessageFlowEditor.this.getFlowEditor(), (IEditorInput)flowFileEditorInput2);
                    MultiPageMessageFlowEditor.this.setPageText(MultiPageMessageFlowEditor.this.flowEditorIndex, "Message Flow");
                } else {
                    this.hidePage(MultiPageMessageFlowEditor.this.getFlowEditor(), flowFileEditorInput2);
                }
                MultiPageMessageFlowEditor.this.getFlowEditor().addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (propId == 257) {
                            SilentRunner.run(() -> MultiPageMessageFlowEditor.this.validate());
                        }
                    }
                });
            }

            private void hidePage(MessageFlowEditor editor, FileEditorInput input) {
                IEditorSite site = MultiPageMessageFlowEditor.this.createSite((IEditorPart)editor);
                try {
                    editor.init(site, (IEditorInput)input);
                    Composite emptyParent = new Composite(MultiPageMessageFlowEditor.this.getContainer(), 0);
                    editor.createPartControl(emptyParent);
                }
                catch (PartInitException e) {
                    MuleCorePlugin.logError((String)"Error initializing flow editor", (Throwable)e);
                }
            }
        };
        EditingScope fileInputScope = ProjectStructureContributionManager.getDefault().getScope((IResource)editorInputFile);
        StudioDesignContextRunner.runSilentWithContext((Callable)call, (IMuleProject)this.muleProject, (EditingScope)fileInputScope, null);
        ThemeUtils.setCssId((Object)this.getContainer(), (String)"org-mule-tooling-MultiPageTabs");
    }

    protected MessageFlowEditor createMessageFlowEditor() {
        return new MessageFlowEditor(this, new MultiPageMessageEditorXmlConfigurationProvider(), this.readOnly);
    }

    public String getPartName() {
        if (this.getEditorInput() instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            return MuleResourceUtils.getCleanFileName((IFile)file);
        }
        if (this.getEditorInput() instanceof XmlInput) {
            return ((XmlInput)this.getEditorInput()).getName();
        }
        return "Mule Config Container Editor";
    }

    protected IEditorSite createSite(IEditorPart page) {
        MultiPageMessageFlowEditorStite site = null;
        site = page == this.getSource() ? new MultiPageMessageFlowEditorStite((MultiPageEditorPart)this, page, ContentTypeIdForXML.ContentTypeID_XML + ".source") : new MultiPageMessageFlowEditorStite((MultiPageEditorPart)this, page, EDITOR_ID);
        return site;
    }

    public synchronized void doSave(IProgressMonitor monitor) {
        this.saving = true;
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (IMessageFlowEditorSavedListener listener : MultiPageMessageFlowEditor.this.savedListener) {
                    listener.onBeforeSave();
                }
                int activePage = MultiPageMessageFlowEditor.this.getActivePage();
                if (activePage == MultiPageMessageFlowEditor.this.flowEditorIndex || activePage == MultiPageMessageFlowEditor.this.globalsEditorIndex) {
                    MultiPageMessageFlowEditor.this.getGlobalEditor().doSave((IProgressMonitor)subMonitor.split(1));
                    MultiPageMessageFlowEditor.this.getFlowEditor().doSave((IProgressMonitor)subMonitor.split(1));
                    MultiPageMessageFlowEditor.this.getSource().doSave((IProgressMonitor)subMonitor.split(1));
                } else if (activePage == MultiPageMessageFlowEditor.this.sourceEditorIndex) {
                    boolean sourceChanged = MultiPageMessageFlowEditor.this.sourceChanged();
                    MultiPageMessageFlowEditor.this.saveEditor((EditorPart)MultiPageMessageFlowEditor.this.getSource(), (IProgressMonitor)subMonitor.split(1));
                    MultiPageMessageFlowEditor.this.updateFlowFromSource();
                    MultiPageMessageFlowEditor.this.updateOldContent();
                    MultiPageMessageFlowEditor.this.saveEditor(MultiPageMessageFlowEditor.this.getFlowEditor(), (IProgressMonitor)subMonitor.split(1));
                    MultiPageMessageFlowEditor.this.saveEditor((EditorPart)MultiPageMessageFlowEditor.this.getGlobalEditor(), (IProgressMonitor)subMonitor.split(1));
                    if (sourceChanged) {
                        MultiPageMessageFlowEditor.this.notifyXmlDocumentModified();
                    }
                }
                for (IMessageFlowEditorSavedListener listener : MultiPageMessageFlowEditor.this.savedListener) {
                    listener.onAfterSave();
                }
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new MuleConfigurationSavedEvent(MultiPageMessageFlowEditor.this.getMuleProject(), MultiPageMessageFlowEditor.this.getMuleConfiguration()));
                return null;
            }
        }, (IMuleProject)this.getMuleProject());
    }

    protected void saveEditor(EditorPart editor, IProgressMonitor monitor) {
        this.saveAction.orElse((ed, mon) -> ed.doSave(mon)).accept(editor, monitor);
    }

    public void markAsModified() {
        this.getFlowEditor().forceModified();
    }

    public void doSaveAs() {
        this.getFlowEditor().doSaveAs();
    }

    public void addSavedListener(IMessageFlowEditorSavedListener listener) {
        this.savedListener.add(listener);
    }

    public void removeSavedListener(IMessageFlowEditorSavedListener listener) {
        if (this.savedListener != null) {
            this.savedListener.remove(listener);
        }
    }

    public boolean isSaveAsAllowed() {
        if (this.getFlowEditor() != null) {
            return !this.isDisposed() && this.getFlowEditor().isSaveAsAllowed();
        }
        return false;
    }

    public MessageFlowEditor getFlowEditor() {
        return this.flowEditor;
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.add((Object)listener);
        super.addPageChangedListener(listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.remove((Object)listener);
        super.removePageChangedListener(listener);
    }

    private void firePageChanged(final PageChangedEvent event) {
        for (final IPageChangedListener listener : this.pageChangeListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.pageChanged(event);
                }
            });
        }
    }

    public Object getSelectedPage() {
        Object selectedPage = super.getSelectedPage();
        if (selectedPage != null) {
            return selectedPage;
        }
        int index = this.getActivePage();
        if (index == -1) {
            return null;
        }
        IEditorPart editor = this.getEditor(index);
        if (editor != null) {
            return editor;
        }
        return this.getControl(index);
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new FormEditorNavigationLocation(this);
    }

    public INavigationLocation createNavigationLocation() {
        return new FormEditorNavigationLocation(this);
    }

    protected synchronized void pageChange(int newPageIndex) {
        if (this.getSourceEditorIndex() == newPageIndex) {
            this.addXmlEditorChangeListener();
        } else {
            this.removeXmlEditorChangeListener();
        }
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, this.getSelectedPage()));
        boolean success = true;
        boolean wasInSourceEditor = this.shouldUpdateFlowFromSource(newPageIndex);
        if (wasInSourceEditor && !this.shouldUpdateSourceFromFlow(newPageIndex)) {
            success = (Boolean)StudioDesignContextRunner.runSilentWithMuleProject(this::updateFlowFromSource, (IMuleProject)this.getMuleProject(), (Object)false);
        }
        boolean sourceChanged = this.sourceChanged();
        if (success) {
            this.oldIndex = newPageIndex;
            this.updateOldContent();
            super.pageChange(newPageIndex);
            this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
        } else {
            this.setActivePage(this.oldIndex);
        }
        if (sourceChanged && wasInSourceEditor) {
            this.notifyXmlDocumentModified();
        }
        if (SystemUtils.IS_OS_MAC && this.getActivePage() == 0 && this.getFlowEditor() != null && this.getFlowEditor().getGraphicalViewer() != null) {
            this.getFlowEditor().getGraphicalViewer().getControl().redraw();
        }
    }

    private IDocument getIDocument() {
        MultiPageMessageFlowEditor editor = MultiPageMessageFlowEditor.getActive();
        if (editor != null) {
            return (IDocument)editor.getAdapter(IDocument.class);
        }
        return null;
    }

    private void addXmlEditorChangeListener() {
        IDocument doc = this.getIDocument();
        if (doc != null) {
            doc.addDocumentListener(this.xmlChangeListener);
            if (doc instanceof IDocumentExtension4) {
                IDocumentExtension4 docExt4 = (IDocumentExtension4)doc;
                docExt4.addDocumentRewriteSessionListener(this.xmlChangeRewriteSessionListener);
            }
        }
    }

    private void removeXmlEditorChangeListener() {
        IDocument doc = this.getIDocument();
        if (doc != null) {
            doc.removeDocumentListener(this.xmlChangeListener);
            if (doc instanceof IDocumentExtension4) {
                IDocumentExtension4 docExt4 = (IDocumentExtension4)doc;
                docExt4.removeDocumentRewriteSessionListener(this.xmlChangeRewriteSessionListener);
            }
        }
    }

    private void notifyXmlDocumentModified() {
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new OnXmlDocumentEditedEvent(this.getMuleProject(), this.getInputFile()));
    }

    private void updateOldContent() {
        this.oldContent = Optional.ofNullable(this.getDocument()).map(IDocument::get).orElse("");
    }

    private boolean sourceChanged() {
        String currentSourceContent = Optional.ofNullable(this.getDocument()).map(IDocument::get).orElse("");
        return !this.oldContent.equals(currentSourceContent);
    }

    private boolean shouldUpdateSourceFromFlow(int newPageIndex) {
        boolean shouldUpdate = !(newPageIndex != this.sourceEditorIndex && this.getCurentPageIndex() != this.getFlowEditorIndex() || !this.getFlowEditor().isDirty() && !this.getGlobalEditor().isDirty());
        return this.readOnly ? false : shouldUpdate;
    }

    private boolean shouldUpdateFlowFromSource(int newPageIndex) {
        return newPageIndex != this.sourceEditorIndex && this.oldIndex == this.sourceEditorIndex;
    }

    public int getFlowEditorIndex() {
        return this.flowEditorIndex;
    }

    public int getGlobalsEditorIndex() {
        return this.globalsEditorIndex;
    }

    public int getSourceEditorIndex() {
        return this.sourceEditorIndex;
    }

    public int getCurentPageIndex() {
        return this.oldIndex;
    }

    public List<IEditorPart> getEditors() {
        int pageCount = this.getPageCount();
        return IntStream.range(0, pageCount).mapToObj(arg_0 -> ((MultiPageMessageFlowEditor)this).getEditor(arg_0)).collect(Collectors.toList());
    }

    public String updateSourceFromFlow() {
        return this.getDocument().get();
    }

    private Set<Namespace> getAllNamespaces() {
        HashSet allNamespaces = Sets.newHashSet((Iterable)SchemaLocationLookupManager.instance().getAllNamespaces());
        IServerDefinition serverDefinition = this.getServerDefinition();
        if (serverDefinition != null) {
            allNamespaces.addAll(MuleCorePlugin.getModuleContributionManager().getExternalContributionsNamespaces(serverDefinition));
        }
        return allNamespaces;
    }

    private Map<String, Namespace> initializeNamespaceByPrefix() {
        return MultiPageMessageFlowEditor.formNamespacesMapping(this.getAllNamespaces());
    }

    public static Map<String, Namespace> formNamespacesMapping(Collection<Namespace> namespaces) {
        HashMap<String, Namespace> result = new HashMap<String, Namespace>();
        for (Namespace namespace : namespaces) {
            result.put(namespace.getPrefix(), namespace);
        }
        return result;
    }

    public boolean updateFlowFromSource() {
        if (this.getDocument() == null) {
            return true;
        }
        EditingScope editingScope = ProjectStructureContributionManager.getDefault().getScope((IResource)this.getInputFile());
        MuleConfiguration newMuleConfig = (MuleConfiguration)StudioDesignContextRunner.runSilentWithContext(() -> this.generateMuleConfiguration(this.getDocument().get(), this.getMuleProject()), (IMuleProject)this.muleProject, (EditingScope)editingScope, null);
        if (newMuleConfig != null) {
            GlobalElementEditor globalEditor;
            MuleConfiguration muleConfiguration;
            if (this.getFlowEditor() != null && (muleConfiguration = this.getFlowEditor().getMuleConfiguration()) != null) {
                newMuleConfig.setName(muleConfiguration.getName());
            }
            if ((globalEditor = this.getGlobalEditor()) != null) {
                globalEditor.reloadContents();
            }
            this.getFlowEditor().reloadContents(newMuleConfig);
            CollapsibleContainerController.getDefault().updateContainers(newMuleConfig.getName(), this.getFlowEditor());
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new UpdateFlowFromSourceEvent());
            return true;
        }
        return false;
    }

    public IDocument getDocument() {
        if (this.getSource() == null || this.getSource().getTextViewer() == null) {
            return null;
        }
        return this.getSource().getTextViewer().getDocument();
    }

    public void reopen() {
        this.close(true);
        try {
            this.openEditor();
        }
        catch (PartInitException e) {
            MuleCorePlugin.logError((String)("Failed to open mule config file " + this.getFileName()), (Throwable)e);
        }
    }

    public static OpenEditors selectOpenEditorsOfProject(String projectName) {
        ArrayList<MultiPageMessageFlowEditor> editorsInFlowMode = new ArrayList<MultiPageMessageFlowEditor>();
        ArrayList<MultiPageMessageFlowEditor> editorsInXmlMode = new ArrayList<MultiPageMessageFlowEditor>();
        if (!openingAllEditors) {
            try {
                openingAllEditors = true;
                String prefix = "/" + projectName + "/";
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage[] pages;
                    IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                    int n = pages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference[] refs;
                        IWorkbenchPage page = iWorkbenchPageArray[n2];
                        IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
                        int n3 = refs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MultiPageMessageFlowEditor openEditor;
                            String openEditorFilePath;
                            IEditorReference ref = iEditorReferenceArray[n4];
                            IEditorPart editor = ref.getEditor(false);
                            if (editor instanceof MultiPageMessageFlowEditor && (openEditorFilePath = (openEditor = (MultiPageMessageFlowEditor)editor).getFilePath()).startsWith(prefix)) {
                                if (openEditor.getCurentPageIndex() == openEditor.getSourceEditorIndex()) {
                                    editorsInXmlMode.add(openEditor);
                                } else {
                                    editorsInFlowMode.add(openEditor);
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            finally {
                openingAllEditors = false;
            }
        }
        return new OpenEditors(editorsInFlowMode, editorsInXmlMode);
    }

    private MuleConfiguration generateMuleConfiguration(String muleConfigXML, IMuleProject muleProject) {
        if (StringUtils.isBlank((CharSequence)muleConfigXML)) {
            return null;
        }
        IDOMModel model = null;
        try {
            model = this.getInputFile() instanceof InMemoryFile ? MuleConfigurationUtils.getDomModel((String)muleConfigXML, (String)this.getFileName(), (Charset)IMuleResources.DEFAULT_CHARSET) : (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(this.getInputFile());
            IDOMDocument document = model.getDocument();
            IServerDefinition serverDefinition = muleProject.getServerDefinition();
            IDocumentWrapper documentWrapper = DOMFactory.from((Document)document, (ISchemaLocationLookup)muleProject.getSchemaLocationLookup());
            MuleConfiguration muleConfiguration = new MuleToFlowTransformer().transform(documentWrapper, serverDefinition.getVersionWithEESign());
            return muleConfiguration;
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Error", (String)"Unable to transform XML", (IStatus)MuleCorePlugin.createStatus((int)4, (String)e.getMessage(), (Throwable)e));
            return null;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void close(boolean save) {
        Display display = Display.getDefault();
        if (!this.isDisposed()) {
            display.syncExec(() -> {
                boolean bl2 = this.getSite().getPage().closeEditor((IEditorPart)this, save);
            });
        }
        this.unregisterListeners();
    }

    public void cleanEditorMarker() {
        IFile inputFile = this.getInputFile();
        if (this.getInputFile() != null && !this.readOnly) {
            try {
                if (inputFile.isAccessible()) {
                    inputFile.setPersistentProperty(IDE.EDITOR_KEY, null);
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logWarning((String)("There was a problem clearing the EDITOR_KEY persistent property for file " + String.valueOf(inputFile)), (Throwable)e);
            }
        }
    }

    protected void unregisterListeners() {
        this.eventBusHelper.unregister();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.source != null && this.propertyChangedListener != null) {
            this.source.removePropertyListener(this.propertyChangedListener);
        }
    }

    public GlobalElementEditor getGlobalEditor() {
        return this.getGlobalsEditor();
    }

    public void openFlowEditorPage() {
        if (this.getActivePage() != this.getFlowEditorIndex()) {
            this.setActivePage(this.getFlowEditorIndex());
        }
    }

    public void openGlobalElementsPage() {
        if (this.getActivePage() != this.getGlobalsEditorIndex()) {
            this.setActivePage(this.getGlobalsEditorIndex());
        }
    }

    public void openSourceEditorPage() {
        if (this.getActivePage() != this.getSourceEditorIndex()) {
            this.setActivePage(this.getSourceEditorIndex());
        }
    }

    public void openUnknownNode(String ns) {
        int position;
        this.setActivePage(this.sourceEditorIndex);
        String string = this.getDocument().get();
        ns = ns.replaceAll("(\\p{Alnum})+:(\\p{Alnum}|/)+=\".*\"", "");
        String trimNs = this.trim(ns);
        String trimSource = this.trim(string);
        int indexOf = trimSource.indexOf(trimNs);
        if (indexOf != -1 && (position = this.untrim(indexOf, string)) != -1) {
            this.getSource().getTextViewer().setSelectedRange(position, 0);
        }
    }

    private int untrim(int indexOf, String ns) {
        StringBuilder lm = new StringBuilder();
        int a = 0;
        while (a < ns.length()) {
            char charAt = ns.charAt(a);
            if (!Character.isWhitespace(charAt) && charAt != '<' && charAt != '>') {
                lm.append(charAt);
            }
            if (lm.length() == indexOf) {
                return a;
            }
            ++a;
        }
        return -1;
    }

    public String trim(String ns) {
        StringBuilder lm = new StringBuilder();
        int a = 0;
        while (a < ns.length()) {
            char charAt = ns.charAt(a);
            if (!Character.isWhitespace(charAt) && charAt != '<' && charAt != '>') {
                lm.append(charAt);
            }
            ++a;
        }
        String nm = lm.toString();
        return nm;
    }

    private void validate() {
        try {
            String xmlContent = this.generateXmlConfiguration();
            this.validateXmlContent(xmlContent);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.messageflow", "An error occurred while creating XML configuration during validation of the editor " + this.getInputFile().getName(), (Throwable)e));
        }
    }

    private void validateXmlContent(String xmlContent) {
        requestExecutor.submit((BackgroundRequest)new ValidateFromEditorRequest(this.getMuleProject(), this, xmlContent));
    }

    public IMuleError[] doValidate(String xmlContent) throws CoreException {
        IFile xmlConfigFile;
        MessageFlowEditor flowEditor = this.getFlowEditor();
        if (flowEditor != null && !((xmlConfigFile = flowEditor.getInputXmlConfigFile()) instanceof InMemoryFile)) {
            return TransformerUtils.getMuleConfigurationErrorsFromSource((String)xmlContent, (MuleConfiguration)flowEditor.getMuleConfiguration(), (IProject)xmlConfigFile.getProject(), (IFile)xmlConfigFile);
        }
        return MULE_ERRORS_EMPTY_ARRAY;
    }

    public IMuleError[] doValidate() throws CoreException {
        String xmlContent = this.generateXmlConfiguration();
        IFile xmlConfigFile = this.getFlowEditor().getInputXmlConfigFile();
        return TransformerUtils.getMuleConfigurationErrorsFromSource((String)xmlContent, (MuleConfiguration)this.getFlowEditor().getMuleConfiguration(), (IProject)xmlConfigFile.getProject(), (IFile)xmlConfigFile);
    }

    protected String generateXmlConfiguration() throws CoreException {
        return this.generateXmlConfiguration(this.getDocument());
    }

    protected String generateXmlConfiguration(IDocument document) throws CoreException {
        return document.get();
    }

    public String getRuntimeVersion() {
        return this.getMuleProject().getServerDefinition().getVersionWithEESign();
    }

    public MuleConfigurationDecorator getMuleConfigurationDecorator() {
        return this.getFlowEditor().getMuleConfigurationDecorator();
    }

    public String getFilePath() {
        IFile thisFile = this.getFlowEditor().getInputXmlConfigFile();
        return thisFile.getFullPath().toString();
    }

    public String getFileName() {
        IFile thisFile = this.getFlowEditor().getInputXmlConfigFile();
        return thisFile.getName();
    }

    public static String getCurrentFileName() {
        MultiPageMessageFlowEditor editor = MultiPageMessageFlowEditor.getActive();
        return editor != null ? editor.getFilePath() : null;
    }

    public static MultiPageMessageFlowEditor getActive() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return activeEditor instanceof MultiPageMessageFlowEditor ? (MultiPageMessageFlowEditor)activeEditor : null;
    }

    public HashMap<String, String> getRenamedNamespaces() {
        String docText = this.getDocument().get();
        String muleElementText = MultiPageMessageFlowEditor.extractMuleElementText(docText);
        try {
            org.dom4j.Document doc = SAXUtils.parseXML((String)muleElementText);
            return this.renamedNamespaces(doc.getRootElement());
        }
        catch (DocumentException documentException) {
            return new HashMap<String, String>();
        }
    }

    private HashMap<String, String> renamedNamespaces(Element root) {
        ArrayList additionalNamespaces = new ArrayList(root.additionalNamespaces());
        ArrayList<Namespace> exclude = new ArrayList<Namespace>();
        for (Namespace namespace : additionalNamespaces) {
            if (!namespace.equals((Object)this.getNamespaceByPrefix().get(namespace.getPrefix()))) continue;
            exclude.add(namespace);
        }
        additionalNamespaces.removeAll(exclude);
        HashMap<String, Namespace> namespaceByUri = new HashMap<String, Namespace>();
        for (Map.Entry<String, Namespace> entry : this.getNamespaceByPrefix().entrySet()) {
            namespaceByUri.put(entry.getValue().getURI(), entry.getValue());
        }
        HashMap<String, String> renamed = new HashMap<String, String>();
        for (Namespace namespace : additionalNamespaces) {
            if (!namespaceByUri.containsKey(namespace.getURI())) continue;
            renamed.put(((Namespace)namespaceByUri.get(namespace.getURI())).getPrefix(), namespace.getPrefix());
        }
        return renamed;
    }

    private static String extractMuleElementText(String docText) {
        String flatText = docText.replaceAll("[\n\r\u0085\u2028\u2029]", " ");
        Matcher m = Pattern.compile(".*?(<\\?xml.*?\\?>.*?)*?(<mule\\s.*?>).*").matcher(flatText);
        if (m.matches()) {
            String opening = m.group(2);
            if (opening.endsWith("/>")) {
                return opening;
            }
            return opening + "</mule>";
        }
        return "<mule />";
    }

    public void setFlowEditor(MessageFlowEditor flowEditor) {
        this.flowEditor = flowEditor;
    }

    public void reloadUI() {
        this.updateFlowFromSource();
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(PALETTE_VIEW_ID) != null) {
            this.openView(PALETTE_VIEW_ID);
        }
    }

    private void openView(String viewID) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID);
        }
        catch (PartInitException e) {
            MuleCorePlugin.logError((String)"Could not initialize Palette view", (Throwable)e);
        }
    }

    public StructuredTextEditor getSource() {
        return this.source;
    }

    public void setSource(StructuredTextEditor source) {
        this.source = source;
        if (source != null && !this.readOnly) {
            source.removePropertyListener(this.propertyChangedListener);
            source.addPropertyListener(this.propertyChangedListener);
        }
    }

    public String getUnchangedText() {
        return this.unchangedText;
    }

    public void setUnchangedText(String unchangedText) {
        this.unchangedText = unchangedText;
    }

    public IServerDefinition getServerDefinition() {
        if (this.flowEditor != null) {
            return this.flowEditor.getServerDefinition();
        }
        return null;
    }

    public IMuleProject getMuleProject() {
        MessageFlowEditor currentFlowEditor = this.getFlowEditor();
        return currentFlowEditor == null ? null : currentFlowEditor.getMuleProject();
    }

    public IMuleProject getOwnMuleProject() {
        return this.muleProject;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(this.getPartName());
    }

    public GlobalElementEditor getGlobalsEditor() {
        return this.globalsEditor;
    }

    public void setGlobalsEditor(GlobalElementEditor globalsEditor) {
        this.globalsEditor = globalsEditor;
    }

    private GlobalElementEditor createGlobalElementEditor(boolean readOnly) {
        return new GlobalElementEditor(this, this.getFlowEditor(), readOnly){

            @Override
            protected void openUnknown(String ns) {
                MultiPageMessageFlowEditor.this.openUnknownNode(ns);
            }
        };
    }

    public Map<String, Namespace> getNamespaceByPrefix() {
        return this.namespaceByPrefix;
    }

    public void setNamespaceByPrefix(Map<String, Namespace> namespaceByPrefix) {
        this.namespaceByPrefix = namespaceByPrefix;
    }

    private IMuleError[] doValidation(String xmlContent) throws CoreException {
        IFile inputFile;
        IMuleError[] errors = MULE_ERRORS_EMPTY_ARRAY;
        if (!this.isDisposed() && (inputFile = this.getInputFile()).isAccessible()) {
            IMuleError[] validationErrors = this.doValidate(xmlContent);
            MessageFlowEditor flowEditor = this.getFlowEditor();
            IMuleProject muleProject = null;
            MuleConfiguration muleConfiguration = null;
            if (flowEditor != null) {
                muleProject = flowEditor.getMuleProject();
                muleConfiguration = flowEditor.getMuleConfiguration();
            }
            if (muleProject != null && muleConfiguration != null) {
                List<IMuleError> propagationErrors = PropagationErrorsCollector.newInstance(muleProject, muleConfiguration.getPathsCache(), inputFile).getPropagationErrors();
                List allErrors = ListView.of(propagationErrors, Arrays.asList(validationErrors));
                errors = allErrors.toArray(new IMuleError[allErrors.size()]);
            } else {
                errors = validationErrors;
            }
            MuleMarkers.updateMuleConfigurationMarkers((IMuleError[])errors, (IFile)inputFile);
        }
        return errors;
    }

    private void updateErrorMarkersOnUiThread(IMuleError[] errors) {
        Display display = Display.getCurrent();
        if (display != null) {
            this.updateErrorMarkers(errors);
        } else {
            StudioDesignContextRunner.asyncExecSilentWithMuleProjectInUI(() -> {
                this.updateErrorMarkers(errors);
                return null;
            }, (IMuleProject)this.getMuleProject());
        }
    }

    private void updateErrorMarkers(IMuleError[] errors) {
        if (!this.isDisposed() && this.getMuleProject().getProject().isAccessible()) {
            StructuredTextEditor xmlEditor;
            GlobalElementEditor globalEditor;
            MulePathsCache pathsCache = this.getMuleConfiguration().getPathsCache();
            MessageFlowEditor flowEditor = this.getFlowEditor();
            if (flowEditor != null) {
                flowEditor.updateEntityErrors(errors);
                this.updateMessageFlowEditorErrorDecoration(errors, pathsCache);
            }
            if ((globalEditor = this.getGlobalEditor()) != null) {
                globalEditor.updateEntityErrors(errors);
                this.updateGlobalEditorErrorDecoration(errors, pathsCache);
            }
            if ((xmlEditor = this.getSource()) != null) {
                MultiPageMessageFlowEditor.removeAnnotations(xmlEditor, errors);
            }
        }
    }

    private void updateMessageFlowEditorErrorDecoration(IMuleError[] muleErrors, MulePathsCache pathsCache) {
        if (!MuleProjectKind.DOMAIN.classifies(this.muleProject)) {
            this.updateEditorIcon(muleErrors, pathsCache, this.flowEditorIndex, x -> !(x instanceof GlobalElement));
        }
    }

    private void updateGlobalEditorErrorDecoration(IMuleError[] muleErrors, MulePathsCache pathsCache) {
        this.updateEditorIcon(muleErrors, pathsCache, this.globalsEditorIndex, x -> x instanceof GlobalElement);
    }

    private void updateEditorIcon(IMuleError[] muleErrors, MulePathsCache pathsCache, int editorIndex, Predicate<MessageFlowEntity> predicate) {
        if (this.anyMessageFlowEntityMatchesCriteria(muleErrors, pathsCache, predicate)) {
            this.setPageImage(editorIndex, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        } else {
            this.setPageImage(editorIndex, null);
        }
    }

    private boolean anyMessageFlowEntityMatchesCriteria(IMuleError[] muleErrors, MulePathsCache pathsCache, Predicate<MessageFlowEntity> predicate) {
        IMuleError[] iMuleErrorArray = muleErrors;
        int n = muleErrors.length;
        int n2 = 0;
        while (n2 < n) {
            IMuleError error = iMuleErrorArray[n2];
            if (error instanceof MessageFlowEntityError) {
                MessageFlowEntity entity;
                boolean mustShowMarkerInMessageFlowTab;
                MessageFlowEntityError messageFlowEntityError = (MessageFlowEntityError)error;
                MulePath path = MulePath.fromPath((String)messageFlowEntityError.getPath());
                boolean bl = mustShowMarkerInMessageFlowTab = messageFlowEntityError.getSeverity() == 2;
                if (pathsCache.getEntity(path, this.getMuleProject()) != null && mustShowMarkerInMessageFlowTab && predicate.test(entity = pathsCache.getEntity(path, this.getMuleProject()))) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private final class FileChangedDeltaVisitor
    implements IResourceDeltaVisitor {
        private final IFile fileInput;
        boolean changed;

        private FileChangedDeltaVisitor(IFile fileInput) {
            this.fileInput = fileInput;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.equals((Object)this.fileInput)) {
                if (delta.getKind() == 2) {
                    Display display = MultiPageMessageFlowEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(() -> MultiPageMessageFlowEditor.this.close(false));
                    return false;
                }
                if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                    this.changed = true;
                    return false;
                }
            }
            return true;
        }
    }

    private final class MultiPageMessageEditorXmlConfigurationProvider
    implements IXmlConfigurationProvider {
        private static final String CLOSING_BRACKET = "]";
        private static final String CLOSING_BRACKET_ESCAPE = "&#93;";
        private static final String DOUBLE_DASH = "--";
        private static final String DOUBLE_DASH_ESCAPE = "&#45;&#45;";
        private static final String OPEN_COMMENT = "<!-- [STUDIO";
        private static final String CLOSE_COMMENT = " [STUDIO] -->";
        private static final String OPEN_COMMENT_REGEX = "<!-- \\[STUDIO:\".+?\"\\]";
        private static final String OPEN_COMMENT_FORMAT = "<!-- [STUDIO:\"%s\"]";

        private MultiPageMessageEditorXmlConfigurationProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getXml() throws Exception {
            IDocument document;
            if (!MultiPageMessageFlowEditor.this.isDisposed() && (document = MultiPageMessageFlowEditor.this.getDocument()) != null) {
                String xmlConfiguration;
                if (!MultiPageMessageFlowEditor.this.editorPagesInitialized) {
                    Object object = MultiPageMessageFlowEditor.this.editorPagesInitLock;
                    synchronized (object) {
                        xmlConfiguration = MultiPageMessageFlowEditor.this.generateXmlConfiguration(document);
                    }
                } else {
                    xmlConfiguration = MultiPageMessageFlowEditor.this.generateXmlConfiguration(document);
                }
                return xmlConfiguration;
            }
            return MuleResourceUtils.readContentsUsingDefaultCharset((IStorage)MultiPageMessageFlowEditor.this.getInputFile());
        }

        public void goToXml(IElementLocation elementLocation) {
            StructuredTextViewer textViewer = MultiPageMessageFlowEditor.this.source.getTextViewer();
            StyledText textWidget = textViewer.getTextWidget();
            if (elementLocation instanceof IAbsoluteLocation) {
                IAbsoluteLocation absoluteLocation = (IAbsoluteLocation)elementLocation;
                textWidget.setCaretOffset(absoluteLocation.getStart());
            } else if (elementLocation instanceof ILineLocation) {
                ILineLocation lineLocation = (ILineLocation)elementLocation;
                int lineNumber = lineLocation.getLineNumber() - 1;
                int offsetAtLine = textWidget.getOffsetAtLine(lineNumber);
                String content = textWidget.getLine(lineNumber);
                int spaceCount = 0;
                char[] cArray = content.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!Character.isWhitespace(c)) break;
                    ++spaceCount;
                    ++n2;
                }
                int startOffsetLine = offsetAtLine - spaceCount;
                textWidget.setCaretOffset(startOffsetLine + lineLocation.getColumnNumber());
            }
            textWidget.showSelection();
            MultiPageMessageFlowEditor.this.setActivePage(MultiPageMessageFlowEditor.this.sourceEditorIndex);
        }

        public void toggleComment(IElementLocation location, String name) {
            try {
                StructuredTextViewer textViewer = MultiPageMessageFlowEditor.this.source.getTextViewer();
                IDocument document = textViewer.getDocument();
                int startOffset = 0;
                int endOffset = 0;
                if (location instanceof IAbsoluteLocation) {
                    IAbsoluteLocation absoluteLocation = (IAbsoluteLocation)location;
                    startOffset = absoluteLocation.getStart();
                    endOffset = absoluteLocation.getEnd();
                } else if (location instanceof ILineLocation) {
                    ILineLocation lineLocation = (ILineLocation)location;
                    int lineNumber = lineLocation.getLineNumber();
                    startOffset = this.getStartOffset(document, lineNumber);
                    endOffset = this.getEndOffset(document, lineNumber);
                }
                if (this.shouldComment(document, startOffset, endOffset)) {
                    this.comment(document, name, startOffset, endOffset);
                } else {
                    this.uncomment(document, name, startOffset, endOffset);
                }
            }
            catch (BadLocationException e) {
                MuleCorePlugin.logError((String)"Error while toggling comment", (Throwable)e);
            }
        }

        private boolean shouldComment(IDocument document, int startOffset, int endOffset) throws BadLocationException {
            return !document.get(startOffset, endOffset - startOffset).startsWith(OPEN_COMMENT);
        }

        private void comment(IDocument document, String name, int startOffset, int endOffset) throws BadLocationException {
            StringBuilder sb = new StringBuilder();
            this.appendOpenCommentTag(sb, name);
            this.appendBodyToComment(sb, document, startOffset, endOffset);
            sb.append(CLOSE_COMMENT);
            document.replace(startOffset, endOffset - startOffset, sb.toString());
        }

        private void appendOpenCommentTag(StringBuilder builder, String name) {
            builder.append(String.format(OPEN_COMMENT_FORMAT, name));
        }

        private void appendBodyToComment(StringBuilder builder, IDocument document, int startOffset, int endOffset) throws BadLocationException {
            String commentBody = document.get(startOffset, endOffset - startOffset).replaceAll(OPEN_COMMENT_REGEX, "").replace(CLOSE_COMMENT, "");
            commentBody = this.escapeComment(commentBody);
            builder.append(commentBody);
        }

        private String escapeComment(String comment) {
            return comment.replaceAll(DOUBLE_DASH, DOUBLE_DASH_ESCAPE).replaceAll(CLOSING_BRACKET, CLOSING_BRACKET_ESCAPE);
        }

        private void uncomment(IDocument document, String name, int startOffset, int endOffset) throws BadLocationException {
            String comment = this.unescapeComment(document, name, startOffset, endOffset);
            document.replace(startOffset, endOffset - startOffset, comment);
        }

        private String unescapeComment(IDocument document, String name, int startOffset, int endOffset) throws BadLocationException {
            int openCommentSize = OPEN_COMMENT.length() + name.length() + 4;
            int offsetAfterOpenTag = startOffset + openCommentSize;
            int offsetToCloseTag = endOffset - CLOSE_COMMENT.length();
            int lengthUntilCloseTag = offsetToCloseTag - offsetAfterOpenTag;
            return document.get(offsetAfterOpenTag, lengthUntilCloseTag).replace(DOUBLE_DASH_ESCAPE, DOUBLE_DASH).replace(CLOSING_BRACKET_ESCAPE, CLOSING_BRACKET);
        }

        private int getEndOffset(IDocument document, int line) throws BadLocationException {
            int lineDelimiterLength = document.getLineDelimiter(line) == null ? 0 : document.getLineDelimiter(line).length();
            return document.getLineOffset(line) + document.getLineLength(line) - lineDelimiterLength;
        }

        private int getStartOffset(IDocument document, int line) throws BadLocationException {
            return document.getLineOffset(line);
        }
    }

    private static final class MultiPageMessageFlowEditorStite
    extends MultiPageEditorSite {
        private final String id;

        public MultiPageMessageFlowEditorStite(MultiPageEditorPart multiPageEditor, IEditorPart editor, String id) {
            super(multiPageEditor, editor);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class OpenEditors {
        public final List<MultiPageMessageFlowEditor> editorsInFlowMode;
        public final List<MultiPageMessageFlowEditor> editorsInXmlMode;

        private OpenEditors(List<MultiPageMessageFlowEditor> editorsInFlowMode, List<MultiPageMessageFlowEditor> editorsInXmlMode) {
            this.editorsInFlowMode = editorsInFlowMode;
            this.editorsInXmlMode = editorsInXmlMode;
        }
    }

    private final class ProjectMoveDeltaVisitor
    implements IResourceDeltaVisitor {
        boolean move;

        private ProjectMoveDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            ResourceDeltaDecorator decorator;
            if (delta != null && delta.getFlags() == 524288 && delta instanceof ResourceDelta && (decorator = new ResourceDeltaDecorator((ResourceDelta)delta)).changedLocation()) {
                this.move = true;
                Display.getDefault().syncExec(() -> {
                    IProject project = delta.getResource().getProject();
                    OpenEditors openEditors = MultiPageMessageFlowEditor.selectOpenEditorsOfProject(project.getName());
                    for (MultiPageMessageFlowEditor ed : openEditors.editorsInFlowMode) {
                        ed.close(false);
                    }
                    for (MultiPageMessageFlowEditor ed : openEditors.editorsInXmlMode) {
                        ed.close(false);
                    }
                });
                return false;
            }
            return true;
        }
    }

    private static class SelectionProvider
    extends MultiPageSelectionProvider {
        private ISelection globalSelection;

        public SelectionProvider(FormEditor formEditor) {
            super((MultiPageEditorPart)formEditor);
        }

        public ISelection getSelection() {
            ISelectionProvider selectionProvider;
            IEditorPart activeEditor = ((FormEditor)this.getMultiPageEditor()).getActiveEditor();
            if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null && selectionProvider != this) {
                return selectionProvider.getSelection();
            }
            if (this.globalSelection != null) {
                return this.globalSelection;
            }
            return StructuredSelection.EMPTY;
        }

        public void setSelection(ISelection selection) {
            IEditorPart activeEditor = ((FormEditor)this.getMultiPageEditor()).getActiveEditor();
            if (activeEditor != null) {
                ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.setSelection(selection);
                }
            } else {
                this.globalSelection = selection;
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.globalSelection));
            }
        }
    }

    private static class ValidateFromEditorRequest
    implements ExecutableRequest {
        private IPath filePath;
        private String description;
        private IMuleProject muleProject;
        private EditingScope editingScope;
        private MultiPageMessageFlowEditor editor;
        private String xmlContent;

        public ValidateFromEditorRequest(IMuleProject muleProject, MultiPageMessageFlowEditor editor, String xmlContent) {
            IFile editorFile = editor.getInputFile();
            this.description = "Validating " + editorFile.getName();
            this.muleProject = muleProject;
            this.editingScope = ProjectStructureContributionManager.getDefault().getScope((IResource)editorFile);
            this.editor = editor;
            this.filePath = editorFile.getFullPath();
            this.xmlContent = xmlContent;
        }

        public IPath getFilePath() {
            return this.filePath;
        }

        public ExecutableRequest.Action<? extends ExecutableRequest> getAction() {
            return (monitor, request) -> this.doItInContext(monitor);
        }

        private void doItInContext(IProgressMonitor monitor) {
            StudioDesignContextRunner.runSilentWithContext(() -> {
                this.doIt(monitor);
                return null;
            }, (IMuleProject)this.muleProject, (EditingScope)this.editingScope);
        }

        private void doIt(IProgressMonitor monitor) throws CoreException {
            IMuleError[] errors = this.editor.doValidation(this.xmlContent);
            if (!this.editor.isDisposed()) {
                this.editor.updateErrorMarkersOnUiThread(errors);
            }
        }

        public String getDescription() {
            return this.description;
        }
    }
}

