/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mule.tooling.messageflow.editor.CollapseAllContainersAction;
import org.mule.tooling.messageflow.editor.ExpandAllContainersAction;
import org.mule.tooling.messageflow.editor.GlobalElementEditor;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;

public class MultiActionBarContributor
extends MultiPageEditorActionBarContributor {
    private ActionRegistry registry = new ActionRegistry();
    private List<RetargetAction> retargetActions = new ArrayList<RetargetAction>();

    public void init(IActionBars bars) {
        this.buildActions();
        super.init(bars);
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addRetargetAction(RetargetAction action) {
        this.addAction((IAction)action);
        this.retargetActions.add(action);
        this.getPage().addPartListener((IPartListener)action);
    }

    protected IAction getAction(String id) {
        return this.getActionRegistry().getAction((Object)id);
    }

    protected ActionRegistry getActionRegistry() {
        return this.registry;
    }

    protected void buildActions() {
        IWorkbenchWindow workbenchWindow = this.getPage().getWorkbenchWindow();
        this.addRetargetAction((RetargetAction)ActionFactory.UNDO.create(workbenchWindow));
        this.addRetargetAction((RetargetAction)ActionFactory.REDO.create(workbenchWindow));
        this.addRetargetAction((RetargetAction)ActionFactory.COPY.create(workbenchWindow));
        this.addRetargetAction((RetargetAction)ActionFactory.PASTE.create(workbenchWindow));
        this.addRetargetAction((RetargetAction)ActionFactory.DELETE.create(workbenchWindow));
        this.addRetargetAction((RetargetAction)ActionFactory.SELECT_ALL.create(workbenchWindow));
        this.addAction((IAction)new ExpandAllContainersAction());
        this.addAction((IAction)new CollapseAllContainersAction());
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getAction(ActionFactory.UNDO.getId()));
        toolBarManager.add(this.getAction(ActionFactory.REDO.getId()));
        toolBarManager.add(this.getAction(ActionFactory.DELETE.getId()));
        toolBarManager.add(this.getAction("org.mule.tooling.messageflow.editor.expandAll"));
        toolBarManager.add(this.getAction("org.mule.tooling.messageflow.editor.collapseAll"));
    }

    public void setActivePage(IEditorPart activeEditor) {
        IActionBars bars = this.getActionBars();
        if (activeEditor instanceof MessageFlowEditor) {
            ActionRegistry registry = ((MessageFlowEditor)activeEditor).getActionRegistry();
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), registry.getAction((Object)ActionFactory.UNDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), registry.getAction((Object)ActionFactory.REDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), registry.getAction((Object)ActionFactory.DELETE.getId()));
        } else if (activeEditor instanceof GlobalElementEditor) {
            GlobalElementEditor editor = activeEditor instanceof GlobalElementEditor ? (GlobalElementEditor)activeEditor : null;
            ActionRegistry registry = editor.getActionRegistry();
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), registry.getAction((Object)ActionFactory.UNDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), registry.getAction((Object)ActionFactory.REDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), registry.getAction((Object)ActionFactory.DELETE.getId()));
        } else {
            ITextEditor editor = activeEditor instanceof ITextEditor ? (ITextEditor)activeEditor : null;
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ActionFactory.UNDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ActionFactory.REDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ActionFactory.DELETE.getId()));
        }
        bars.updateActionBars();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.retargetActions.size()) {
            RetargetAction action = this.retargetActions.get(i);
            this.getPage().removePartListener((IPartListener)action);
            action.dispose();
            ++i;
        }
        this.registry.dispose();
        this.retargetActions = null;
        this.registry = null;
    }
}

