/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;

public class MuleXmlEditorManager {
    private Class<? extends StructuredTextEditor> editorClass;

    public static MuleXmlEditorManager get() {
        return Singleton.instance;
    }

    private MuleXmlEditorManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.xmlEditor");
            if (configurationElements.length != 0) {
                IConfigurationElement configurationElement = iConfigurationElementArray[0];
                this.editorClass = Class.forName(configurationElement.getAttribute("class"));
            }
        }
        catch (InvalidRegistryObjectException e) {
            this.logError("Failed to load org.mule.tooling.messageflow.xmlEditor extension point", e);
        }
        catch (ClassNotFoundException e) {
            this.logError("Failed to load org.mule.tooling.messageflow.xmlEditor extension point", e);
        }
    }

    private void logError(String message, Throwable e) {
        Activator.getDefault().getLog().log(Activator.createStatus(4, message, e));
    }

    public StructuredTextEditor getXmlEditor(MultiPageMessageFlowEditor messageflowEditor) {
        if (this.editorClass != null) {
            try {
                Constructor<? extends StructuredTextEditor> constructor = this.editorClass.getDeclaredConstructor(MultiPageMessageFlowEditor.class);
                return constructor.newInstance(new Object[]{messageflowEditor});
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logError("Failed to instantiate XML editor", e);
            }
        }
        return new StructuredTextEditor();
    }

    private static class Singleton {
        private static final MuleXmlEditorManager instance = new MuleXmlEditorManager();

        private Singleton() {
        }
    }
}

