/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.IMenuManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.editor.IContextMenuProvider;
import org.mule.tooling.messageflow.editor.IMessageFlowNodeContextMenuProvider;
import org.mule.tooling.model.messageflow.MessageFlowNode;

public class MessageFlowNodeContextMenuProviderManager {
    private static MessageFlowNodeContextMenuProviderManager defaultInstance = new MessageFlowNodeContextMenuProviderManager();
    private List<IContextMenuProvider> genericProviders;
    private List<IMessageFlowNodeContextMenuProvider> nodeProviders;

    public static MessageFlowNodeContextMenuProviderManager getDefault() {
        return defaultInstance;
    }

    private MessageFlowNodeContextMenuProviderManager() {
        this.init();
    }

    public void init() {
        this.nodeProviders = CoreUtils.getExtensionPointObjects((String)"org.mule.tooling.messageflow.nodecontextmenu", IMessageFlowNodeContextMenuProvider.class);
        this.genericProviders = CoreUtils.getExtensionPointObjects((String)"org.mule.tooling.messageflow.nodecontextmenu", IContextMenuProvider.class);
    }

    public void addActionsForNode(IMenuManager menu, MessageFlowNode selected) {
        if (this.nodeProviders == null) {
            return;
        }
        for (IMessageFlowNodeContextMenuProvider provider : this.nodeProviders) {
            provider.addActionsForNode(menu, selected);
        }
    }

    public void addActions(IMuleProject project, IMenuManager manager, MessageFlowNode selected) {
        if (this.genericProviders == null) {
            return;
        }
        Optional<MessageFlowNode> maybeSelectedElement = Optional.ofNullable(selected);
        for (IContextMenuProvider provider : this.genericProviders) {
            provider.addActions(manager, project, maybeSelectedElement);
        }
    }
}

