/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;

public class MessageFlowNavigationLocation
extends NavigationLocation {
    private String locationText;
    private MulePath partPath;

    protected MessageFlowNavigationLocation(IEditorPart editorPart, EntityEditPart<?> editPart) {
        super(editorPart);
        this.locationText = this.computeLocationText(editPart);
        MessageFlowEntityRef findMulePathForEntityInOpenEditors = MessageFlowUtils.findMulePathForEntityInOpenEditors(editPart.getEntity());
        if (findMulePathForEntityInOpenEditors != null) {
            this.partPath = findMulePathForEntityInOpenEditors.getMulePath();
        }
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void restoreLocation() {
        MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)this.getEditorPart();
        MessageFlowEditor flowEditor = editor.getFlowEditor();
        if (editor.getActiveEditor() != flowEditor) {
            editor.setActiveEditor((IEditorPart)flowEditor);
        }
        this.restoreEntitySelection(flowEditor);
    }

    protected void restoreEntitySelection(MessageFlowEditor flowEditor) {
        MuleConfiguration configuration;
        MessageFlowEntity entity;
        EntityEditPart<?> editPart = null;
        if (this.partPath != null && (entity = (configuration = (MuleConfiguration)flowEditor.getModelRoot().getEntity()).getEntityFor(this.partPath, flowEditor.getMuleProject())) != null) {
            editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)flowEditor.getViewer(), (IMessageFlowEntity)entity);
        }
        if (editPart != null) {
            while (!editPart.isSelectable() && editPart.getParent() instanceof EntityEditPart) {
                editPart = (EntityEditPart<?>)editPart.getParent();
            }
            if (editPart != null && editPart.isSelectable()) {
                flowEditor.select(editPart);
                flowEditor.asyncScroll(editPart);
            } else {
                flowEditor.getViewer().deselectAll();
            }
        }
    }

    public String getText() {
        return this.locationText;
    }

    private String computeLocationText(EntityEditPart<? extends MessageFlowEntity> editPart) {
        Object text = "Unknown Step";
        if (editPart != null) {
            text = editPart.getEntity().toString();
            if (!(editPart instanceof ContainerEditPart)) {
                text = (String)text + this.lookForParentName((EditPart)editPart);
            }
        }
        return text;
    }

    private String lookForParentName(EditPart editPartAux) {
        String textToAdd = " in ";
        while (editPartAux.getParent() != null && !(editPartAux instanceof ContainerEditPart)) {
            editPartAux = editPartAux.getParent();
        }
        if (editPartAux.getParent() == null) {
            return "";
        }
        return textToAdd + ((Container)((ContainerEditPart)editPartAux).getEntity()).toString();
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation instanceof MessageFlowNavigationLocation) {
            MulePath currentLocationPartPath = ((MessageFlowNavigationLocation)currentLocation).partPath;
            boolean samePart = currentLocationPartPath != null && currentLocationPartPath.equals((Object)this.partPath);
            return samePart;
        }
        return false;
    }

    public void update() {
    }
}

