/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.builder.MuleMarkers;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.cache.IXmlConfigurationProvider;
import org.mule.tooling.core.cache.MuleConfigurationUtils;
import org.mule.tooling.core.dom.location.IElementLocation;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IThemeChangedListener;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MessageFlowEntityError;
import org.mule.tooling.core.generator.errors.messageflow.MuleErrorFactory;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleConfigurationEntityLocator;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.messageflow.ScrollingGraphicalViewerWithoutGrid;
import org.mule.tooling.messageflow.StudioDesignContextUpdaterListener;
import org.mule.tooling.messageflow.action.CopyAction;
import org.mule.tooling.messageflow.action.GoToXMLFromSelectedAction;
import org.mule.tooling.messageflow.action.PasteAction;
import org.mule.tooling.messageflow.action.PasteActionToTheEnd;
import org.mule.tooling.messageflow.editor.EmptyEditorSite;
import org.mule.tooling.messageflow.editor.IMessageFlowEditorListener;
import org.mule.tooling.messageflow.editor.IMessageFlowEditorSavedListener;
import org.mule.tooling.messageflow.editor.Interruptible;
import org.mule.tooling.messageflow.editor.MessageFlowActionManager;
import org.mule.tooling.messageflow.editor.MessageFlowContextMenuProvider;
import org.mule.tooling.messageflow.editor.MessageFlowDropTargetListener;
import org.mule.tooling.messageflow.editor.MessageFlowNavigationLocation;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editor.TransactionalCommandEventListener;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MessageFlowEditPartFactory;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.editpart.ScalableRootWithoutGridEditPart;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.EditPartSelectedEvent;
import org.mule.tooling.messageflow.events.INewElementCreatedOnCanvasListener;
import org.mule.tooling.messageflow.events.IRefreshRequestedEventListener;
import org.mule.tooling.messageflow.figure.FigureImageRegistry;
import org.mule.tooling.messageflow.outline.MessageFlowOutlinePage;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.MuleConfigurationTraverser;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.path.MulePathsCache;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.utils.OsDetect;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MessageFlowEditor
extends EditorPart
implements CommandStackEventListener,
INavigationLocationProvider {
    private static final String PALETTE_VIEW_ID = "org.mule.tooling.ui.palette.PaletteView";
    public static final String ID = "org.mule.tooling.messageflow.messageFlowEditor";
    protected CustomDefaultEditDomain editDomain;
    protected ActionRegistry actionRegistry;
    private List<IAction> actions;
    private SelectionSynchronizer synchronizer;
    private MessageFlowActionManager actionManager;
    protected GraphicalViewer viewer;
    protected IMuleProject project;
    protected MuleConfigurationDecorator modelRoot;
    protected MuleConfiguration muleConfiguration;
    private List<IMessageFlowEditorListener> listeners = new ArrayList<IMessageFlowEditorListener>();
    private boolean forceDirty = false;
    private EventBusHelper eventBusHelper = new EventBusHelper();
    private IXmlConfigurationProvider xmlConfigurationProvider;
    private boolean corruptedConfig = true;
    private boolean disposed;
    private DefaultSelectionChangedListener defaultSelectionChangedListener;
    private IContextActivation activateContext;
    private MultiPageMessageFlowEditor multiPageMessageFlowEditor;
    private boolean fHandleActivation = true;
    private boolean fIsCheckEnabled = true;
    private ActivationListener fActivationListener;
    private IMessageFlowEditorSavedListener editorSavedListener;
    private final boolean readOnly;

    public MessageFlowEditor(MultiPageMessageFlowEditor multiPageMessageFlowEditor, IXmlConfigurationProvider xmlConfigurationProvider, boolean readOnly) {
        this.multiPageMessageFlowEditor = multiPageMessageFlowEditor;
        this.readOnly = readOnly;
        if (!readOnly) {
            this.editorSavedListener = new IMessageFlowEditorSavedListener(){

                @Override
                public void onBeforeSave() {
                }

                @Override
                public void onAfterSave() {
                    MessageFlowEditor.this.enableHandleActivation(true);
                }
            };
            multiPageMessageFlowEditor.addSavedListener(this.editorSavedListener);
        }
        this.xmlConfigurationProvider = xmlConfigurationProvider;
    }

    public void goToXml(IElementLocation elementLocation) {
        this.xmlConfigurationProvider.goToXml(elementLocation);
    }

    public void toggleComment(IElementLocation location, String name) {
        this.xmlConfigurationProvider.toggleComment(location, this.escapeName(name));
        this.multiPageMessageFlowEditor.reloadUI();
    }

    private String escapeName(String displayName) {
        return displayName.replaceAll("\"", "&quot;").replaceAll("--", "&#45;&#45;");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (!this.wasInitializedSucessfully()) {
            throw new RuntimeException("Unable to initialize editor. No muleConfiguration available");
        }
        this.initEditDomain();
        this.initPalette();
        this.initActionRegistry();
        this.initGraphEditorListener();
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)((FileChangedEventListener)event -> {
            IFile file = event.getFile();
            if (file.exists() && file.equals((Object)this.getInputXmlConfigFile()) && event.markerTypeChanged("org.mule.tooling.core.messageFlowError")) {
                Display.getDefault().asyncExec(() -> {
                    if (!this.disposed) {
                        StudioDesignContextRunner.runSilentWithMuleProject(() -> {
                            this.updateEntityErrors();
                            return null;
                        }, (IMuleProject)this.getMuleProject());
                    }
                });
            }
            this.refreshEditorAfterDeletingApplicationsTypesFile(event);
        }));
        StudioDesignContextUpdaterListener.initialize();
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    private void initPalette() {
        IViewPart mulePalette = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(PALETTE_VIEW_ID);
        if (mulePalette != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.showView(PALETTE_VIEW_ID);
            }
            catch (PartInitException e) {
                MuleCorePlugin.logError((String)"Could not initialize Palette view", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private boolean wasInitializedSucessfully() {
        return this.muleConfiguration != null;
    }

    protected void initListeners() {
        this.defaultSelectionChangedListener = new DefaultSelectionChangedListener(this);
        this.addSelectionChangedListener(this.defaultSelectionChangedListener);
        EventBus eventBus = MuleCorePlugin.getEventBus();
        this.eventBusHelper.registerListener(eventBus, CoreEventTypes.ON_THEME_CHANGED, (IEventHandler)new IThemeChangedListener(){

            public void onThemeChanged() {
                MessageFlowEditor.this.editDomain.getCommandStack().flush();
                MessageFlowEditor.this.reload();
                FigureImageRegistry.flushDefault();
            }
        });
        this.eventBusHelper.registerListener(eventBus, EditPartEventTypes.REFRESH_REQUESTED, (IEventHandler)new IRefreshRequestedEventListener(){

            @Override
            public void onRefreshRequested(MessageFlowEditor editor) {
                if (editor == null || editor == MessageFlowEditor.this) {
                    MessageFlowEditor.this.reload();
                }
            }
        });
        this.eventBusHelper.registerUIListener(eventBus, EditPartEventTypes.ON_ELEMENT_CREATED_ON_CANVAS, (IEventHandler)new INewElementCreatedOnCanvasListener(){

            @Override
            public void onCreatedNewElementOnCanvas(IMuleProject project, IMessageFlowEntity entity) {
                MulePath mulePath = MessageFlowEditor.this.muleConfiguration.getPathFor(entity);
                if (mulePath != null) {
                    AnalyticsRecordsFactory.withCurrentMuleProject((String)Events.CANVAS_ADD_COMPONENT).withConnectorProperty((MessageFlowEntity)entity, project).track();
                    MessageFlowEditor.this.openPropertiesView();
                    MessageFlowEditor.this.asyncSelectAndScroll(mulePath);
                }
            }
        });
    }

    private void refreshEditorAfterDeletingApplicationsTypesFile(FileChangedEvent event) {
        if (event.isEventType(FileChangedEvent.ChangeType.DELETED) && MuleResourceUtils.isApplicationTypesFile((IResource)event.getFile())) {
            this.reload();
        }
    }

    private void openPropertiesView() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage.findView("org.mule.tooling.properties.views.MulePropertiesView") == null) {
            try {
                activePage.showView("org.mule.tooling.properties.views.MulePropertiesView", null, 2);
            }
            catch (PartInitException partInitException) {}
        }
    }

    public void dispose() {
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        this.disposed = true;
        this.eventBusHelper.unregister();
        this.actionRegistry.dispose();
        for (IAction action : this.actions) {
            this.actionRegistry.removeAction(action);
        }
        this.editDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this.actionManager);
        this.editDomain.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.actionManager);
        IMuleConfigurationsCache configurationsCache = this.getMuleProject().getConfigurationsCache();
        if (configurationsCache != null) {
            configurationsCache.removeNotSavedConfig(this.getInputXmlConfigFile());
        }
        this.editDomain.setEditorPart(null);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.defaultSelectionChangedListener);
        this.viewer.getContextMenu().dispose();
        this.listeners.clear();
        ScrollingGraphicalViewerWithoutGrid graphicalView = (ScrollingGraphicalViewerWithoutGrid)this.getGraphicalViewer();
        graphicalView.clearSelectionListeners();
        graphicalView.setSelection((ISelection)StructuredSelection.EMPTY);
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.viewer = null;
        this.listeners = null;
        this.editDomain = null;
        this.xmlConfigurationProvider = null;
        this.multiPageMessageFlowEditor.removeSavedListener(this.editorSavedListener);
        this.multiPageMessageFlowEditor = null;
        this.setSite((IWorkbenchPartSite)new EmptyEditorSite());
        super.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void addListener(IMessageFlowEditorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IMessageFlowEditorListener listener) {
        this.listeners.remove(listener);
    }

    protected void forceModified() {
        this.forceDirty = true;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.editDomain != null && this.editDomain.getCommandStack().isDirty() || this.forceDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile fileInput = this.getInputXmlConfigFile();
        IMuleProject project = MuleRuntime.create((IProject)fileInput.getProject());
        this.project = project == null ? MuleCorePlugin.getDesignContext().getMuleProject() : project;
        MuleConfiguration configuration = this.project.getConfigurationsCache().getConfiguration(fileInput);
        if (configuration == null) {
            configuration = MuleConfigurationUtils.createEmptyMuleConfiguration((IMuleProject)this.project, (IFile)fileInput);
            this.corruptedConfig = true;
        }
        this.setMuleConfiguration(configuration);
        this.updateModelRoot();
        this.fireInputChanged();
    }

    public void reloadContents(final MuleConfiguration config) {
        EditingScope editingScope = ProjectStructureContributionManager.getDefault().getScope((IResource)this.getInputXmlConfigFile());
        StudioDesignContextRunner.syncExecSilentWithContextInUI((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MessageFlowEditor.this.corruptedConfig = false;
                MessageFlowEditor.this.editDomain.getCommandStack().flush();
                config.setName(MessageFlowEditor.this.muleConfiguration.getName());
                config.setDescription(MessageFlowEditor.this.muleConfiguration.getDescription());
                MessageFlowEditor.this.setMuleConfiguration(config);
                MessageFlowEditor.this.updateModelRoot();
                MessageFlowEditor.this.viewer.setContents((Object)MessageFlowEditor.this.modelRoot);
                MessageFlowEditor.this.fireInputChanged();
                MessageFlowEditor.this.updateEntityErrors();
                return null;
            }
        }, (IMuleProject)this.getMuleProject(), (EditingScope)editingScope);
    }

    public void reload() {
        this.reload(this.modelRoot, this.viewer);
    }

    public void asyncScroll(EntityEditPart<?> editPart) {
        Display.getCurrent().asyncExec(() -> {
            if (!this.disposed) {
                this.scrollToLocation(editPart);
            }
        });
    }

    public void asyncSelectAndScroll(EntityEditPart<?> editPart) {
        Display.getCurrent().asyncExec(() -> {
            if (!this.disposed) {
                this.selectAndScroll(editPart);
            }
        });
    }

    public void asyncSelectAndScroll(MulePath mulePath) {
        Display.getCurrent().asyncExec(() -> {
            MessageFlowEntity currentEntity;
            EntityEditPart<?> editPart;
            if (!this.disposed && (editPart = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)this.viewer, (IMessageFlowEntity)(currentEntity = this.muleConfiguration.getEntityFor(mulePath)))) != null) {
                this.selectAndScroll(editPart);
            }
        });
    }

    public void scrollToLocationWithSize(Dimension editPartSize, Rectangle editPartLocation) {
        FigureCanvas figureCanvas = (FigureCanvas)this.getGraphicalViewer().getControl();
        Dimension viewPortSize = figureCanvas.getViewport().getSize();
        figureCanvas.scrollTo(editPartLocation.x - viewPortSize.width / 2 + editPartSize.width / 2, editPartLocation.y - viewPortSize.height / 2 + editPartSize.height / 2);
    }

    public MuleConfigurationDecorator getModelRoot() {
        return this.modelRoot;
    }

    protected void fireInputChanged() {
        for (IMessageFlowEditorListener listener : this.listeners) {
            listener.inputChanged();
        }
    }

    public void reload(final MuleConfigurationDecorator modelRoot, final GraphicalViewer viewer) {
        EditingScope editingScope = ProjectStructureContributionManager.getDefault().getScope((IResource)this.getInputXmlConfigFile());
        StudioDesignContextRunner.runSilentWithContextInUI((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Object editPart;
                List selectedEditParts = viewer.getSelectedEditParts();
                IMessageFlowEntity entity = null;
                if (!selectedEditParts.isEmpty() && (editPart = selectedEditParts.get(0)) instanceof EntityEditPart) {
                    entity = (IMessageFlowEntity)((EntityEditPart)editPart).getEntity();
                }
                viewer.setContents((Object)modelRoot);
                EntityEditPart<?> editPartToSelect = MessageFlowEditor.this.findEditPart(entity);
                if (editPartToSelect != null) {
                    viewer.setSelection((ISelection)new StructuredSelection(editPartToSelect));
                }
                return null;
            }
        }, (IMuleProject)this.getMuleProject(), (EditingScope)editingScope);
    }

    public IFile getInputXmlConfigFile() {
        return (IFile)this.getEditorInput().getAdapter(IFile.class);
    }

    public void updateEntityErrors() {
        IMarker[] markers;
        if (MuleProjectKind.DOMAIN.classifies(this.getMuleProject())) {
            return;
        }
        try {
            markers = MuleMarkers.findMuleConfigurationMarkers((IFile)this.getInputXmlConfigFile());
        }
        catch (CoreException e1) {
            MuleCorePlugin.logError((String)"Error while trying to get error markers", (Throwable)e1);
            return;
        }
        if (this.validMarkers(markers)) {
            MessageFlowEntityError[] muleErrors = MuleErrorFactory.createMessageFlowErrorFromMarkers((IMarker[])markers, (IFile)this.getInputXmlConfigFile());
            this.updateEntityErrors((IMuleError[])muleErrors);
        }
    }

    private boolean validMarkers(IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String path = marker.getAttribute("org.mule.tooling.entity.id", null);
            if (path == null) {
                return false;
            }
            MulePathsCache pathsCache = this.getMuleConfiguration().getPathsCache();
            if (pathsCache.isValid() && !pathsCache.containsPath(MulePath.fromPath((String)path))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void updateEntityErrors(IMuleError[] muleErrors) {
        if (this.isDisposed()) {
            return;
        }
        MuleConfiguration config = this.getMuleConfiguration();
        HashMap<String, List> errors = new HashMap<String, List>();
        IMuleError[] iMuleErrorArray = muleErrors;
        int n = muleErrors.length;
        int n2 = 0;
        while (n2 < n) {
            IMuleError error = iMuleErrorArray[n2];
            if (error instanceof MessageFlowEntityError) {
                MessageFlowEntityError messageFlowEntityError = (MessageFlowEntityError)error;
                String path = messageFlowEntityError.getPath();
                List existing = errors.computeIfAbsent(path, x -> new ArrayList());
                existing.add(messageFlowEntityError);
            }
            ++n2;
        }
        HashMap errorsMap = new HashMap();
        for (Map.Entry entry : errors.entrySet()) {
            MessageFlowEntity entity = config.getEntityFor(MulePath.fromPath((String)((String)entry.getKey())), this.getMuleProject());
            EntityEditPart<?> match = this.findEditPart((IMessageFlowEntity)entity);
            errorsMap.put(match, (List)entry.getValue());
        }
        MuleConfigurationEditPart configPart = this.getMuleConfigurationEditPart();
        if (configPart != null) {
            configPart.applyErrors(errorsMap);
        }
    }

    public MuleConfigurationEditPart getMuleConfigurationEditPart() {
        List children = this.viewer.getRootEditPart().getChildren();
        return children.isEmpty() ? null : children.get(0);
    }

    public EntityEditPart<?> findEditPart(IMessageFlowEntity entity) {
        return MessageFlowEditor.findEditPartInRegistry((EditPartViewer)this.viewer, entity);
    }

    public static EntityEditPart<?> findEditPartInRegistry(EditPartViewer viewer, IMessageFlowEntity entity) {
        if (entity == null) {
            return null;
        }
        Map registry = viewer.getEditPartRegistry();
        for (Object current : registry.keySet()) {
            EntityDecorator decorator;
            if (!(current instanceof EntityDecorator) || !(decorator = (EntityDecorator)current).getEntity().equals(entity)) continue;
            return (EntityEditPart)registry.get(current);
        }
        return null;
    }

    public boolean containsEditPart(EntityEditPart<?> editPart) {
        Map registry = this.viewer.getEditPartRegistry();
        return registry.containsKey(editPart.getEntityDecorator());
    }

    public String getPartName() {
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        return file.getProjectRelativePath().lastSegment();
    }

    public void createPartControl(Composite parent) {
        if (this.modelRoot != null) {
            this.createForms(parent);
            this.viewer.getControl().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent arg0) {
                    MessageFlowEditor.this.setFocusContext(false);
                }

                public void focusGained(FocusEvent arg0) {
                    MessageFlowEditor.this.setFocusContext(true);
                }
            });
        } else {
            Composite wrapper = new Composite(parent, 0);
            wrapper.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout(1, false);
            wrapper.setLayout((Layout)layout);
            Label label = new Label(wrapper, 0);
            label.setLayoutData((Object)new GridData(1808));
            label.setText("Unable to open message flow. Close editor, refresh project, and re-open message flow.");
        }
        this.initListeners();
    }

    public void setFocusContext(boolean focus) {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            if (focus) {
                if (!contextService.getActiveContextIds().contains("org.mule.tooling.keybindings.contexts.muleStudioFocus")) {
                    this.activateContext = contextService.activateContext("org.mule.tooling.keybindings.contexts.muleStudioFocus");
                }
            } else if (this.activateContext != null) {
                contextService.deactivateContext(this.activateContext);
            }
        }
    }

    protected void createForms(Composite parent) {
        Composite canvasComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(canvasComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)canvasComposite);
        this.createMessageFlowViewer(canvasComposite);
        this.updateEntityErrors();
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("org.mule.tooling.keybindings.contexts.muleStudio");
    }

    public void setFocus() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == CommandStack.class) {
            return this.editDomain.getCommandStack();
        }
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IContentOutlinePage.class) {
            return new MessageFlowOutlinePage(this.multiPageMessageFlowEditor, this);
        }
        if (adapter == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        this.enableHandleActivation(false);
        MessageFlowEditor.makePropertiesUnique(this.getMuleConfiguration());
        this.editDomain.getCommandStack().markSaveLocation();
        this.forceDirty = false;
        this.firePropertyChange(257);
    }

    protected static void makePropertiesUnique(MuleConfiguration conf) {
        MuleConfigurationTraverser visitor = new MuleConfigurationTraverser(conf){

            protected boolean visitMessageFlowNode(IMessageFlowNode node) {
                IReadOnlyPropertyCollection properties = node.getProperties();
                PropertyCollection newPropertyCollection = this.visitProperties(properties);
                node.setProperties(newPropertyCollection);
                return super.visitMessageFlowNode(node);
            }

            private PropertyCollection visitProperties(IReadOnlyPropertyCollection properties) {
                if (properties == null) {
                    return new PropertyCollection();
                }
                PropertyCollection newPropertyCollection = new PropertyCollection(properties.getElement());
                newPropertyCollection.setName(properties.getName());
                newPropertyCollection.setErased(properties.isErased());
                List generalProperties = properties.getProperties();
                this.makeUnique(newPropertyCollection, generalProperties);
                List collections = properties.getPropertyCollections();
                for (IReadOnlyPropertyCollection collection : collections) {
                    newPropertyCollection.addPropertyCollection(this.visitProperties(collection));
                }
                return newPropertyCollection;
            }

            private void makeUnique(PropertyCollection newPropertyCollection, List<IReadOnlyProperty> properties) {
                HashMap<String, IReadOnlyProperty> uniqueProperties = new HashMap<String, IReadOnlyProperty>();
                for (IReadOnlyProperty iReadOnlyProperty : properties) {
                    String name = iReadOnlyProperty.getName();
                    uniqueProperties.put(name, iReadOnlyProperty);
                }
                for (Map.Entry entry : uniqueProperties.entrySet()) {
                    newPropertyCollection.addProperty(PropertiesUtils.toWritableProperty((IReadOnlyProperty)((IReadOnlyProperty)entry.getValue())));
                }
            }
        };
        visitor.traverse();
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        try {
            String entityId;
            if (marker.isSubtypeOf("org.mule.tooling.core.messageFlowError") && (entityId = marker.getAttribute("org.mule.tooling.entity.id", null)) != null) {
                this.selectByEntityId(entityId);
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Error", (String)"Unable to open marker.", (IStatus)e.getStatus());
        }
    }

    public void selectByEntityId(String entityId) {
        IMessageFlowEntity entity = MuleConfigurationEntityLocator.locate((String)entityId, (MuleConfiguration)this.getMuleConfiguration());
        if (entity != null) {
            this.selectEntity(entity);
        }
    }

    public void selectEntity(IMessageFlowEntity entity) {
        EntityEditPart<?> match = this.findEditPart(entity);
        if (match != null) {
            this.asyncSelectAndScroll(match);
        }
    }

    public void selectFlowByName(String flowName) {
        List flows = this.getMuleConfiguration().getFlows();
        for (Container flow : flows) {
            EntityEditPart<?> match;
            if (flow.getName() == null || !flow.getName().equals(flowName) || (match = MessageFlowEditor.findEditPartInRegistry((EditPartViewer)this.viewer, (IMessageFlowEntity)flow)) == null) continue;
            this.select(match);
            this.viewer.reveal(match);
        }
    }

    protected void initEditDomain() {
        this.editDomain = new CustomDefaultEditDomain((IEditorPart)this);
        if (this.readOnly) {
            this.editDomain.setCommandStack(new NoOpCommandStack());
        }
        this.editDomain.getCommandStack().addCommandStackEventListener((CommandStackEventListener)new TransactionalCommandEventListener());
    }

    protected void initActionRegistry() {
        this.actionRegistry = new ActionRegistry();
        this.actions = new ArrayList<IAction>();
        this.actions.add((IAction)new UndoAction((IEditorPart)this));
        this.actions.add((IAction)new RedoAction((IEditorPart)this));
        this.actions.add((IAction)new DeleteAction((IWorkbenchPart)this));
        this.actions.add((IAction)new CopyAction((IWorkbenchPart)this));
        this.actions.add((IAction)new PasteAction((IWorkbenchPart)this));
        this.actions.add((IAction)new PasteActionToTheEnd((IWorkbenchPart)this));
        for (IAction action : this.actions) {
            this.actionRegistry.registerAction(action);
        }
    }

    protected void initGraphEditorListener() {
        this.actionManager = new MessageFlowActionManager(this.getActionRegistry());
        this.editDomain.getCommandStack().addCommandStackListener((CommandStackListener)this.actionManager);
        this.editDomain.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)this.actionManager);
    }

    protected void createMessageFlowViewer(Composite parent) {
        this.viewer = new ScrollingGraphicalViewerWithoutGrid();
        this.viewer.createControl(parent);
        ScalableRootWithoutGridEditPart root = new ScalableRootWithoutGridEditPart();
        ArrayList<String> zoomLevels = new ArrayList<String>();
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        IHandlerService service = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        service.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        service.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.getControl().setBackground(ColorConstants.white);
        this.viewer.setEditPartFactory((EditPartFactory)new MessageFlowEditPartFactory(this.project));
        this.viewer.addDropTargetListener((TransferDropTargetListener)new MessageFlowDropTargetListener((EditPartViewer)this.viewer));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.editDomain.addViewer((EditPartViewer)this.viewer);
        MessageFlowContextMenuProvider provider = new MessageFlowContextMenuProvider((IEditorPart)this, (EditPartViewer)this.viewer, this.actionRegistry);
        this.viewer.setContextMenu((MenuManager)provider);
        KeyHandler keyHandler = new KeyHandler();
        int commandOrCtrl = OsDetect.isMac() ? 0x400000 : 262144;
        int keyCode = 103;
        char g = OsDetect.isMac() ? (char)'g' : '\u0007';
        KeyStroke keyStroke = KeyStroke.getReleased((char)g, (int)keyCode, (int)commandOrCtrl);
        GoToXMLFromSelectedAction action = new GoToXMLFromSelectedAction();
        keyHandler.put(keyStroke, (IAction)action);
        this.viewer.setKeyHandler(keyHandler);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.viewer;
    }

    public ISelection getSelection() {
        return this.getGraphicalViewer().getSelection();
    }

    public Optional<EntityEditPart<?>> getSelectedEntity() {
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        if (!selection.isEmpty()) {
            return Optional.of((EntityEditPart)selection.getFirstElement());
        }
        return Optional.empty();
    }

    public Optional<StructuredSelection> getSelectedEntities() {
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        if (!selection.isEmpty()) {
            return Optional.of(selection);
        }
        return Optional.empty();
    }

    public Boolean hasMultipleSelectedEntities() {
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        if (!selection.isEmpty() && selection.size() > 1) {
            return true;
        }
        return false;
    }

    public void setSelection(ISelection selection) {
        if (this.getGraphicalViewer() != null) {
            this.getGraphicalViewer().setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getGraphicalViewer().addSelectionChangedListener(listener);
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public IMuleProject getMuleProject() {
        return this.project;
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    protected void setMuleConfiguration(MuleConfiguration config) {
        if (config == null) {
            throw new RuntimeException("Invalid MuleConfiguration. Cannot initialize the editor.");
        }
        this.muleConfiguration = config;
        if (!this.isCorrupted()) {
            this.getMuleProject().getConfigurationsCache().addNotSavedConfig(this.getInputXmlConfigFile(), config, this.xmlConfigurationProvider);
        }
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    protected Control getViewerControl() {
        return this.getGraphicalViewer().getControl();
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public MuleConfigurationDecorator getMuleConfigurationDecorator() {
        return this.modelRoot;
    }

    public IServerDefinition getServerDefinition() {
        return this.project.getServerDefinition();
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new MessageFlowNavigationLocation((IEditorPart)this, null);
    }

    public INavigationLocation createNavigationLocation() {
        if (this.getViewer() != null && this.getViewer().getSelectedEditParts() != null && this.getViewer().getSelectedEditParts().size() > 0) {
            return new MessageFlowNavigationLocation((IEditorPart)this, (EntityEditPart)this.getViewer().getSelectedEditParts().get(0));
        }
        return null;
    }

    public void stackChanged(CommandStackEvent event) {
        if (event.isPostChangeEvent()) {
            this.firePropertyChange(257);
        }
    }

    protected void updateModelRoot() {
        this.modelRoot = new MuleConfigurationDecorator(this.getMuleConfiguration());
    }

    public boolean isCorrupted() {
        return this.corruptedConfig;
    }

    public void selectAndScroll(EntityEditPart<?> editPart) {
        this.select(editPart);
        this.scrollToLocation(editPart);
    }

    public void select(EntityEditPart<?> editPart) {
        this.viewer.select(editPart);
    }

    public void scrollToLocation(EntityEditPart<?> editPart) {
        Dimension editPartSize = editPart.getFigure().getSize();
        Rectangle editPartLocation = editPart.getFigure().getBounds();
        this.scrollToLocationWithSize(editPartSize, editPartLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyCheckState(IEditorInput input) {
        boolean enabled = false;
        MessageFlowEditor messageFlowEditor = this;
        synchronized (messageFlowEditor) {
            enabled = this.fIsCheckEnabled;
        }
        if (enabled) {
            this.checkState(input);
        }
    }

    public void checkState(IEditorInput input) {
        IFile xmlFile = this.getInputXmlConfigFile();
        if (!xmlFile.isSynchronized(0)) {
            this.handleEditorInputChanged(xmlFile, input);
        }
    }

    private void handleEditorInputChanged(IFile xmlFile, IEditorInput input) {
        if (this.multiPageMessageFlowEditor.getSource() != null && this.multiPageMessageFlowEditor.getSource().getDocumentProvider() != null && !this.multiPageMessageFlowEditor.getSource().getDocumentProvider().isDeleted((Object)input)) {
            String title = "File Changed";
            String msg = "The file " + this.getInputXmlConfigFile().getName() + " has been changed on the file system. Do you want to replace the editor contents with these changes?";
            if (MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)title, (String)msg)) {
                try {
                    this.multiPageMessageFlowEditor.getSource().getDocumentProvider().resetDocument((Object)this.getEditorInput());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                this.enableChecking(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableChecking(boolean enable) {
        MessageFlowEditor messageFlowEditor = this;
        synchronized (messageFlowEditor) {
            this.fIsCheckEnabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableHandleActivation(boolean enable) {
        MessageFlowEditor messageFlowEditor = this;
        synchronized (messageFlowEditor) {
            this.fHandleActivation = enable;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        private void handleActivation() {
            if (!MessageFlowEditor.this.fHandleActivation) {
                return;
            }
            if (this.fActivePart == MessageFlowEditor.this || this.fActivePart != null && this.fActivePart.getAdapter(MessageFlowEditor.class) == MessageFlowEditor.this) {
                MessageFlowEditor.this.fHandleActivation = false;
                try {
                    MessageFlowEditor.this.safelyCheckState(MessageFlowEditor.this.getEditorInput());
                }
                finally {
                    MessageFlowEditor.this.fHandleActivation = true;
                }
            }
        }

        public void windowActivated(final IWorkbenchWindow window) {
            MessageFlowEditor.this.enableChecking(true);
            window.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((ActivationListener)ActivationListener.this).MessageFlowEditor.this.fHandleActivation && window == MessageFlowEditor.this.getEditorSite().getWorkbenchWindow() && ((ActivationListener)ActivationListener.this).MessageFlowEditor.this.multiPageMessageFlowEditor.getActiveEditor() == MessageFlowEditor.this) {
                        ActivationListener.this.handleActivation();
                    }
                }
            });
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            if (MessageFlowEditor.this.multiPageMessageFlowEditor.getActiveEditor() == MessageFlowEditor.this) {
                this.handleActivation();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
            MessageFlowEditor.this.enableChecking(true);
            MessageFlowEditor.this.fHandleActivation = true;
        }
    }

    private static final class CustomDefaultEditDomain
    extends DefaultEditDomain {
        public CustomDefaultEditDomain(IEditorPart editorPart) {
            super(editorPart);
        }

        public void setEditorPart(IEditorPart editorPart) {
            super.setEditorPart(editorPart);
        }

        public void mouseUp(MouseEvent mouseEvent, EditPartViewer viewer) {
            Tool tool = this.getActiveTool();
            if (tool != null) {
                Interruptible interruptible;
                if (tool instanceof Interruptible && !(interruptible = (Interruptible)tool).proceed()) {
                    return;
                }
                tool.mouseUp(mouseEvent, viewer);
            }
        }
    }

    private static final class DefaultSelectionChangedListener
    implements ISelectionChangedListener {
        private MessageFlowEditor messageFlowEditor;

        public DefaultSelectionChangedListener(MessageFlowEditor messageFlowEditor) {
            this.messageFlowEditor = messageFlowEditor;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedEditPart = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selectedEditPart instanceof EntityEditPart) {
                EntityEditPart firstElement = (EntityEditPart)selectedEditPart;
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new EditPartSelectedEvent(this.messageFlowEditor.getMuleConfiguration(), firstElement));
            }
        }
    }

    private static class NoOpCommandStack
    extends CommandStack {
        private NoOpCommandStack() {
        }

        public void execute(Command command) {
        }
    }
}

