/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.ResponseNodeUtils;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.action.EntityDirectEditNameAction;
import org.mule.tooling.messageflow.action.ExportImageToFileAction;
import org.mule.tooling.messageflow.action.ExtractEntityToFlowAction;
import org.mule.tooling.messageflow.action.GoToXMLAction;
import org.mule.tooling.messageflow.action.ReferencedByAction;
import org.mule.tooling.messageflow.action.ShowErrorHandlerAction;
import org.mule.tooling.messageflow.action.ShowFlowAction;
import org.mule.tooling.messageflow.action.WrapEntityInNewContainerAction;
import org.mule.tooling.messageflow.editor.CollapseAllContainersAction;
import org.mule.tooling.messageflow.editor.CollapseOtherContainersAction;
import org.mule.tooling.messageflow.editor.ExpandAllContainersAction;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MessageFlowNodeContextMenuProviderManager;
import org.mule.tooling.messageflow.editor.ToggleCommentAction;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.module.ExternaContributionModuleDelegate;
import org.mule.tooling.messageflow.module.IMessageFlowActionDelegate;
import org.mule.tooling.messageflow.module.MessageFlowNodeAction;
import org.mule.tooling.messageflow.util.GoToImplementationHandlerManager;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.utils.ObjectHolder;

public class MessageFlowContextMenuProvider
extends ContextMenuProvider {
    private IEditorPart editorPart;
    private ActionRegistry actionRegistry;

    public MessageFlowContextMenuProvider(IEditorPart editor, EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.setEditorPart(editor);
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager menu) {
        IMuleProject muleProject = ((MessageFlowEditor)this.getEditorPart()).getMuleProject();
        EntityEditPart<? extends MessageFlowEntity> selectedEditPart = this.getSelectedEditPart();
        MessageFlowNode selectedNode = this.getNode(selectedEditPart);
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        Object action = this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        if (selectedEditPart != null) {
            NestedContainer nestedContainer;
            action = new GoToXMLAction(selectedEditPart.getEntity(), this.getEditorPart());
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
            if (selectedEditPart.getEntity() instanceof NestedContainer && ModelUtils.isErrorHandler((NodeDefinition)(nestedContainer = (NestedContainer)selectedEditPart.getEntity()).getDefinition())) {
                ShowErrorHandlerAction showErrorHanlderAction = new ShowErrorHandlerAction(nestedContainer, (IWorkbenchPart)this.getEditorPart());
                showErrorHanlderAction.setAccelerator(0x100000C);
                menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)showErrorHanlderAction);
            }
        }
        action = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
        menu.appendToGroup("org.eclipse.gef.group.edit", action);
        this.addWrapInExtractOptions(menu);
        MessageFlowNodeContextMenuProviderManager.getDefault().addActions(muleProject, menu, selectedNode);
        if (selectedEditPart != null && selectedNode != null) {
            GoToImplementationHandlerManager goToImplementationManager = GoToImplementationHandlerManager.INSTANCE;
            String nodeType = this.getNode(selectedEditPart).getType();
            if (goToImplementationManager.hasHandler(nodeType) && !StringUtils.isEmpty((String)goToImplementationManager.getActionName(nodeType))) {
                this.addGoToOption(menu);
            }
            this.addActionsForSelectedNode(menu, selectedNode);
            MessageFlowNodeContextMenuProviderManager defaultMenuProvider = MessageFlowNodeContextMenuProviderManager.getDefault();
            defaultMenuProvider.addActionsForNode(menu, selectedNode);
        } else {
            CollapseAllContainersAction collapseAll = new CollapseAllContainersAction();
            ExpandAllContainersAction expandAll = new ExpandAllContainersAction();
            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)collapseAll);
            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)expandAll);
        }
    }

    private void addToggleCommentOption(IMenuManager menu) {
        if (this.isCanvasSelected().booleanValue()) {
            return;
        }
        ToggleCommentAction toggleComment = new ToggleCommentAction((IWorkbenchPart)this.getEditorPart());
        menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)toggleComment);
    }

    private Boolean isCanvasSelected() {
        Optional<EntityEditPart<? extends MessageFlowEntity>> selectedEditPart = Optional.ofNullable(this.getSelectedEditPart());
        return selectedEditPart.map(EntityEditPart::getEntity).map(ModelUtils::isMuleConfiguration).orElse(false);
    }

    private void addWrapInExtractOptions(IMenuManager menu) {
        IMuleProject muleProject = ((MessageFlowEditor)this.getEditorPart()).getMuleProject();
        String version = muleProject.getServerDefinition() == null ? null : muleProject.getServerDefinition().getVersionWithEESign();
        IMuleModuleManager moduleManager = muleProject.getModuleManager();
        List<EntityEditPart<? extends MessageFlowEntity>> selectedEditParts = this.getSelectedEditParts();
        boolean addWrapInOptions = this.shouldAddWrapInOptions(selectedEditParts);
        if (addWrapInOptions) {
            EntityEditPart<? extends MessageFlowEntity> firstEditPart = selectedEditParts.get(0);
            EditPart parent = firstEditPart.getParent();
            MessageFlowEntity parentNode = null;
            if (parent instanceof EntityEditPart) {
                EntityEditPart parentEditPart = (EntityEditPart)parent;
                parentNode = this.getEntity(parentEditPart);
            }
            if (parentNode != null && ModelUtils.isMuleConfiguration(parentNode)) {
                return;
            }
            this.addWrapinExtractOptions(menu, muleProject, version, moduleManager, this.getNode(firstEditPart), parentNode);
        }
    }

    private boolean shouldAddWrapInOptions(List<EntityEditPart<? extends MessageFlowEntity>> selectedEditParts) {
        boolean addWrapInOptions = !selectedEditParts.isEmpty();
        EditPart lastParent = null;
        for (EntityEditPart<? extends MessageFlowEntity> entityEditPart : selectedEditParts) {
            MessageFlowNode node = this.getNode(entityEditPart);
            boolean wrapInExtractCandidate = node != null && this.isWrapInExtractCandidate(node);
            boolean haveSameParent = lastParent == null || lastParent == entityEditPart.getParent();
            addWrapInOptions &= wrapInExtractCandidate && haveSameParent;
            lastParent = entityEditPart.getParent();
        }
        return addWrapInOptions;
    }

    private boolean isWrapInExtractCandidate(MessageFlowNode selectedNode) {
        final ObjectHolder result = new ObjectHolder();
        selectedNode.accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitContainer(Container container) {
                result.set((Object)(!ModelUtils.isFlowOrSubflow((IMessageFlowEntity)container) && !ModelUtils.isDefaultErrorHandler((Container)container) ? 1 : 0));
            }

            public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                result.set((Object)false);
            }

            public void defaultVisit(IMessageFlowEntity entity) {
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    private MessageFlowNode getSelectedNode() {
        return this.getNode(this.getSelectedEditPart());
    }

    private void addGoToOption(IMenuManager menu) {
        Action goToImplementationAction = new Action(){

            public void run() {
                GoToImplementationHandlerManager.INSTANCE.execute(MessageFlowContextMenuProvider.this.getSelectedNode());
            }
        };
        goToImplementationAction.setText(GoToImplementationHandlerManager.INSTANCE.getActionName(this.getSelectedNode().getType()));
        menu.add((IAction)goToImplementationAction);
    }

    private void addWrapinExtractOptions(IMenuManager menu, IMuleProject muleProject, String version, IMuleModuleManager moduleManager, MessageFlowNode selectedNode, MessageFlowEntity parentNode) {
        MenuManager wrapInMenu = new MenuManager("Wrap in...", null, "wrap.in.menu");
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)wrapInMenu);
        List definitions = moduleManager.getDefinitionsForCategory(Category.SCOPES.getCategoryString(), version);
        ResponseNodeUtils.removeResponseDefinition((Iterable)definitions);
        this.addWrapActionForDefinitions(wrapInMenu, parentNode, muleProject, definitions);
        MenuManager extractToMenu = new MenuManager("Extract to...", null, "extract.to.menu");
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)extractToMenu);
        this.addExtractEntityToContainerAction(extractToMenu, selectedNode, parentNode);
    }

    private void addExtractEntityToContainerAction(final MenuManager extractToMenu, final MessageFlowNode selectedNode, MessageFlowEntity parentNode) {
        parentNode.accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitNestedContainer(NestedContainer nestedContainer) {
                if (!"http://www.mulesoft.org/schema/mule/core/inboundCompartmentLane".equals(nestedContainer.getType())) {
                    this.defaultVisit((IMessageFlowEntity)nestedContainer);
                }
            }

            public void defaultVisit(IMessageFlowEntity entity) {
                MessageFlowContextMenuProvider.this.addExtractEntityToContainerAction(extractToMenu, selectedNode);
            }
        });
    }

    private void addExtractEntityToContainerAction(final MenuManager extractToMenu, MessageFlowNode selectedNode) {
        final IMuleProject muleProject = ((MessageFlowEditor)this.getEditorPart()).getMuleProject();
        IMuleModuleManager moduleManager = muleProject.getModuleManager();
        final NodeDefinition flowDefinition = moduleManager.getDefinition("http://www.mulesoft.org/schema/mule/core/flow");
        final NodeDefinition subFlowDefinition = moduleManager.getDefinition("http://www.mulesoft.org/schema/mule/core/sub-flow");
        selectedNode.accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

            public void visitContainer(Container container) {
                if (!ModelUtils.isFlowOrSubflow((IMessageFlowEntity)container)) {
                    if (!ModelUtils.isBatch((IMessageFlowEntity)container)) {
                        MessageFlowContextMenuProvider.this.doAddExtractAction(extractToMenu, muleProject, flowDefinition, subFlowDefinition);
                    } else {
                        MessageFlowContextMenuProvider.this.doAddExtractFlowActionOnly(extractToMenu, muleProject, flowDefinition);
                    }
                }
            }

            public void defaultVisit(IMessageFlowEntity entity) {
                MessageFlowContextMenuProvider.this.doAddExtractAction(extractToMenu, muleProject, flowDefinition, subFlowDefinition);
            }
        });
    }

    private void doAddExtractAction(MenuManager extractToMenu, IMuleProject muleProject, NodeDefinition flowDefinition, NodeDefinition subFlowDefinition) {
        extractToMenu.add((IAction)new ExtractEntityToFlowAction(muleProject, (IWorkbenchPart)this.getEditorPart(), (ContainerDefinition)flowDefinition));
        extractToMenu.add((IAction)new ExtractEntityToFlowAction(muleProject, (IWorkbenchPart)this.getEditorPart(), (ContainerDefinition)subFlowDefinition));
    }

    private void doAddExtractFlowActionOnly(MenuManager extractToMenu, IMuleProject muleProject, NodeDefinition flowDefinition) {
        extractToMenu.add((IAction)new ExtractEntityToFlowAction(muleProject, (IWorkbenchPart)this.getEditorPart(), (ContainerDefinition)flowDefinition));
    }

    private void addWrapActionForDefinitions(MenuManager wrapperMenu, MessageFlowEntity parentNode, IMuleProject muleProject, List<NodeDefinition> definitions) {
        NodeDefinition parentDefinition = this.getDefinition(parentNode, muleProject);
        for (NodeDefinition nodeDefinition : definitions) {
            boolean isContainer = nodeDefinition instanceof ContainerDefinition;
            if (!isContainer) continue;
            this.addWrapActionForDefinition(wrapperMenu, muleProject, nodeDefinition, parentDefinition);
        }
    }

    private NodeDefinition getDefinition(MessageFlowEntity parentNode, IMuleProject muleProject) {
        if (parentNode instanceof NestedContainer) {
            NestedContainer nestedContainer = (NestedContainer)parentNode;
            return nestedContainer.getDefinition();
        }
        if (parentNode instanceof MessageFlowNode) {
            MessageFlowNode messageFlowNode = (MessageFlowNode)parentNode;
            return messageFlowNode.getDefinition();
        }
        return null;
    }

    private void addWrapActionForDefinition(MenuManager wrapperMenu, IMuleProject muleProject, NodeDefinition nodeDefinition, NodeDefinition parentDefinition) {
        this.addWrapActionForDefinition(wrapperMenu, muleProject, nodeDefinition);
    }

    private void addWrapActionForDefinition(MenuManager wrapperMenu, IMuleProject muleProject, NodeDefinition nodeDefinition) {
        WrapEntityInNewContainerAction action = new WrapEntityInNewContainerAction(muleProject, this.getEditorPart(), nodeDefinition);
        if (action.isEnabled()) {
            wrapperMenu.add((IAction)action);
        }
    }

    protected void addActionsForSelectedNode(IMenuManager menu, MessageFlowNode selected) {
        IStructuredSelection selection;
        Object firstElement;
        MessageFlowEditor editor = (MessageFlowEditor)this.getEditorPart();
        IMessageFlowActionDelegate delegate = null;
        try {
            delegate = this.createActionDelegate(selected, editor.getMuleProject().getServerDefinition());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.editorPart.getSite().getShell(), (String)"Error", (String)"Unable to create actions for node.", (IStatus)e.getStatus());
        }
        if (delegate != null) {
            ArrayList<MessageFlowNodeAction> actions = new ArrayList<MessageFlowNodeAction>();
            try {
                actions.addAll(delegate.createActions(editor.getMuleProject(), selected, (IWorkbenchPart)this.getEditorPart()));
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            this.addCommonActions(actions, editor.getMuleProject(), (MessageFlowEntity)selected, (IWorkbenchPart)this.getEditorPart());
            for (MessageFlowNodeAction nodeAction : actions) {
                if (!nodeAction.isEnabled()) continue;
                menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)nodeAction);
            }
        }
        if ((firstElement = (selection = (IStructuredSelection)this.getViewer().getSelection()).getFirstElement()) instanceof EditPart && !ModelUtils.isComment((IMessageFlowEntity)selected)) {
            EntityDirectEditNameAction directEditNameAction = new EntityDirectEditNameAction(editor.getMuleProject(), selected, (IWorkbenchPart)this.getEditorPart());
            menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)directEditNameAction);
            if (MessageFlowUtils.isFlowOrSubflowEditPart((EditPart)firstElement)) {
                ExportImageToFileAction exportImageToFileAction = new ExportImageToFileAction(editor.getMuleProject(), selected, (IWorkbenchPart)this.getEditorPart());
                CollapseAllContainersAction collapseAll = new CollapseAllContainersAction();
                CollapseOtherContainersAction collapseOthers = new CollapseOtherContainersAction();
                ExpandAllContainersAction expandAll = new ExpandAllContainersAction();
                ReferencedByAction referencedBy = new ReferencedByAction(editor.getMuleProject(), selected, (IWorkbenchPart)this.getEditorPart());
                menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)exportImageToFileAction);
                menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)collapseAll);
                menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)collapseOthers);
                menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)expandAll);
                menu.appendToGroup("org.eclipse.gef.group.view", (IAction)referencedBy);
            }
            if (MessageFlowUtils.isErrorHandler((EditPart)firstElement)) {
                ReferencedByAction referencedBy = new ReferencedByAction(editor.getMuleProject(), selected, (IWorkbenchPart)this.getEditorPart());
                menu.appendToGroup("org.eclipse.gef.group.view", (IAction)referencedBy);
            }
        }
        if (MessageFlowUtils.isFlowRefNode((IMessageFlowNode)selected)) {
            ShowFlowAction showFlowAction = new ShowFlowAction(editor.getMuleProject(), selected, (IWorkbenchPart)this.getEditorPart());
            showFlowAction.setAccelerator(0x100000C);
            menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)showFlowAction);
        }
        this.addToggleCommentOption(menu);
    }

    protected IMessageFlowActionDelegate createActionDelegate(MessageFlowNode node, IServerDefinition server) throws CoreException {
        try {
            NodeDefinition template = node.getDefinition();
            Class dclass = template.getActionDelegate();
            if (dclass == null && CoreUtils.isExternalContribution((IMessageFlowNode)node, (IServerDefinition)server)) {
                ExternaContributionModuleDelegate del = new ExternaContributionModuleDelegate();
                return del;
            }
            if (dclass != null) {
                try {
                    IMessageFlowActionDelegate delegate = (IMessageFlowActionDelegate)dclass.newInstance();
                    return delegate;
                }
                catch (InstantiationException e) {
                    throw new CoreException(MuleCorePlugin.createStatus((int)4, (String)"Unable to create instance of node action delegate.", (Throwable)e));
                }
                catch (IllegalAccessException e) {
                    throw new CoreException(MuleCorePlugin.createStatus((int)4, (String)"Unable to access instance of node action delegate.", (Throwable)e));
                }
                catch (ClassCastException e) {
                    throw new CoreException(MuleCorePlugin.createStatus((int)4, (String)("Node action delegate not an instance of " + IMessageFlowActionDelegate.class.getName() + "."), (Throwable)e));
                }
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    protected void addCommonActions(List<MessageFlowNodeAction> list, IMuleProject muleProject, MessageFlowEntity entity, IWorkbenchPart part) {
    }

    protected MessageFlowNode getNode(EntityEditPart<?> editPart) {
        Object selModel;
        if (editPart != null && (selModel = editPart.getEntity()) instanceof MessageFlowNode) {
            return (MessageFlowNode)selModel;
        }
        return null;
    }

    protected MessageFlowEntity getEntity(EntityEditPart<?> editPart) {
        Object selModel;
        if (editPart != null && (selModel = editPart.getEntity()) instanceof MessageFlowEntity) {
            return (MessageFlowEntity)selModel;
        }
        return null;
    }

    protected EntityEditPart<? extends MessageFlowEntity> getSelectedEditPart() {
        Object selected;
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof EntityEditPart) {
            return (EntityEditPart)selected;
        }
        return null;
    }

    protected List<EntityEditPart<? extends MessageFlowEntity>> getSelectedEditParts() {
        ArrayList<EntityEditPart<? extends MessageFlowEntity>> selectedParts = new ArrayList<EntityEditPart<? extends MessageFlowEntity>>();
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        for (Object selected : selection.toList()) {
            if (!(selected instanceof EntityEditPart)) continue;
            EntityEditPart part = (EntityEditPart)selected;
            selectedParts.add(part);
        }
        return selectedParts;
    }

    protected void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    protected IEditorPart getEditorPart() {
        return this.editorPart;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    protected void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    public void dispose() {
        super.dispose();
        this.editorPart = null;
        this.actionRegistry = null;
    }
}

