/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.cache.internal.ExternalMuleContentHandler;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.editor.InMemoryConfigurationFileEditorInput;
import org.mule.tooling.utils.InMemoryConfigurationFile;
import org.mule.tooling.utils.InMemoryFile;

public class InMemoryConfigurationFileEditorInputFactory
implements IElementFactory {
    private static final String ID_FACTORY = "org.mule.tooling.messageflow.editor.InMemoryConfigurationFileEditorInputFactory";
    private static final String TAG_JAR_PATH = "jarPath";
    private static final String TAG_CONFIGURATION_NAME = "confName";
    private static final String TAG_PROJECT_NAME = "project";

    /*
     * Loose catch block
     */
    public IAdaptable createElement(IMemento memento) {
        String confName = memento.getString(TAG_CONFIGURATION_NAME);
        String jarPath = memento.getString(TAG_JAR_PATH);
        String projectName = memento.getString(TAG_PROJECT_NAME);
        if (confName == null || jarPath == null || projectName == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        File jarFile = new File(jarPath);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileSystem fs = FileSystems.newFileSystem(jarFile.toPath());){
                InMemoryConfigurationFileEditorInput inMemoryConfigurationFileEditorInput;
                InputStream newInputStream;
                Throwable throwable2;
                block23: {
                    java.nio.file.Path zipFilePath = fs.getPath(confName, new String[0]);
                    throwable2 = null;
                    Object var12_16 = null;
                    newInputStream = Files.newInputStream(zipFilePath, new OpenOption[0]);
                    Path newPath = new Path(jarFile.toPath().toString());
                    String content = CoreUtils.inputStreamToString((InputStream)newInputStream, (Charset)IMuleResources.DEFAULT_CHARSET);
                    InMemoryConfigurationFile inMemoryConfigurationFile = InMemoryConfigurationFile.createInMemoryConfigurationFile((IPath)newPath, (String)confName, (InMemoryFile.IContentHandler)new ExternalMuleContentHandler(content, newPath), (IProject)project);
                    inMemoryConfigurationFileEditorInput = new InMemoryConfigurationFileEditorInput(inMemoryConfigurationFile);
                    if (newInputStream == null) break block23;
                    newInputStream.close();
                }
                return inMemoryConfigurationFileEditorInput;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (newInputStream != null) {
                                newInputStream.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)("Error reading configuration: " + confName + " from " + jarFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, InMemoryConfigurationFileEditorInput input) {
        InMemoryConfigurationFile file = (InMemoryConfigurationFile)input.getFile();
        memento.putString(TAG_JAR_PATH, file.getLocation().toString());
        memento.putString(TAG_CONFIGURATION_NAME, file.getConfName());
        memento.putString(TAG_PROJECT_NAME, file.getProject().getName());
    }
}

