/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IThemeChangedListener;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.messageflow.command.AddGlobalElementCommand;
import org.mule.tooling.messageflow.command.DeleteGlobalElementAndUpdateCommand;
import org.mule.tooling.messageflow.command.DeleteGlobalUnknownElementCommand;
import org.mule.tooling.messageflow.command.EditGlobalElementsCommand;
import org.mule.tooling.messageflow.dialog.GlobalElementDialog;
import org.mule.tooling.messageflow.dialog.GlobalTypeChooser;
import org.mule.tooling.messageflow.editor.EmptyEditorSite;
import org.mule.tooling.messageflow.editor.IMessageFlowEditorListener;
import org.mule.tooling.messageflow.editor.MessageFlowActionManager;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.internal.GlobalEditorNameValidator;
import org.mule.tooling.messageflow.internal.GlobalElementEditorHelper;
import org.mule.tooling.messageflow.internal.StyledGlobalElementLabelProvider;
import org.mule.tooling.messageflow.util.GlobalElementUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.GlobalElementDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.command.OpenManageModulesPropertyPage;
import org.mule.tooling.ui.widgets.SquareButton;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class GlobalElementEditor
extends FormPage
implements CommandStackEventListener,
IMessageFlowEditorListener,
Observer {
    public static final String PAGE_ID = "mule.messageflow.globals";
    public static final String PAGE_TITLE = "Global Configuration Elements";
    private static final String CONFIG_PROPERTIES_REGEX = "(.*)\\$\\{([^}]+)\\}(.*)";
    private MessageFlowEditor messageFlowEditor;
    private TableViewer globalsTable;
    private SquareButton btnCreate;
    private SquareButton btnEdit;
    private SquareButton btnDelete;
    private MuleConfigurationDecorator input;
    private ActionRegistry actionRegistry;
    private final MessageFlowActionManager actionManager;
    private DefaultEditDomain editDomain;
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private boolean disposed;
    private GlobalElementEditorHelper editorHelper = new GlobalElementEditorHelper();
    private final Pattern configPropertiesPattern;
    private Observer observer = new Observer(){

        @Override
        public void update(Observable arg0, Object arg1) {
            GlobalElementEditor.this.refresh();
        }
    };

    public GlobalElementEditor(FormEditor top, MessageFlowEditor owner, boolean readOnly) {
        super(top, PAGE_ID, PAGE_TITLE);
        this.messageFlowEditor = owner;
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
        owner.addListener(this);
        this.initActionRegistry();
        this.actionManager = new MessageFlowActionManager(this.getActionRegistry());
        if (readOnly) {
            this.editDomain.setCommandStack((CommandStack)new NoOpCommandStack());
        }
        this.editDomain.getCommandStack().addCommandStackListener((CommandStackListener)this.actionManager);
        this.editDomain.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_THEME_CHANGED, (IEventHandler)new IThemeChangedListener(){

            public void onThemeChanged() {
                GlobalElementEditor.this.refresh();
            }
        });
        this.configPropertiesPattern = Pattern.compile(CONFIG_PROPERTIES_REGEX);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        try {
            if (MuleProjectKind.APPLICATION.classifies(this.messageFlowEditor.getMuleProject().getProject())) {
                form.setImage(MuleImages.GLOBALS_TITLE_IMAGE_MULE_PROJECT);
            } else if (MuleProjectKind.DOMAIN.classifies(this.messageFlowEditor.getMuleProject().getProject())) {
                form.setImage(MuleImages.GLOBALS_TITLE_IMAGE_DOMAIN_PROJECT);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)("Error setting global elements editor image for project " + this.messageFlowEditor.getMuleProject().getName()), (Throwable)e);
        }
        form.setText(PAGE_TITLE);
        form.addDisposeListener(event -> {
            if (this.input != null) {
                this.input.deleteObserver(this.observer);
            }
        });
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        this.fillBody(managedForm, toolkit);
    }

    protected void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(body);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite wrapper = new Composite(body, 0);
        wrapper.setLayout((Layout)tableColumnLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        this.globalsTable = new TableViewer(wrapper, 66308);
        this.globalsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.globalsTable.setLabelProvider((IBaseLabelProvider)new StyledGlobalElementLabelProvider(this.messageFlowEditor));
        this.globalsTable.addOpenListener(event -> this.doEdit());
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                IStructuredSelection selection = (IStructuredSelection)GlobalElementEditor.this.globalsTable.getSelection();
                menuManager.add((IAction)GlobalElementEditor.this.newCreateAction());
                if (selection != null && selection.getFirstElement() != null) {
                    MenuManager refactorManager = new MenuManager();
                    refactorManager.setMenuText("Refactor...");
                    refactorManager.add((IAction)GlobalElementEditor.this.newRenameAction(selection));
                    menuManager.add((IContributionItem)new Separator());
                    menuManager.add((IAction)GlobalElementEditor.this.goToXmlAction());
                    menuManager.add((IContributionItem)new Separator());
                    menuManager.add((IAction)GlobalElementEditor.this.newEditAction());
                    menuManager.add((IAction)GlobalElementEditor.this.newDeleteAction());
                    menuManager.add((IContributionItem)new Separator());
                    menuManager.add((IContributionItem)refactorManager);
                    menuManager.update(true);
                }
            }
        });
        Menu contextMenu = menuManager.createContextMenu(this.globalsTable.getControl());
        this.globalsTable.getControl().setMenu(contextMenu);
        Table table = this.globalsTable.getTable();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        this.createColumn(table, tableColumnLayout, "Type", 30, 60);
        this.createColumn(table, tableColumnLayout, "Name", 30, 60);
        this.createColumn(table, tableColumnLayout, "Description", 40, 120);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    GlobalElementEditor.this.doDelete();
                }
            }
        });
        this.globalsTable.addSelectionChangedListener(event -> {
            ISelectionProvider outerProvider = this.getSite().getSelectionProvider();
            if (outerProvider instanceof MultiPageSelectionProvider) {
                SelectionChangedEvent newEvent = new SelectionChangedEvent(outerProvider, event.getSelection());
                MultiPageSelectionProvider provider = (MultiPageSelectionProvider)outerProvider;
                provider.fireSelectionChanged(newEvent);
                provider.firePostSelectionChanged(newEvent);
            }
        });
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                Table table = (Table)event.widget;
                int clientWidth = table.getClientArea().width;
                GC gc = event.gc;
                Color oldBackground = gc.getBackground();
                gc.setBackground(new Color((Device)Display.getCurrent(), new RGB(1, 153, 255)));
                gc.setAlpha(75);
                gc.fillRectangle(0, event.y, clientWidth, event.height);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalElementEditor.this.updateButtonEnablement();
            }
        });
        this.addFormActions(toolkit, body);
        this.refresh();
    }

    private void addFormActions(FormToolkit toolkit, Composite body) {
        Composite buttons = toolkit.createComposite(body);
        GridLayoutFactory.swtDefaults().applyTo(buttons);
        GridDataFactory.swtDefaults().align(1, 4).grab(false, true).hint(120, -1).applyTo((Control)buttons);
        this.addCreateButton(buttons);
        this.addEditButton(buttons);
        this.addDeleteButton(buttons);
        if (this.messageFlowEditor.getMuleProject() instanceof IMuleDomainProject) {
            this.addManageModulesButton(buttons);
        }
    }

    private void addCreateButton(Composite buttons) {
        this.btnCreate = this.createButton(buttons, "Create", this::doCreate);
    }

    private void addEditButton(Composite buttons) {
        this.btnEdit = this.createButton(buttons, "Edit", this::doEdit);
    }

    private void addDeleteButton(Composite buttons) {
        this.btnDelete = this.createButton(buttons, "Delete", this::doDelete);
    }

    private void addManageModulesButton(Composite buttons) {
        this.createButton(buttons, "Manage Modules", this::doManageModules);
    }

    private SquareButton createButton(Composite buttons, String label, Runnable runnable) {
        SquareButton button = WidgetUtils.createSquareButton((Composite)buttons, (String)label, (Runnable)runnable);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)button);
        return button;
    }

    protected void updateButtonEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.globalsTable.getSelection();
        boolean globalSelected = false;
        if (selection != null && !selection.isEmpty()) {
            MessageFlowEntity selected = (MessageFlowEntity)selection.getFirstElement();
            if (selected instanceof GlobalElement) {
                globalSelected = true;
            }
            if (selected instanceof GlobalUnknown) {
                globalSelected = true;
            }
        }
        this.btnEdit.setEnabled(globalSelected);
        this.btnDelete.setEnabled(globalSelected);
        this.btnCreate.setEnabled(true);
    }

    protected void initActionRegistry() {
        this.actionRegistry = new ActionRegistry();
        this.actionRegistry.registerAction((IAction)new UndoAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new RedoAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new DeleteAction((IWorkbenchPart)this));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == CommandStack.class) {
            return this.editDomain.getCommandStack();
        }
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        return super.getAdapter(adapter);
    }

    protected TableColumn createColumn(Table parent, TableColumnLayout layout, String title, int weight, int minWidth) {
        TableColumn column = new TableColumn(parent, 16384);
        column.setText(title);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, minWidth));
        return column;
    }

    public void refresh() {
        if (this.globalsTable != null && this.input != null) {
            List globalEntries = ((MuleConfiguration)this.input.getEntity()).getGlobalEntries();
            this.globalsTable.setInput(this.editorHelper.getFilteredGlobal(globalEntries));
            this.updateButtonEnablement();
        }
    }

    public void selectEntry(IMessageFlowEntity entity) {
        List globalEntries = (List)this.globalsTable.getInput();
        if (globalEntries.contains(entity)) {
            int globalEntryIndex = globalEntries.indexOf(entity);
            this.globalsTable.getTable().select(globalEntryIndex);
        }
    }

    @Override
    public void inputChanged() {
        if (this.input != null) {
            this.input.deleteObserver(this.observer);
        }
        this.input = this.messageFlowEditor.getModelRoot();
        this.input.addObserver(this.observer);
        this.refresh();
    }

    public void stackChanged(CommandStackEvent event) {
        if (event.isPostChangeEvent()) {
            this.firePropertyChange(257);
        }
    }

    protected void doCreate() {
        Shell shell = this.getSite().getShell();
        IMuleProject muleProject = this.messageFlowEditor.getMuleProject();
        GlobalTypeChooser chooser = this.createGlobalTypeChooser();
        if (chooser.open() == 0) {
            GlobalDefinition definition = chooser.getSelected();
            IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)muleProject, (MuleConfiguration)((MuleConfiguration)this.getInput().getEntity()));
            GlobalElement element = MessageFlowFactory.createGlobalElement((IFlowTransformerContext)context, (GlobalDefinition)definition);
            GlobalElementDialog dialog = new GlobalElementDialog(shell, muleProject, element, () -> this.messageFlowEditor.getMuleConfiguration());
            if (dialog.open() == 0) {
                PropertyCollection updated = dialog.getUpdatedProperties().asPropertyCollection();
                element.setProperties(updated);
                this.addGlobal(element);
            }
        }
    }

    protected void goToXML() {
        IStructuredSelection selection = (IStructuredSelection)this.globalsTable.getSelection();
        if (selection != null && selection.getFirstElement() != null) {
            MessageFlowEntity selected = (MessageFlowEntity)selection.getFirstElement();
            this.messageFlowEditor.goToXml(selected.getElement().getLocation());
        }
    }

    public GlobalTypeChooser createGlobalTypeChooser() {
        Shell shell = this.getSite().getShell();
        IMuleProject muleProject = this.messageFlowEditor.getMuleProject();
        boolean isDomainProject = MuleProjectKind.DOMAIN.classifies(muleProject);
        if (isDomainProject) {
            return new GlobalTypeChooser(shell, muleProject){

                @Override
                protected void addionalFilters(TreeViewer typesTree) {
                    typesTree.addFilter(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            if (element instanceof CategoryDefinition) {
                                CategoryDefinition category = (CategoryDefinition)element;
                                List globalDefinitions = MuleCorePlugin.getModuleManager().getGlobalDefinitionsForPaletteCategory(category.getId(), (this).GlobalElementEditor.this.messageFlowEditor.getMuleProject().getServerDefinition().getVersion());
                                return globalDefinitions.stream().map(NodeDefinition::getId).anyMatch(id -> !DomainUtils.GLOBAL_ELEMENTS_BLOCK_LIST.contains(id));
                            }
                            if (element instanceof NodeDefinition) {
                                return !DomainUtils.GLOBAL_ELEMENTS_BLOCK_LIST.contains(((NodeDefinition)element).getId());
                            }
                            return true;
                        }
                    });
                }
            };
        }
        return new GlobalTypeChooser(shell, muleProject);
    }

    public void addGlobal(GlobalElement element) {
        AddGlobalElementCommand command = new AddGlobalElementCommand(this.input, element);
        this.editDomain.getCommandStack().execute((Command)command);
        this.refresh();
    }

    public void deleteSelected() {
        this.doDelete();
    }

    protected void doEdit() {
        Shell shell = this.getSite().getShell();
        IStructuredSelection selection = (IStructuredSelection)this.globalsTable.getSelection();
        if (selection != null && selection.getFirstElement() != null) {
            MessageFlowEntity selected = (MessageFlowEntity)selection.getFirstElement();
            if (selected instanceof GlobalUnknown) {
                GlobalUnknown ns = (GlobalUnknown)selected;
                this.openUnknown(ns.getContent());
            }
            if (selected instanceof GlobalElement) {
                this.doEditGlobalElement(shell, this.messageFlowEditor.getMuleProject(), this.getInput(), selected);
                this.refresh();
            }
        }
    }

    protected void doManageModules() {
        OpenManageModulesPropertyPage.openManageModulesPropertyPage((Shell)Display.getCurrent().getActiveShell(), (IProject)this.messageFlowEditor.getMuleProject().getProject(), (Object)1);
    }

    private void doEditGlobalElement(Shell shell, IMuleProject muleProject, MuleConfigurationDecorator configDecorator, MessageFlowEntity selected) {
        PropertyCollection updated;
        IReadOnlyPropertyCollection previous;
        IMuleConfigurationsCache configurationsCache = muleProject.getConfigurationsCache();
        IFile inputXmlConfigFile = this.messageFlowEditor.getInputXmlConfigFile();
        configurationsCache.savePreviousRelatedConfigs(inputXmlConfigFile);
        GlobalElement element = (GlobalElement)selected;
        GlobalElementDialog dialog = new GlobalElementDialog(shell, muleProject, element, () -> this.messageFlowEditor.getMuleConfiguration());
        if (dialog.open() == 0 && GlobalElementUtils.areAnyChanges(previous = element.getProperties(), updated = this.replaceConfigurationProperties(dialog.getUpdatedProperties().asPropertyCollection(), element), dialog)) {
            String newName = this.editorHelper.extractName(updated.getProperties());
            String oldName = previous != null ? this.editorHelper.extractName(previous.getProperties()) : newName;
            RenameElement transformer = null;
            if (newName != null && !newName.equals(oldName)) {
                transformer = new RenameElement(oldName, newName);
            }
            GlobalElementDecorator decorator = new GlobalElementDecorator(element);
            EditGlobalElementsCommand command = new EditGlobalElementsCommand(muleProject, configDecorator, transformer, previous, updated, (EntityDecorator<GlobalElement>)decorator);
            this.editDomain.getCommandStack().execute((Command)command);
            this.messageFlowEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private PropertyCollection replaceConfigurationProperties(PropertyCollection value, GlobalElement element) {
        List properties = element.getPropertiesForEdit(null).getProperties();
        return this.replaceConfigurationPropertiesForFalseCheckboxes(value, properties);
    }

    public PropertyCollection replaceConfigurationPropertiesForFalseCheckboxes(PropertyCollection value, List<Property> properties) {
        List<Property> configurationProperties = this.getConfigurationProperties(properties);
        for (Property p : configurationProperties) {
            if (!this.isFalseCheckboxProperty(value.getProperty(p.getName()))) continue;
            value.removeProperty(p.getName());
            value.addProperty(p);
        }
        return value;
    }

    private boolean isFalseCheckboxProperty(Property p) {
        boolean isCheckboxProperty = false;
        if (p != null) {
            isCheckboxProperty = p.getValue().equals("false");
        }
        return isCheckboxProperty;
    }

    private List<Property> getConfigurationProperties(List<Property> properties) {
        return properties.stream().filter(p -> this.isConfigurationProperty((Property)p)).collect(Collectors.toList());
    }

    public boolean isConfigurationProperty(Property p) {
        boolean isConfigurationProperty = false;
        if (p != null) {
            isConfigurationProperty = this.configPropertiesPattern.matcher(p.getValue()).matches();
        }
        return isConfigurationProperty;
    }

    public MuleConfigurationDecorator getInput() {
        return this.input;
    }

    public MessageFlowEditor getMessageFlowEditor() {
        return this.messageFlowEditor;
    }

    protected void doRename(IStructuredSelection selection) {
        MessageFlowEntity selected = (MessageFlowEntity)selection.getFirstElement();
        if (selected instanceof GlobalElement) {
            this.renameGlobal((GlobalElement)selected);
        }
    }

    private void renameGlobal(GlobalElement global) {
        boolean okPressed;
        GlobalEditorNameValidator validator;
        String initialValue;
        IReadOnlyProperty property = PropertiesUtils.findPropertyByName((IMessageFlowNode)global, (String)"name");
        if (property == null) {
            return;
        }
        String name = property.getValue();
        Shell shell = this.getSite().getShell();
        InputDialog inputDialog = new InputDialog(shell, "Rename Global Element", "New name:", initialValue = name, (IInputValidator)(validator = new GlobalEditorNameValidator()));
        int state = inputDialog.open();
        boolean bl = okPressed = state == 0;
        if (okPressed) {
            String newName = inputDialog.getValue();
            IReadOnlyPropertyCollection oldProperties = global.getProperties();
            PropertyCollection newProperties = new PropertyCollection();
            Property newNameProperty = new Property();
            newNameProperty.setName("name");
            newNameProperty.setValue(newName);
            for (IReadOnlyProperty oldProp : oldProperties.getProperties()) {
                newProperties.getProperties().add(PropertiesUtils.toWritableProperty((IReadOnlyProperty)oldProp));
            }
            newProperties.removeProperty("name");
            newProperties.addProperty(newNameProperty);
            newProperties.setElement(oldProperties.getElement());
            RenameElement transformer = null;
            if (newName == null || !newName.equals(name)) {
                transformer = new RenameElement(name, newName);
            }
            GlobalElementDecorator decorator = new GlobalElementDecorator(global);
            EditGlobalElementsCommand command = new EditGlobalElementsCommand(this.messageFlowEditor.getMuleProject(), this.input, transformer, oldProperties, newProperties, (EntityDecorator<GlobalElement>)decorator);
            this.editDomain.getCommandStack().execute((Command)command);
        }
    }

    protected void openUnknown(String ns) {
    }

    protected void doDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.globalsTable.getSelection();
        if (!selection.isEmpty()) {
            GlobalElement element;
            IMuleProject muleProject = this.messageFlowEditor.getMuleProject();
            IMuleConfigurationsCache configurationsCache = muleProject.getConfigurationsCache();
            IFile inputXmlConfigFile = this.messageFlowEditor.getInputXmlConfigFile();
            configurationsCache.savePreviousRelatedConfigs(inputXmlConfigFile);
            MessageFlowEntity selected = (MessageFlowEntity)selection.getFirstElement();
            if (selected instanceof GlobalElement) {
                element = (GlobalElement)selected;
                PropertyTransformer transformer = this.getUpdateTransformation(element);
                DeleteGlobalElementAndUpdateCommand command = new DeleteGlobalElementAndUpdateCommand(muleProject, this, transformer, element);
                this.editDomain.getCommandStack().execute((Command)command);
                this.refresh();
            }
            if (selected instanceof GlobalUnknown) {
                element = (GlobalUnknown)selected;
                DeleteGlobalUnknownElementCommand command = new DeleteGlobalUnknownElementCommand(this.input, (GlobalUnknown)element);
                this.editDomain.getCommandStack().execute((Command)command);
                this.refresh();
            }
        }
    }

    private PropertyTransformer getUpdateTransformation(GlobalElement element) {
        String name = element.getProperties() != null ? this.editorHelper.extractName(element.getProperties().getProperties()) : element.getName();
        Optional<String> replacement = this.editorHelper.getNameReplacement(element, (List)this.globalsTable.getInput());
        PropertyTransformer transformer = replacement.isPresent() ? new RenameElement(name, replacement.get()) : new DeleteElement(name);
        return transformer;
    }

    public boolean isDirty() {
        return this.editDomain != null && this.editDomain.getCommandStack().isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        this.editDomain.getCommandStack().markSaveLocation();
        this.firePropertyChange(257);
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public void reloadContents() {
        this.editDomain.getCommandStack().flush();
    }

    public void dispose() {
        super.dispose();
        this.disposed = true;
        this.actionRegistry.dispose();
        this.editDomain = null;
        this.messageFlowEditor = null;
        this.setSite((IWorkbenchPartSite)new EmptyEditorSite());
        this.eventBusHelper.unregister();
    }

    private Action newDeleteAction() {
        Action deleteAction = new Action(){

            public void run() {
                GlobalElementEditor.this.doDelete();
            }
        };
        deleteAction.setText("Delete");
        deleteAction.setImageDescriptor(MuleImages.DESC_DELETE);
        return deleteAction;
    }

    private Action newEditAction() {
        Action editAction = new Action(){

            public void run() {
                GlobalElementEditor.this.doEdit();
            }
        };
        editAction.setText("Edit");
        editAction.setImageDescriptor(MuleImages.DESC_RENAME_SMALL);
        return editAction;
    }

    private Action newRenameAction(final IStructuredSelection selection) {
        Action renameAction = new Action(){

            public void run() {
                GlobalElementEditor.this.doRename(selection);
            }
        };
        renameAction.setText("Rename");
        return renameAction;
    }

    private Action newCreateAction() {
        Action createAction = new Action(){

            public void run() {
                GlobalElementEditor.this.doCreate();
            }
        };
        createAction.setText("Create");
        createAction.setImageDescriptor(MuleImages.DESC_ADD);
        return createAction;
    }

    private Action goToXmlAction() {
        Action createAction = new Action(){

            public void run() {
                GlobalElementEditor.this.goToXML();
            }
        };
        createAction.setText("Go to XML...");
        createAction.setImageDescriptor(MuleImages.DESC_SEARCH);
        return createAction;
    }

    public void updateEntityErrors(IMuleError[] errors) {
        if (this.isDisposed()) {
            return;
        }
        this.globalsTable.refresh();
    }

    private boolean isDisposed() {
        return this.disposed;
    }

    private static final class DeleteElement
    implements PropertyTransformer {
        private final String name;

        public DeleteElement(String name) {
            this.name = name;
        }

        @Override
        public String transform(String in) {
            if (in == null) {
                return null;
            }
            String[] splitted = in.split(" ");
            ArrayList<String> result = new ArrayList<String>();
            String[] stringArray = splitted;
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String transformerName = stringArray[n2];
                if (!transformerName.equals(this.name)) {
                    result.add(transformerName);
                }
                ++n2;
            }
            return StringUtils.join((Object[])result.toArray(), (char)' ');
        }
    }

    private class NoOpCommandStack
    extends CommandStack {
        private NoOpCommandStack() {
        }

        public void execute(Command command) {
        }
    }

    public static interface PropertyTransformer {
        public String transform(String var1);
    }

    private static final class RenameElement
    implements PropertyTransformer {
        private final String oldName;
        private final String newName;

        public RenameElement(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public String transform(String in) {
            if (in == null) {
                return null;
            }
            String[] splitted = in.split(" ");
            ArrayList<String> result = new ArrayList<String>();
            String[] stringArray = splitted;
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String transformerName = stringArray[n2];
                result.add(transformerName.equals(this.oldName) ? this.newName : transformerName);
                ++n2;
            }
            return StringUtils.join((Object[])result.toArray(), (char)' ');
        }
    }
}

