/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;

public class FormEditorNavigationLocation
extends NavigationLocation {
    private int pageIndex;
    private boolean isFlowEditor;
    private String locationName;

    protected FormEditorNavigationLocation(MultiPageMessageFlowEditor editorPart) {
        super((IEditorPart)editorPart);
        this.pageIndex = editorPart.getActivePage();
        this.locationName = this.computeLocationName(editorPart);
        this.isFlowEditor = editorPart.getFlowEditorIndex() == this.pageIndex;
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void restoreLocation() {
        IEditorInput input = (IEditorInput)this.getInput();
        if (!input.exists()) {
            return;
        }
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart instanceof MultiPageMessageFlowEditor) {
            MultiPageMessageFlowEditor editor = (MultiPageMessageFlowEditor)editorPart;
            editor.setActivePage(this.pageIndex);
            if (this.isFlowEditor) {
                editor.getFlowEditor().getViewer().deselectAll();
            }
        }
    }

    public String getText() {
        return this.locationName;
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation instanceof FormEditorNavigationLocation) {
            FormEditorNavigationLocation asFormEditorLocation = (FormEditorNavigationLocation)currentLocation;
            boolean samePage = this.pageIndex == asFormEditorLocation.pageIndex;
            return samePage;
        }
        return false;
    }

    public void update() {
    }

    private String computeLocationName(MultiPageMessageFlowEditor editor) {
        String activeEditorTitle = editor.getActiveEditor().getTitle();
        String editorTitle = editor.getTitle();
        return StringUtils.isBlank((String)activeEditorTitle) ? editorTitle : editorTitle + " - " + activeEditorTitle;
    }
}

