/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.IExpressionHighligherImpl;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class ExpressionHighlighter
implements ITextPresentationListener {
    private final StructuredTextViewer sourceViewer;
    private boolean inited;
    private MultiPageMessageFlowEditor editor;
    private IExpressionHighligherImpl highlighter;

    ExpressionHighlighter(StructuredTextViewer sourceViewer, MultiPageMessageFlowEditor multiPageMessageFlowEditor) {
        IConfigurationElement[] configurationElementsFor;
        this.sourceViewer = sourceViewer;
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.messageflow.highlighter");
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                this.highlighter = (IExpressionHighligherImpl)e.createExecutableExtension("class");
            }
            catch (CoreException e1) {
                MuleCorePlugin.getLog().log(e1.getStatus());
            }
            ++n2;
        }
        this.editor = multiPageMessageFlowEditor;
    }

    public void applyTextPresentation(final TextPresentation textPresentation) {
        StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IStructuredDocument document = (IStructuredDocument)ExpressionHighlighter.this.sourceViewer.getDocument();
                IDOMModel existingModelForRead = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)document);
                if (existingModelForRead == null) {
                    return null;
                }
                IDOMDocument document2 = existingModelForRead.getDocument();
                Element documentElement = document2.getDocumentElement();
                ExpressionHighlighter.this.highlighter.setVersion(ExpressionHighlighter.this.editor.getRuntimeVersion());
                if (!ExpressionHighlighter.this.inited) {
                    ExpressionHighlighter.this.inited = true;
                    existingModelForRead.getModelNotifier();
                }
                try {
                    IRegion coverage = textPresentation.getCoverage();
                    ArrayList<IDOMElement> gather = new ArrayList<IDOMElement>();
                    ExpressionHighlighter.this.gatherElements(documentElement, coverage, gather);
                    for (IDOMElement el : gather) {
                        NamedNodeMap childNodes = el.getAttributes();
                        int a = 0;
                        while (a < childNodes.getLength()) {
                            StyleRange[] highlightAttributeValue;
                            IDOMText ts;
                            int startOffset;
                            String text;
                            IDOMAttr atr;
                            int valueRegionStartOffset;
                            Node item = childNodes.item(a);
                            if (item instanceof IDOMAttr && (valueRegionStartOffset = (atr = (IDOMAttr)item).getValueRegionStartOffset()) >= coverage.getOffset() && valueRegionStartOffset < coverage.getOffset() + coverage.getLength() && (text = atr.getValueRegionText()) != null) {
                                boolean equals = atr.getName().equals("expression");
                                StyleRange[] highlightAttributeValue2 = ExpressionHighlighter.this.highlighter.highlightAttributeValue(el, atr);
                                if (highlightAttributeValue2 != null) {
                                    StyleRange[] styleRangeArray = highlightAttributeValue2;
                                    int n = highlightAttributeValue2.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        StyleRange r = styleRangeArray[n2];
                                        textPresentation.mergeStyleRange(r);
                                        ++n2;
                                    }
                                }
                            }
                            if (item instanceof IDOMText && (startOffset = (ts = (IDOMText)item).getStartOffset()) >= coverage.getOffset() && startOffset < coverage.getOffset() + coverage.getLength() && (highlightAttributeValue = ExpressionHighlighter.this.highlighter.highlightTextValue(el, ts)) != null) {
                                StyleRange[] styleRangeArray = highlightAttributeValue;
                                int n = highlightAttributeValue.length;
                                int highlightAttributeValue2 = 0;
                                while (highlightAttributeValue2 < n) {
                                    StyleRange r = styleRangeArray[highlightAttributeValue2];
                                    textPresentation.mergeStyleRange(r);
                                    ++highlightAttributeValue2;
                                }
                            }
                            ++a;
                        }
                        NodeList childNodes2 = el.getChildNodes();
                        int a2 = 0;
                        while (a2 < childNodes2.getLength()) {
                            StyleRange[] highlightAttributeValue;
                            IDOMText ts;
                            int startOffset;
                            Node item = childNodes2.item(a2);
                            if (item instanceof IDOMText && (startOffset = (ts = (IDOMText)item).getStartOffset()) >= coverage.getOffset() && startOffset < coverage.getOffset() + coverage.getLength() && (highlightAttributeValue = ExpressionHighlighter.this.highlighter.highlightTextValue(el, ts)) != null) {
                                StyleRange[] styleRangeArray = highlightAttributeValue;
                                int n = highlightAttributeValue.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    StyleRange r = styleRangeArray[n3];
                                    textPresentation.mergeStyleRange(r);
                                    ++n3;
                                }
                            }
                            ++a2;
                        }
                    }
                }
                finally {
                    existingModelForRead.releaseFromRead();
                }
                return null;
            }
        }, (IMuleProject)this.editor.getMuleProject());
    }

    private void gatherElements(Element documentElement, IRegion coverage, ArrayList<IDOMElement> gather) {
        IDOMElement dl = (IDOMElement)documentElement;
        if (dl == null) {
            return;
        }
        if (coverage == null) {
            return;
        }
        int offset = coverage.getOffset();
        int startOffset = dl.getStartOffset();
        int endOffset = dl.getEndOffset();
        if (endOffset < offset) {
            return;
        }
        if (startOffset > offset + coverage.getLength()) {
            return;
        }
        NodeList childNodes = dl.getChildNodes();
        gather.add(dl);
        int a = 0;
        while (a < childNodes.getLength()) {
            Node item = childNodes.item(a);
            if (item instanceof IDOMElement) {
                this.gatherElements((Element)item, coverage, gather);
            }
            ++a;
        }
    }

    private static final class ExpressionHighlighterXMLModelNotifier
    implements XMLModelNotifier {
        private final XMLModelNotifier modelNotifier;
        private final IStructuredDocument document;
        private int min;
        private int max;
        protected boolean scheduled;

        private ExpressionHighlighterXMLModelNotifier(XMLModelNotifier modelNotifier, IStructuredDocument document) {
            this.modelNotifier = modelNotifier;
            this.document = document;
        }

        public void valueChanged(Node node) {
            this.modelNotifier.valueChanged(node);
        }

        public void structureChanged(Node node) {
            this.modelNotifier.structureChanged(node);
        }

        public void startTagChanged(Element element) {
            this.modelNotifier.startTagChanged(element);
            this.updateMinMax(element);
        }

        public void propertyChanged(Node node) {
            this.modelNotifier.propertyChanged(node);
        }

        public boolean isChanging() {
            return this.modelNotifier.isChanging();
        }

        public boolean hasChanged() {
            return this.modelNotifier.hasChanged();
        }

        public void endTagChanged(Element element) {
            this.modelNotifier.endTagChanged(element);
            this.updateMinMax(element);
        }

        public void endChanging() {
            this.modelNotifier.endChanging();
            if (this.min < this.max) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        scheduled = false;
                    }
                };
                if (!this.scheduled) {
                    this.scheduled = true;
                    Display.getDefault().asyncExec(runnable);
                }
            }
        }

        public void editableChanged(Node node) {
            this.modelNotifier.editableChanged(node);
        }

        public void childReplaced(Node parentNode, Node newChild, Node oldChild) {
            if (newChild instanceof IDOMElement) {
                this.updateMinMax((Element)newChild);
            }
            if (oldChild instanceof IDOMElement) {
                this.updateMinMax((Element)oldChild);
            }
            this.modelNotifier.childReplaced(parentNode, newChild, oldChild);
        }

        public void cancelPending() {
            this.modelNotifier.cancelPending();
        }

        public void beginChanging(boolean newModel) {
            this.min = this.document.getLength();
            this.max = 0;
            this.modelNotifier.beginChanging(newModel);
        }

        public void beginChanging() {
            this.min = this.document.getLength();
            this.max = 0;
            this.modelNotifier.beginChanging();
        }

        public void attrReplaced(Element element, Attr newAttr, Attr oldAttr) {
            this.updateMinMax(element);
            this.modelNotifier.attrReplaced(element, newAttr, oldAttr);
        }

        protected void updateMinMax(Element element) {
            IDOMElement e = (IDOMElement)element;
            this.min = Math.min(this.min, e.getStartOffset());
            this.max = Math.max(this.max, e.getEndOffset());
        }
    }
}

