/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.mule.tooling.messageflow.editpart.ICollapsibleEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;

public class ExpandAllContainersAction
extends Action {
    private static final String TOOLTIP_TEXT = "Expand all the flows of the active editor";
    public static final String ID = "org.mule.tooling.messageflow.editor.expandAll";

    public ExpandAllContainersAction() {
        this.setDescription(TOOLTIP_TEXT);
        this.setId(ID);
        this.setText("Expand All");
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_EXPANDALL);
    }

    public void run() {
        MuleConfigurationEditPart muleConfigEditPart = MessageFlowUtils.getFlowEditorFromActivePage().getMuleConfigurationEditPart();
        this.expandFirstLevel((EditPart)muleConfigEditPart);
    }

    private void expandFirstLevel(EditPart editPart) {
        this.expand(editPart, 1);
    }

    private void expand(EditPart editPart, int levels) {
        if (editPart instanceof ICollapsibleEditPart) {
            ((ICollapsibleEditPart)editPart).expand();
        }
        if (levels > 0) {
            List children = editPart.getChildren();
            for (EditPart child : children) {
                this.expand(child, levels - 1);
            }
        }
    }
}

