/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;

public class EntityTemplateTransferDragSourceListener
extends TemplateTransferDragSourceListener {
    private Image iconImage;

    public EntityTemplateTransferDragSourceListener(EditPartViewer viewer) {
        super(viewer);
    }

    public void dragStart(DragSourceEvent event) {
        super.dragStart(event);
        PaletteEntry entry = this.getPaletteEntry();
        if (entry != null) {
            ImageDescriptor icon = entry.getLargeIcon();
            if (icon == null) {
                icon = entry.getSmallIcon();
            }
            if (icon != null) {
                this.iconImage = icon.createImage();
            }
        }
        event.image = this.iconImage;
        event.offsetX = 0;
        event.offsetY = 0;
    }

    public void dragFinished(DragSourceEvent event) {
        super.dragFinished(event);
        if (this.iconImage != null) {
            this.iconImage.dispose();
            this.iconImage = null;
        }
    }

    private PaletteEntry getPaletteEntry() {
        EditPart editpart;
        Object model;
        List selection = this.getViewer().getSelectedEditParts();
        if (selection != null && selection.size() == 1 && (model = (editpart = (EditPart)this.getViewer().getSelectedEditParts().get(0)).getModel()) instanceof PaletteEntry) {
            return (PaletteEntry)model;
        }
        return null;
    }
}

