/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.mule.tooling.messageflow.editor.EntityCellEditorLocator;
import org.mule.tooling.messageflow.editor.EntityDirectEditManager;
import org.mule.tooling.messageflow.editor.EntityTextCellEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.IEntityEditPartRequestHandler;
import org.mule.tooling.messageflow.figure.ContainerFigure;
import org.mule.tooling.messageflow.figure.EntityFigure;
import org.mule.tooling.messageflow.figure.ScopeFigure;
import org.mule.tooling.model.messageflow.MessageFlowNode;

public class DirectEditRequestHandler
implements IEntityEditPartRequestHandler {
    @Override
    public boolean handlesRequestFor(EntityEditPart<?> editPart) {
        if (editPart.getFigure() instanceof EntityFigure) {
            return ((EntityFigure)editPart.getFigure()).hasLabel();
        }
        return false;
    }

    @Override
    public boolean handleReadAccessRequest(EntityEditPart<?> editPart, Request request) {
        EntityFigure figure = (EntityFigure)editPart.getFigure();
        Object requestType = request.getType();
        if (requestType.equals("direct edit") && this.allowsDirectEditing(figure) && this.isRequestInsideLabelBounds(figure.getLabel(), request)) {
            String labelText = figure.getLabelText();
            Figure label = figure.getLabel();
            EntityDirectEditManager manager = new EntityDirectEditManager((GraphicalEditPart)editPart, (Class)EntityTextCellEditor.class, (CellEditorLocator)new EntityCellEditorLocator(label), labelText);
            manager.show();
            return true;
        }
        return false;
    }

    private boolean isRequestInsideLabelBounds(Figure label, Request request) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(label.getBounds());
        label.translateToAbsolute((Translatable)r);
        if (request instanceof DirectEditRequest) {
            Point requestLocation = ((DirectEditRequest)request).getLocation();
            if (requestLocation.y > r.y && requestLocation.y < r.y + r.height && requestLocation.x > r.x && requestLocation.x < r.x + r.width) {
                return true;
            }
        }
        return false;
    }

    public boolean allowsDirectEditing(EntityFigure<?> figure) {
        ScopeFigure scopeFigure;
        if (figure instanceof ScopeFigure && !(scopeFigure = (ScopeFigure)figure).allowsDirectEditing()) {
            scopeFigure.setAllowsDirectEditing(true);
            return false;
        }
        if (figure instanceof ContainerFigure) {
            return ((ContainerFigure)figure).allowsDirectEditing();
        }
        return figure.getEntity() instanceof MessageFlowNode;
    }

    @Override
    public boolean handleWriteAccessRequest(EntityEditPart<?> editPart, Request request, CompoundCommand comand) {
        return false;
    }
}

