/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.model.module.Keyword;

public class DefinitionsHelper {
    private static Set<String> definitionsToSkip = new HashSet<String>();
    private static BiMap<String, String> connectorsAlternatives = HashBiMap.create();

    public static void addDefinitionToSkip(String id, String category) {
        definitionsToSkip.add(DefinitionsHelper.combine(id, category));
    }

    private static String combine(String id, String category) {
        return id + ":" + category;
    }

    public static boolean hasEndpointAlternative(String connectorId) {
        return connectorsAlternatives.containsKey((Object)connectorId);
    }

    public static String getEndpointAlternative(String connectorId) {
        return (String)connectorsAlternatives.get((Object)connectorId);
    }

    public static String getMessageProcessorAlternative(String connectorId) {
        return (String)connectorsAlternatives.inverse().get((Object)connectorId);
    }

    public static void addAlternativeForConnector(String connectorId, String endpointId) {
        connectorsAlternatives.put((Object)connectorId, (Object)endpointId);
    }

    public static boolean hasKeywords(List<Keyword> keywords, String filterString) {
        if (keywords != null) {
            for (Keyword keyword : keywords) {
                if (StringUtils.isEmpty((String)filterString) || filterString.contains(" ") || filterString.length() <= 1 || !keyword.getKeyword().startsWith(filterString.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static int getKeywordWeight(List<Keyword> keywords, String filterString) {
        if (keywords != null) {
            for (Keyword keyword : keywords) {
                if (StringUtils.isEmpty((String)filterString) || filterString.contains(" ") || filterString.length() <= 1 || !keyword.getKeyword().startsWith(filterString.toLowerCase())) continue;
                return keyword.getWeight();
            }
        }
        return 0;
    }
}

