/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.easter;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.messageflow.easter.EasternImages;

public class Board
extends Canvas {
    private int width = 400;
    private int height = 400;
    private final int DOT_SIZE = 10;
    private final int ALL_DOTS = 900;
    private final int RAND_POS = 39;
    private final int DELAY = 120;
    private int[] x = new int[900];
    private int[] y = new int[900];
    private int dots;
    private int apple_x;
    private int apple_y;
    private boolean left = false;
    private boolean right = true;
    private boolean up = false;
    private boolean down = false;
    private boolean inGame = true;
    private static final Image ball = EasternImages.getImageByPath("icons/square.png");
    private static final Image apple = EasternImages.getImageByPath("icons/Mule-16x16.png");
    private Runnable runnable;

    public Board(Composite parent) {
        super(parent, 0);
        this.setSize(this.width, this.height);
        this.addPaintListener(new BoardPaintListener());
        this.addKeyListener((KeyListener)new BoardKeyListener());
        Color col = new Color((Device)this.getShell().getDisplay(), 0, 0, 0);
        this.setBackground(col);
        col.dispose();
        this.initGame(this.getShell().getDisplay());
    }

    public void initGame(final Display display) {
        this.dots = 3;
        int z = 0;
        while (z < this.dots) {
            this.x[z] = 50 - z * 10;
            this.y[z] = 50;
            ++z;
        }
        this.locateApple();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                if (Board.this.inGame) {
                    Board.this.checkApple();
                    Board.this.checkCollision();
                    Board.this.move();
                }
                if (!Board.this.isDisposed()) {
                    display.timerExec(120, (Runnable)this);
                    Board.this.redraw();
                }
            }
        };
        display.syncExec(this.runnable);
    }

    public void drawObjects(PaintEvent e) {
        e.gc.drawImage(apple, this.apple_x, this.apple_y);
        int z = 0;
        while (z < this.dots) {
            e.gc.drawImage(ball, this.x[z], this.y[z]);
            ++z;
        }
    }

    public void gameOver(PaintEvent e) {
        String msg = "Game Over";
        Font font = new Font((Device)e.display, "Helvetica", 12, 0);
        Color white = new Color((Device)this.getShell().getDisplay(), 255, 255, 255);
        Point size = e.gc.textExtent(msg);
        e.gc.setForeground(white);
        e.gc.setFont(font);
        e.gc.drawText(msg, (this.width - size.x) / 2, (this.height - size.y) / 2);
        font.dispose();
        white.dispose();
        e.gc.dispose();
    }

    public void checkApple() {
        if (this.x[0] == this.apple_x && this.y[0] == this.apple_y) {
            ++this.dots;
            this.locateApple();
        }
    }

    public void move() {
        int z = this.dots;
        while (z > 0) {
            this.x[z] = this.x[z - 1];
            this.y[z] = this.y[z - 1];
            --z;
        }
        if (this.left) {
            this.x[0] = this.x[0] - 10;
        }
        if (this.right) {
            this.x[0] = this.x[0] + 10;
        }
        if (this.up) {
            this.y[0] = this.y[0] - 10;
        }
        if (this.down) {
            this.y[0] = this.y[0] + 10;
        }
    }

    public void checkCollision() {
        int z = this.dots;
        while (z > 0) {
            if (z > 4 && this.x[0] == this.x[z] && this.y[0] == this.y[z]) {
                this.inGame = false;
            }
            --z;
        }
        if (this.y[0] > this.height - 10) {
            this.inGame = false;
        }
        if (this.y[0] < 0) {
            this.inGame = false;
        }
        if (this.x[0] > this.width - 10) {
            this.inGame = false;
        }
        if (this.x[0] < 0) {
            this.inGame = false;
        }
    }

    public void locateApple() {
        int r = (int)(Math.random() * 39.0);
        this.apple_x = r * 10;
        r = (int)(Math.random() * 39.0);
        this.apple_y = r * 10;
    }

    private class BoardKeyListener
    extends KeyAdapter {
        private BoardKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int key = e.keyCode;
            if (key == 0x1000003 && !Board.this.right) {
                Board.this.left = true;
                Board.this.up = false;
                Board.this.down = false;
            }
            if (key == 0x1000004 && !Board.this.left) {
                Board.this.right = true;
                Board.this.up = false;
                Board.this.down = false;
            }
            if (key == 0x1000001 && !Board.this.down) {
                Board.this.up = true;
                Board.this.right = false;
                Board.this.left = false;
            }
            if (key == 0x1000002 && !Board.this.up) {
                Board.this.down = true;
                Board.this.right = false;
                Board.this.left = false;
            }
        }
    }

    private class BoardPaintListener
    implements PaintListener {
        private BoardPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            Color col = new Color((Device)Board.this.getShell().getDisplay(), 0, 0, 0);
            e.gc.setBackground(col);
            col.dispose();
            e.gc.setAntialias(1);
            if (Board.this.inGame) {
                Board.this.drawObjects(e);
            } else {
                Board.this.gameOver(e);
            }
            e.gc.dispose();
        }
    }
}

