/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.messageflow.dialog.FlowDocumentationPage;
import org.mule.tooling.messageflow.dialog.IHost;
import org.mule.tooling.messageflow.dialog.IMessageDisplay;
import org.mule.tooling.messageflow.module.CustomPageComposite;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.widgets.IItem;
import org.mule.tooling.ui.widgets.tab.IItemContainer;

public class PageHost
implements IHost {
    private List<MessageFlowNodeComposite> pages;
    private IMessageFlowNode node;
    private IMessageDisplay dlg;
    protected IItemContainer folder;
    protected HashMap<String, PropertyCollectionMap> tempMaps = new HashMap();

    public PageHost(IMessageDisplay dlg, IMessageFlowNode node, IItemContainer tabs, List<MessageFlowNodeComposite> contributedPages) {
        this.folder = tabs;
        this.dlg = dlg;
        this.node = node;
        this.pages = contributedPages;
    }

    @Override
    public void retainFrom(Set<String> keySet) {
        IItem[] iItemArray = this.folder.getItems();
        int n = iItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItem tabItem = iItemArray[n2];
            if (!(tabItem.getControl() instanceof CustomPageComposite || this.getNode().getName().equals("Transactional") || keySet.contains(tabItem.getText()))) {
                Control control = tabItem.getControl();
                this.pageRemove(tabItem.getText(), control);
                tabItem.dispose();
                control.dispose();
            }
            ++n2;
        }
    }

    protected void pageRemove(String name, Control control) {
        Composite sc = (Composite)control;
        MessageFlowNodeComposite mc = (MessageFlowNodeComposite)sc.getChildren()[0];
        PropertyCollectionMap props = new PropertyCollectionMap();
        mc.saveTo(this.node, props);
        this.tempMaps.put(name, props);
        this.pages.remove((Object)mc);
    }

    private void pageAdd(MessageFlowNodeComposite ps) {
        this.pages.add(ps);
    }

    @Override
    public Collection<String> getNotExitingPages(Set<String> keySet) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(keySet);
        IItem[] iItemArray = this.folder.getItems();
        int n = iItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItem tabItem = iItemArray[n2];
            String text = tabItem.getText();
            result.remove(text);
            ++n2;
        }
        return result;
    }

    @Override
    public Composite createBlankControl() {
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.folder.getContentContainer(), 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        return scrolledComposite;
    }

    @Override
    public void addPage(String name, MessageFlowNodeComposite nodeComposite) {
        if (!nodeComposite.compliesVersion(nodeComposite.getMuleProject().getServerDefinition().getVersionWithEESign())) {
            return;
        }
        IItem[] items = this.folder.getItems();
        int position = items.length;
        int index = 0;
        while (index < items.length) {
            if (items[index].getControl() instanceof CustomPageComposite) {
                position = index;
                break;
            }
            if (items[index].getControl() instanceof FlowDocumentationPage) {
                position = index;
                break;
            }
            ++index;
        }
        IItem item = this.folder.createNewItem(0, position);
        item.setText(name);
        ScrolledComposite scrolledComposite = (ScrolledComposite)nodeComposite.getParent();
        scrolledComposite.setContent((Control)nodeComposite);
        Point panelSize = scrolledComposite.computeSize(-1, -1);
        scrolledComposite.setMinSize(-1, panelSize.y);
        item.setControl((Control)scrolledComposite);
        this.folder.refreshItems();
        this.pageAdd(nodeComposite);
        PropertyCollectionMap propertyCollectionMap = this.tempMaps.get(name);
        if (propertyCollectionMap == null) {
            propertyCollectionMap = new PropertyCollectionMap(this.node.getProperties());
        }
        nodeComposite.loadFrom(this.node, propertyCollectionMap);
    }

    @Override
    public MessageFlowNodeComposite getPage(String s) {
        IItem[] iItemArray = this.folder.getItems();
        int n = iItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItem tabItem = iItemArray[n2];
            if (!(tabItem.getControl() instanceof CustomPageComposite) && tabItem.getText().equals(s)) {
                ScrolledComposite control = (ScrolledComposite)tabItem.getControl();
                return (MessageFlowNodeComposite)control.getContent();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IMessageFlowNode getNode() {
        return this.node;
    }

    @Override
    public void setMessages(List<Message> messages) {
        this.dlg.setMessages(messages);
    }

    @Override
    public Composite[] getAllPages() {
        ArrayList<Composite> rs = new ArrayList<Composite>();
        if (this.folder.getContentContainer().isDisposed()) {
            return new Composite[0];
        }
        IItem[] iItemArray = this.folder.getItems();
        int n = iItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItem tabItem = iItemArray[n2];
            if (!(tabItem.getControl() instanceof CustomPageComposite)) {
                if (tabItem.getControl() instanceof ScrolledComposite) {
                    ScrolledComposite control = (ScrolledComposite)tabItem.getControl();
                    rs.add((Composite)control.getContent());
                } else {
                    rs.add((Composite)tabItem.getControl());
                }
            }
            ++n2;
        }
        return rs.toArray(new Composite[rs.size()]);
    }

    @Override
    public void setMessage(String description) {
        this.setMessages(Collections.singletonList(MessageBuilder.newErrorMessage((String)description).build()));
    }

    public void removePage(MessageFlowNodeComposite page) {
        IItem[] iItemArray = this.folder.getItems();
        int n = iItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItem item = iItemArray[n2];
            if (item.getText().equals(page.getName())) {
                item.dispose();
            }
            ++n2;
        }
    }

    @Override
    public List<MessageFlowNodeComposite> getContributedPages() {
        return this.pages;
    }
}

