/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.messageflow.module.CustomPageComposite;
import org.mule.tooling.messageflow.module.ICustomPage;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.widgets.IMessageLogger;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class NodeDocumentationPage
implements ICustomPage {
    private static final String NOTES_DESCRPIPTION = "Global element documentation";
    private static final String NOTES_TITLE = "Notes";
    private String value;
    private Text txtDescription;
    private Group docGroup;

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.value = StringUtils.defaultString((String)node.getDescription());
        if (this.txtDescription != null) {
            this.updateTextFieldFromValue();
        }
    }

    public void updateTextFieldFromValue() {
        this.txtDescription.setText(StringUtils.defaultString((String)this.value));
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap updated) {
        if (StringUtils.isEmpty((String)node.getDescription()) && StringUtils.isEmpty((String)this.value)) {
            return;
        }
        node.setDescription(this.value);
    }

    @Override
    public String getTitle() {
        return NOTES_TITLE;
    }

    @Override
    public String getDescription() {
        return NOTES_DESCRPIPTION;
    }

    @Override
    public boolean accepts(IMessageFlowNode node) {
        return node.getDefinition().getAllowsDescription();
    }

    @Override
    public CustomPageComposite createControl(Composite parent) {
        final CustomPageComposite documentionPage = new CustomPageComposite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        documentionPage.setLayout((Layout)layout);
        documentionPage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (NodeDocumentationPage.this.txtDescription == null) {
                    NodeDocumentationPage.this.createContent(documentionPage);
                }
            }
        });
        return documentionPage;
    }

    private void createContent(Composite parent) {
        this.docGroup = new Group(parent, 0);
        GridLayout docLayout = new GridLayout(1, false);
        docLayout.horizontalSpacing = 10;
        this.docGroup.setLayout((Layout)docLayout);
        this.docGroup.setLayoutData((Object)new GridData(1808));
        Label descLabel = new Label((Composite)this.docGroup, 0);
        descLabel.setText("Use this area to document all the relevant information related to this element");
        descLabel.setLayoutData((Object)new GridData(2));
        this.txtDescription = new Text((Composite)this.docGroup, 2114);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NodeDocumentationPage.this.value = NodeDocumentationPage.this.txtDescription.getText();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = 250;
        this.txtDescription.setLayoutData((Object)data);
        this.txtDescription.setTextLimit(1000);
        this.updateTextFieldFromValue();
        parent.layout(true, true);
        ThemeUtils.setCssId((Object)parent, (String)"notesDocumentationPage");
    }

    @Override
    public void setMessageLogger(IMessageLogger messageLogger) {
    }
}

