/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.messageflow.dialog.DialogConstants;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.IKnowsVersionRange;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.widgets.search.SearchTextField;

public class GlobalTypeChooser
extends TitleAreaDialog {
    private TreeViewer typesTree;
    private GlobalDefinition selected;
    private String version;
    private String filterText = "";
    private boolean expansionInitialState;
    private ITreeContentProvider contentProvider;
    private List<CategoryDefinition> globalTreeCategories;

    public GlobalTypeChooser(Shell parentShell, IMuleProject project) {
        this(parentShell, project, false);
    }

    public GlobalTypeChooser(Shell parentShell, IMuleProject project, boolean expandTreeBranches) {
        super(parentShell);
        IServerDefinition serverDefinition = project.getServerDefinition();
        if (serverDefinition != null) {
            this.version = serverDefinition.getVersionWithEESign();
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.expansionInitialState = expandTreeBranches;
        this.globalTreeCategories = MuleCorePlugin.getModuleManager().getGlobalCategories(this.version);
        this.contentProvider = new GlobalsContentProvider(this.globalTreeCategories);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(DialogConstants.MINIMUM_DIALOG_SIZE);
        this.setTitle("Choose Global Type");
        this.setMessage("Choose the type of global element to create.");
        Composite con = new Composite(parent, 0);
        con.setLayout((Layout)new GridLayout(2, false));
        Label ls = new Label(con, 0);
        ls.setText("Filter:");
        SearchTextField ts = new SearchTextField(con, "Search");
        ts.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    GlobalTypeChooser.this.selectFirstTreeElement(GlobalTypeChooser.this.typesTree);
                }
            }
        });
        ts.addTraverseListener(event -> {
            if (event.keyCode == 9) {
                this.selectFirstTreeElement(this.typesTree);
            }
        });
        ts.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        con.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.typesTree = new TreeViewer(parent);
        this.typesTree.setContentProvider((IContentProvider)this.contentProvider);
        this.typesTree.setLabelProvider((IBaseLabelProvider)new GlobalsLabelProvider());
        this.typesTree.setInput(this.globalTreeCategories);
        this.typesTree.getTree().setLayoutData((Object)new GridData(1808));
        this.typesTree.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object currentSelection = selection.getFirstElement();
            if (currentSelection != null && !(currentSelection instanceof CategoryDefinition)) {
                this.okPressed();
            }
        });
        this.typesTree.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object currentSelection = selection.getFirstElement();
            if (currentSelection != null) {
                boolean enabled = !(currentSelection instanceof CategoryDefinition);
                this.getButton(0).setEnabled(enabled);
            }
        });
        this.typesTree.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof CategoryDefinition) {
                    Object[] children;
                    CategoryDefinition ds = (CategoryDefinition)element;
                    TreeViewer tv = (TreeViewer)viewer;
                    ITreeContentProvider p = (ITreeContentProvider)tv.getContentProvider();
                    Object[] objectArray = children = p.getChildren(element);
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (this.select(viewer, ds, o)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                if (element instanceof NodeDefinition) {
                    String filterLowerCase;
                    NodeDefinition d = (NodeDefinition)element;
                    String defName = d.getName().toLowerCase();
                    if (defName.startsWith(filterLowerCase = GlobalTypeChooser.this.filterText.toLowerCase())) {
                        return true;
                    }
                    String[] defNameWords = null;
                    defName = defName.replace('(', ' ');
                    defName = defName.replace(')', ' ');
                    defName = defName.replace('[', ' ');
                    defNameWords = (defName = defName.replace(']', ' ')).contains(" ") ? defName.split(" ") : new String[]{defName};
                    String[] stringArray = defNameWords;
                    int n = defNameWords.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String word = stringArray[n3];
                        if (word.startsWith(filterLowerCase)) {
                            return true;
                        }
                        ++n3;
                    }
                }
                return false;
            }
        });
        this.addionalFilters(this.typesTree);
        ts.addModifyListener(arg_0 -> this.lambda$3((Text)ts, arg_0));
        ts.addSelectionListener(new SelectionListener((Text)ts){
            private final /* synthetic */ Text val$ts;
            {
                this.val$ts = text;
            }

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    this.val$ts.setText("");
                    GlobalTypeChooser.this.filterText = "";
                    GlobalTypeChooser.this.typesTree.refresh();
                    GlobalTypeChooser.this.typesTree.collapseAll();
                }
            }
        });
        this.expandIfNeeded();
        return this.typesTree.getControl();
    }

    public final List<CategoryDefinition> getGlobalTreeCategories() {
        return this.globalTreeCategories;
    }

    public final Object[] getContent(Object input) {
        return this.contentProvider.getElements(input);
    }

    public void selectFirstTreeElement(TreeViewer typesTree) {
        Tree tree = (Tree)typesTree.getControl();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setSelection(item);
            tree.setFocus();
        }
    }

    protected void addionalFilters(TreeViewer typesTree2) {
    }

    protected Point getInitialSize() {
        return DialogConstants.STANDARD_DIALOG_SIZE;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Choose Global Type");
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.typesTree.getSelection();
        Object currentSelection = selection.getFirstElement();
        if (currentSelection instanceof GlobalDefinition) {
            GlobalDefinition def = (GlobalDefinition)currentSelection;
            AnalyticsRecordsFactory.single((String)Events.ADD_GLOBAL_ELEMENT, (String[])new String[]{"globalElementTypeName", def.getName(), "globalElementTypeId", def.getId()}).track();
            this.selected = def;
            super.okPressed();
        }
    }

    public GlobalDefinition getSelected() {
        return this.selected;
    }

    private void expandIfNeeded() {
        if (StringUtils.isBlank((String)this.filterText)) {
            if (!this.expansionInitialState) {
                this.typesTree.collapseAll();
            } else {
                this.typesTree.expandAll();
            }
        } else {
            this.typesTree.expandAll();
        }
    }

    public TreeViewer getTypesTree() {
        return this.typesTree;
    }

    private /* synthetic */ void lambda$3(Text text, ModifyEvent event) {
        this.filterText = text.getText();
        this.typesTree.refresh();
        this.expandIfNeeded();
    }

    private class GlobalsContentProvider
    implements ITreeContentProvider {
        private List<CategoryDefinition> globalCategories;

        public GlobalsContentProvider(List<CategoryDefinition> globalCategories) {
            this.globalCategories = globalCategories;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashSet<String> di = new HashSet<String>();
            if (inputElement instanceof Collection) {
                Collection items = (Collection)inputElement;
                ArrayList rs = new ArrayList();
                for (Object o : items) {
                    NodeDefinition d;
                    if (o instanceof NodeDefinition) {
                        d = (NodeDefinition)o;
                        IKnowsVersionRange service = (IKnowsVersionRange)d.getService(IKnowsVersionRange.class);
                        if (service != null && !service.supported(GlobalTypeChooser.this.version)) continue;
                        String id = d.getId();
                        int indexOf = id.indexOf(59);
                        if (indexOf != -1) {
                            id = id.substring(0, indexOf);
                        }
                        if (!di.add(id)) continue;
                    }
                    if (o instanceof CategoryDefinition && (d = (CategoryDefinition)o).getParentCategory() != null) continue;
                    rs.add(o);
                }
                return rs.toArray();
            }
            if (inputElement instanceof CategoryDefinition) {
                CategoryDefinition category = (CategoryDefinition)inputElement;
                List globalDefinitions = MuleCorePlugin.getModuleManager().getGlobalDefinitionsForPaletteCategory(category.getId(), GlobalTypeChooser.this.version);
                ArrayList<Object> rs = new ArrayList<Object>();
                HashMap<String, CategoryDefinition> ds = new HashMap<String, CategoryDefinition>();
                for (CategoryDefinition globalCategoryDefinition : this.globalCategories) {
                    ds.put(globalCategoryDefinition.getId(), globalCategoryDefinition);
                }
                for (GlobalDefinition globalDefinition : globalDefinitions) {
                    IKnowsVersionRange service = (IKnowsVersionRange)globalDefinition.getService(IKnowsVersionRange.class);
                    if (service != null && !service.supported(GlobalTypeChooser.this.version)) continue;
                    String id = globalDefinition.getId();
                    int indexOf = id.indexOf(59);
                    if (indexOf != -1) {
                        id = id.substring(0, indexOf);
                    }
                    if (!di.add(id)) continue;
                    CategoryDefinition categoryDefinition = (CategoryDefinition)ds.get(globalDefinition.getPaletteCategoryId());
                    if (categoryDefinition.getParentCategory() == null) {
                        rs.add(globalDefinition);
                        continue;
                    }
                    if (!categoryDefinition.equals(category)) continue;
                    rs.add(globalDefinition);
                }
                for (CategoryDefinition d : this.globalCategories) {
                    if (d.getParentCategory() == null || !d.getParentCategory().equals(category.getId())) continue;
                    rs.add(d);
                }
                return rs.toArray(new Object[rs.size()]);
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof GlobalDefinition) {
                GlobalDefinition def = (GlobalDefinition)element;
                return MuleCorePlugin.getModuleManager().getGlobalDefinition(def.getCategoryId());
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children.length > 0;
        }
    }

    private class GlobalsLabelProvider
    extends LabelProvider {
        private GlobalsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CategoryDefinition) {
                CategoryDefinition cat = (CategoryDefinition)element;
                return cat.getImage();
            }
            if (element instanceof GlobalDefinition) {
                GlobalDefinition def = (GlobalDefinition)element;
                return def.getIconImage();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof CategoryDefinition) {
                CategoryDefinition def = (CategoryDefinition)element;
                return def.getName();
            }
            if (element instanceof GlobalDefinition) {
                GlobalDefinition def = (GlobalDefinition)element;
                Object globalDefName = def.getName();
                IKnowsVersionRange service = (IKnowsVersionRange)def.getService(IKnowsVersionRange.class);
                if (service != null && service.isDeprecatedIn(GlobalTypeChooser.this.version)) {
                    globalDefName = (String)globalDefName + " (Deprecated)";
                }
                return globalDefName;
            }
            return super.getText(element);
        }
    }
}

