/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.ILayoutPropertiesEditorRequested;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.messageflow.Activator;
import org.mule.tooling.messageflow.action.TestConnectorConnectionFromMuleConfigAction;
import org.mule.tooling.messageflow.dialog.DialogConstants;
import org.mule.tooling.messageflow.dialog.DialogStack;
import org.mule.tooling.messageflow.dialog.HelpSystemConnector;
import org.mule.tooling.messageflow.dialog.ICanBeCancelled;
import org.mule.tooling.messageflow.dialog.IDialogController;
import org.mule.tooling.messageflow.dialog.IHostAware;
import org.mule.tooling.messageflow.dialog.IMessageDisplay;
import org.mule.tooling.messageflow.dialog.PageHost;
import org.mule.tooling.messageflow.dialog.TabFolderItemContainerAdaptor;
import org.mule.tooling.messageflow.editor.CustomPageManager;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.module.CustomPageComposite;
import org.mule.tooling.messageflow.module.ICustomPage;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.HTMLUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.IMuleConfigurationProvider;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PropertyPageDefinition;
import org.mule.tooling.ui.utils.DelayedRunnableScheduler;
import org.mule.tooling.ui.widgets.tab.IItemContainer;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.osgi.framework.Bundle;

public class GlobalElementDialog
extends TitleAreaDialog
implements IMessageDisplay {
    private static final String HELP_TAB_TITLE = "Help";
    private IMuleProject project;
    private GlobalElement global;
    private GlobalDefinition definition;
    private PropertyCollectionMap updatedProperties;
    private PropertyCollectionMap propertiesBeforeSave;
    private CTabFolder tabs;
    private List<MessageFlowNodeComposite> contributedPages = new ArrayList<MessageFlowNodeComposite>();
    private final IMuleConfigurationProvider muleConfigurationProvider;
    private static boolean creatingGlobalDialog = false;
    private Map<String, String> meta = null;
    private List<ICustomPage> customPages;
    private EventBusHelper busHelper = new EventBusHelper();
    private DelayedRunnableScheduler relayoutRequestScheduler = new DelayedRunnableScheduler(10);

    public GlobalElementDialog(Shell parentShell, IMuleProject project, GlobalElement global, IMuleConfigurationProvider muleConfigurationProvider) {
        super(parentShell);
        this.project = project;
        this.global = global;
        this.meta = this.extractMeta();
        this.muleConfigurationProvider = muleConfigurationProvider;
        this.definition = (GlobalDefinition)global.getDefinition();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public static boolean isCreatingGlobalDialog() {
        return creatingGlobalDialog;
    }

    private Map<String, String> extractMeta() {
        HashMap<String, String> ms = new HashMap<String, String>();
        IReadOnlyPropertyCollection properties = this.global.getProperties();
        if (properties == null) {
            return ms;
        }
        for (IReadOnlyProperty p : properties.getProperties()) {
            if (!p.getName().startsWith("auxiliary;meta")) continue;
            ms.put(p.getName(), p.getValue());
        }
        if (ms.isEmpty()) {
            return null;
        }
        return ms;
    }

    private static boolean hasMeta(PropertyCollectionMap props) {
        for (Property p : props.getPropertiesMap().asPropertyList()) {
            if (!p.getName().startsWith("auxiliary;meta")) continue;
            return true;
        }
        return false;
    }

    private void addMeta(PropertyCollectionMap props) {
        if (props != null && !GlobalElementDialog.hasMeta(props) && this.meta != null) {
            for (Map.Entry<String, String> entry : this.meta.entrySet()) {
                props.addProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Point getInitialSize() {
        return DialogConstants.STANDARD_DIALOG_SIZE;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Global Element Properties");
    }

    protected Control createDialogArea(Composite parent) {
        String id = this.definition.getId();
        parent.setBackgroundMode(2);
        Point minimumSize = this.getMinimumSize(id);
        this.getShell().setMinimumSize(minimumSize);
        this.setTitle(this.definition.getName());
        this.setMessage(HTMLUtils.removeHtmlTags(this.definition.getDescription()));
        HelpSystemConnector.connect(parent, (NodeDefinition)this.definition);
        final Composite main = (Composite)super.createDialogArea(parent);
        Composite nested = new Composite(main, 0);
        GridLayout layout = new GridLayout(1, false);
        nested.setLayout((Layout)layout);
        nested.setLayoutData((Object)new GridData(1808));
        nested.setLayoutDeferred(true);
        try {
            creatingGlobalDialog = true;
            this.tabs = new CTabFolder(nested, 0);
            this.tabs.setBorderVisible(true);
            this.tabs.setLayoutData((Object)new GridData(1808));
            GlobalElementPageHost host = new GlobalElementPageHost(this, (MessageFlowNode)this.getGlobalElement(), new TabFolderItemContainerAdaptor(this.tabs), this.contributedPages);
            DialogStack.register(host);
            this.tabs.addDisposeListener((DisposeListener)new GlobalElementDialogDisposeListener(host));
            List propertyPageDefinitions = this.definition.getPropertyPages((Object)this.project);
            for (PropertyPageDefinition pageDefinition : propertyPageDefinitions) {
                try {
                    MessageFlowNodeComposite page = this.createPage(host, pageDefinition);
                    this.contributedPages.add(page);
                }
                catch (Exception e) {
                    Activator.openError(this.getShell(), e);
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.messageflow", "Unable to create property page.", (Throwable)e));
                }
            }
            this.createCustomTabs();
            this.forceReloadOfPages();
            this.loadCustomTabs();
            if (!this.contributedPages.isEmpty()) {
                this.tabs.setSelection(0);
            }
        }
        finally {
            creatingGlobalDialog = false;
            this.tabs.setVisible(true);
            nested.setLayoutDeferred(false);
            nested.layout(true);
        }
        this.busHelper.unregisterWith((Widget)main);
        this.busHelper.registerListener(UtilsPlugin.getEventBus(), CoreEventTypes.LAYOUT_PROPERTIES_EDITOR_REQUEST, (IEventHandler)new ILayoutPropertiesEditorRequested(){

            public void onLayoutRequested() {
                GlobalElementDialog.this.relayoutRequestScheduler.schedule(() -> {
                    if (!main.isDisposed()) {
                        main.layout(true, true);
                    }
                });
            }
        });
        this.buildPropertiesBeforeEdition();
        return main;
    }

    private void forceReloadOfPages() {
        int lastIndex = 0;
        MessageFlowNodeComposite current = this.contributedPages.isEmpty() ? null : this.contributedPages.get(lastIndex);
        while (current != null) {
            if (!current.isDisposed()) {
                current.loadFrom((IMessageFlowNode)this.getGlobalElement(), new PropertyCollectionMap(this.getGlobalElement().getProperties()));
            }
            current = this.contributedPages.contains((Object)current) && this.contributedPages.size() > lastIndex + 1 ? this.contributedPages.get(++lastIndex) : (!this.contributedPages.contains((Object)current) && this.contributedPages.size() > lastIndex ? this.contributedPages.get(lastIndex) : null);
        }
    }

    private Point getMinimumSize(String id) {
        Point minimumSize = DialogConstants.MINIMUM_DIALOG_SIZE;
        if (id.contains("httpsConnector") || id.contains("httpConnector") || id.contains("httpPolling") || id.contains("httpsPolling") || id.equals("http://www.mulesoft.org/schema/mule/http/connector") || id.equals("http://www.mulesoft.org/schema/mule/http/polling-connector") || id.equals("http://www.mulesoft.org/schema/mule/https/connector") || id.equals("http://www.mulesoft.org/schema/mule/https/polling-connector") || id.equals("http://www.mulesoft.org/schema/mule/sockets/request-config") || id.equals("http://www.mulesoft.org/schema/mule/salesforce/sfdc-config")) {
            minimumSize = new Point(Math.round(1.7f * (float)minimumSize.x), minimumSize.y);
        }
        return minimumSize;
    }

    private void buildPropertiesBeforeEdition() {
        PropertyCollectionMap properties = this.getProperties();
        this.setUpdatePropertiesBeforeSaved(properties);
    }

    protected MessageFlowNodeComposite createPage(PageHost host, PropertyPageDefinition pageDefinition) throws Exception {
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.tabs, 512);
        ThemeUtils.setCssClass((Object)scrolledComposite, (String)"GlobalElementsDialog");
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        pageDefinition.setMuleConfigurationProvider(this.getMuleConfigurationProvider());
        MessageFlowNodeComposite page = (MessageFlowNodeComposite)pageDefinition.create(null, (Object)this.project, (Composite)scrolledComposite);
        if (page instanceof IHostAware) {
            IHostAware hh = (IHostAware)((Object)page);
            hh.setHost(host);
        }
        scrolledComposite.setContent((Control)page);
        Point panelSize = page.computeSize(-1, -1);
        scrolledComposite.setMinSize(-1, panelSize.y);
        CTabItem item = new CTabItem(this.tabs, 0);
        item.setText(pageDefinition.getName());
        item.setToolTipText(pageDefinition.getDescription());
        item.setControl((Control)scrolledComposite);
        return page;
    }

    private void createCustomTabs() {
        this.customPages = new CustomPageManager().getCustomPages((IMessageFlowNode)this.getGlobalElement(), this.project);
        this.customPages.sort((o1, o2) -> {
            int order = o1.getPosition().compareTo(o2.getPosition());
            return order != 0 ? order : o1.getTitle().compareTo(o2.getTitle());
        });
        for (ICustomPage customPage : this.customPages) {
            CTabItem item = new CTabItem(this.tabs, 0);
            item.setText(customPage.getTitle());
            item.setToolTipText(customPage.getDescription());
            CustomPageComposite pageControl = customPage.createControl((Composite)this.tabs);
            item.setControl((Control)pageControl);
        }
    }

    private void loadCustomTabs() {
        for (ICustomPage customPage : this.customPages) {
            customPage.loadFrom((IMessageFlowNode)this.getGlobalElement(), new PropertyCollectionMap(this.getGlobalElement().getProperties()));
        }
    }

    protected void okPressed() {
        PropertyCollectionMap updated = this.getProperties();
        IDialogController service = (IDialogController)this.definition.getService(IDialogController.class);
        if (service != null) {
            MuleConfiguration muleConfiguration = this.getMuleConfigurationProvider() != null ? this.getMuleConfigurationProvider().getMuleConfiguration() : null;
            boolean doUpdate = service.doUpdate(DialogStack.getAllHosts()[0], updated, (NodeDefinition)this.definition, this.project, muleConfiguration);
            if (!doUpdate) {
                return;
            }
        }
        this.setUpdatedProperties(updated);
        super.okPressed();
    }

    private PropertyCollectionMap getProperties() {
        PropertyCollectionMap updated = new PropertyCollectionMap();
        for (ICustomPage customPage : this.customPages) {
            customPage.saveTo((IMessageFlowNode)this.getGlobalElement(), updated);
        }
        for (MessageFlowNodeComposite current : this.contributedPages) {
            current.saveTo((IMessageFlowNode)this.getGlobalElement(), updated);
        }
        return updated;
    }

    public PropertyCollectionMap getPropertiesBeforeSave() {
        return this.propertiesBeforeSave;
    }

    protected void cancelPressed() {
        for (MessageFlowNodeComposite current : this.contributedPages) {
            if (!(current instanceof ICanBeCancelled)) continue;
            ((ICanBeCancelled)((Object)current)).rollback();
        }
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Bundle bundle = Platform.getBundle((String)"org.mule.tooling.ui.modules.core");
        try {
            Class metadataHelpersClass = bundle.loadClass("org.mule.tooling.ui.modules.core.metadata.MetadataHelpers");
            Method method = metadataHelpersClass.getMethod("isTesteable", MessageFlowNode.class);
            Object isTesteable = method.invoke(null, this.getGlobalElement());
            MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
            if (((Boolean)isTesteable).booleanValue() && flowEditorFromActivePage != null) {
                Method getTestButtonLabelMethod = metadataHelpersClass.getMethod("getTestButtonLabel", MessageFlowNode.class);
                Object label = getTestButtonLabelMethod.invoke(null, this.getGlobalElement());
                this.createConnectionButton(parent, label != null ? (String)label : "Test Connection...");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            MuleCorePlugin.logError((String)("Cannot add Test information to connector edior for global element " + String.valueOf(this.getGlobalElement()) != null ? this.getGlobalElement().getName() : null), (Throwable)e);
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createConnectionButton(Composite parent, String title) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button testConnectionButton = new Button(parent, 8);
        testConnectionButton.setText(title);
        GridDataFactory.fillDefaults().align(1, 0x1000000).hint(-1, -1).grab(false, true).applyTo((Control)testConnectionButton);
        testConnectionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MuleConfiguration muleConfiguration = Optional.ofNullable(GlobalElementDialog.this.muleConfigurationProvider.getMuleConfiguration()).orElseGet(() -> (MuleConfiguration)MessageFlowUtils.getFlowEditorFromActivePage().getModelRoot().getEntity());
                TestConnectorConnectionFromMuleConfigAction testConnectorConnectionAction = new TestConnectorConnectionFromMuleConfigAction(GlobalElementDialog.this.project, muleConfiguration, (MessageFlowNode)GlobalElementDialog.this.getGlobalElement(), GlobalElementDialog.this.contributedPages);
                if (testConnectorConnectionAction.isEnabled()) {
                    testConnectorConnectionAction.run();
                } else {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Test connection not enabled", (String)"Test connection for this element is not enabled.");
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    protected GlobalElement getGlobalElement() {
        return this.global;
    }

    public void setUpdatedProperties(PropertyCollectionMap updatedProperties) {
        this.addMeta(updatedProperties);
        this.updatedProperties = updatedProperties;
    }

    public PropertyCollectionMap getUpdatedProperties() {
        return this.updatedProperties;
    }

    private void setUpdatePropertiesBeforeSaved(PropertyCollectionMap updatedProperties) {
        this.addMeta(updatedProperties);
        this.propertiesBeforeSave = updatedProperties;
    }

    protected Control createHelpControl(Composite parent) {
        Control createHelpControl = super.createHelpControl(parent);
        if (createHelpControl instanceof ToolBar) {
            final ToolBar t = (ToolBar)createHelpControl;
            this.tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTabItem item = (CTabItem)e.item;
                    if (!item.getText().equals(GlobalElementDialog.HELP_TAB_TITLE)) {
                        t.getItem(0).setSelection(false);
                    } else {
                        t.getItem(0).setSelection(true);
                    }
                }
            });
            t.getItem(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTabItem[] items;
                    CTabItem[] cTabItemArray = items = GlobalElementDialog.this.tabs.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CTabItem cTabItem = cTabItemArray[n2];
                        if (cTabItem.getText().equals(GlobalElementDialog.HELP_TAB_TITLE)) {
                            GlobalElementDialog.this.tabs.setSelection(cTabItem);
                        }
                        ++n2;
                    }
                }
            });
        }
        return createHelpControl;
    }

    public IMuleConfigurationProvider getMuleConfigurationProvider() {
        return this.muleConfigurationProvider;
    }

    @Override
    public void setMessages(List<Message> messages) {
    }

    private static class GlobalElementDialogDisposeListener
    implements DisposeListener {
        private final PageHost host;

        private GlobalElementDialogDisposeListener(PageHost host) {
            this.host = host;
        }

        public void widgetDisposed(DisposeEvent e) {
            DialogStack.unregister(this.host);
        }
    }

    private final class GlobalElementPageHost
    extends PageHost {
        private GlobalElementPageHost(IMessageDisplay dlg, MessageFlowNode node, IItemContainer tabs, List<MessageFlowNodeComposite> contributedPages) {
            super(dlg, (IMessageFlowNode)node, tabs, contributedPages);
        }

        @Override
        public void setMessages(List<Message> errorMessages) {
            Button okButton = GlobalElementDialog.this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(this.shouldEnableOkButton(errorMessages));
            }
            super.setMessages(errorMessages);
        }

        private boolean shouldEnableOkButton(List<Message> errorMessages) {
            return errorMessages.isEmpty() || errorMessages.stream().anyMatch(this::shouldEnableOkButton);
        }

        private boolean shouldEnableOkButton(Message errorMessage) {
            return CoreUtils.equalsNone((Object)errorMessage.getMessage(), (Object[])new Object[]{"Id should be unique", "Name should be unique", "Attribute 'name' is required", "Name should not be empty"});
        }
    }
}

