/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;

public class FlowNameValidator {
    private static final String[] INVALID_CHARACTERS = new String[]{"/", "[", "]", "{", "}", "#"};
    public static final String FLOW_NAME_SHOULD_BE_UNIQUE = "Flow name should be unique";
    public static final String FLOW_NAME_SHOULD_NOT_CONTAIN_INVALID_CHARACTERS = "Flow name should not contain " + String.join((CharSequence)", ", INVALID_CHARACTERS);

    public static String validate(Object value, AttributeContext context) {
        if (context == null) {
            return null;
        }
        final String currentFlowName = value.toString();
        ArrayList<Container> flows = new ArrayList<Container>(context.getFlows());
        if (currentFlowName != null && !currentFlowName.isEmpty()) {
            FlowNameValidator.inplaceRemove(flows, new Pred<Container>(){

                @Override
                public boolean eval(Container flow) {
                    return currentFlowName.equals(flow.getName());
                }
            });
        }
        for (Container flow : flows) {
            if (!flow.getName().equals(currentFlowName)) continue;
            return FlowNameValidator.buildMessage(currentFlowName);
        }
        if (StringUtils.containsAny((CharSequence)currentFlowName, (CharSequence[])INVALID_CHARACTERS)) {
            return FLOW_NAME_SHOULD_NOT_CONTAIN_INVALID_CHARACTERS;
        }
        return null;
    }

    public static String buildMessage(String currentFlowName) {
        return "Flow name should be unique (\"" + currentFlowName + "\")";
    }

    private static <T> void inplaceRemove(Collection<T> collection, Pred<T> pred) {
        Object toRemove = null;
        for (T t : collection) {
            if (!pred.eval(t)) continue;
            toRemove = t;
        }
        if (toRemove != null) {
            collection.remove(toRemove);
        }
    }

    private static interface Pred<T> {
        public boolean eval(T var1);
    }
}

