/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.dialog;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.messageflow.dialog.FlowNameValidator;
import org.mule.tooling.messageflow.dialog.IMessageDisplay;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;

public class FlowDocumentationPage
extends MessageFlowNodeComposite {
    private static final Message FLOW_NAME_SHOULD_NOT_CONTAIN_SPACES = MessageBuilder.newErrorMessage((String)"Flow name should not contain spaces").build();
    private static final Message FLOW_NAME_IS_REQUIRED = MessageBuilder.newErrorMessage((String)"Flow should have 'name' attribute defined").build();
    private Text txtName;
    private Text txtDescription;
    private Composite docGroup;
    private ControlDecoration errorDecoration;
    private boolean allowSpaces;
    private IMessageDisplay parentDialog;
    private Label descLabel;
    private final AttributeContext context;

    public FlowDocumentationPage(IMuleProject muleProject, Composite parent, boolean allowSpaces, IMessageDisplay parentDialog, AttributeContext context) {
        super(muleProject, parent);
        this.parentDialog = parentDialog;
        this.allowSpaces = allowSpaces;
        this.context = context;
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.docGroup = new Group((Composite)this, 0);
        GridLayout docLayout = new GridLayout(2, false);
        docLayout.marginWidth = 0;
        docLayout.marginHeight = 0;
        this.docGroup.setLayout((Layout)docLayout);
        docLayout.horizontalSpacing = 10;
        Label nameLabel = new Label(this.docGroup, 0);
        nameLabel.setText("Name:");
        this.txtName = new Text(this.docGroup, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.errorDecoration = new ControlDecoration((Control)this.txtName, 17408);
        this.errorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.errorDecoration.hide();
        this.descLabel = new Label(this.docGroup, 0);
        this.descLabel.setText("Description:");
        this.descLabel.setLayoutData((Object)new GridData(2));
        ControlDecoration infoDecoration = new ControlDecoration((Control)this.descLabel, 131200);
        infoDecoration.setMarginWidth(1);
        infoDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        infoDecoration.setDescriptionText("Use this area to document your use case for this flow");
        infoDecoration.setShowHover(true);
        this.errorDecoration.setDescriptionText(FLOW_NAME_SHOULD_NOT_CONTAIN_SPACES.getMessage());
        this.txtDescription = new Text(this.docGroup, 2114);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FlowDocumentationPage.this.validate();
            }
        });
        GridData data = new GridData(1808);
        this.txtDescription.setLayoutData((Object)data);
        this.txtName.setTextLimit(100);
        this.txtDescription.setTextLimit(1000);
        this.docGroup.setLayoutData((Object)new GridData(1808));
        this.setLayoutData(new GridData(1808));
    }

    public Label getDescLabel() {
        return this.descLabel;
    }

    protected void validate() {
        String errorMessage;
        String text;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (!this.allowSpaces) {
            text = this.txtName.getText();
            int a = 0;
            while (a < text.length()) {
                char c = text.charAt(a);
                if (Character.isWhitespace(c)) {
                    messages.add(FLOW_NAME_SHOULD_NOT_CONTAIN_SPACES);
                }
                ++a;
            }
        }
        if ((text = this.txtName.getText()) == null || text.length() == 0) {
            messages.add(FLOW_NAME_IS_REQUIRED);
        }
        if ((errorMessage = FlowNameValidator.validate(text, this.context)) != null) {
            messages.add(MessageBuilder.newErrorMessage((String)errorMessage).build());
        }
        if (messages.isEmpty()) {
            this.errorDecoration.hide();
        } else {
            this.errorDecoration.show();
        }
        this.parentDialog.setMessages(messages);
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.txtName.setText(StringUtils.defaultString((String)node.getName()));
        this.txtDescription.setText(StringUtils.defaultString((String)node.getDescription()));
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap updated) {
        node.setName(this.txtName.getText());
        node.setDescription(this.txtDescription.getText());
    }
}

